/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ejc;

import java.util.Collection;
import java.util.HashSet;
import org.milyn.ejc.IllegalNameException;
import org.milyn.javabean.pojogen.JType;

public class EJCUtils {
    private static HashSet<String> reservedKeywords;

    public static String encodeClassName(String name) throws IllegalNameException {
        String result = name;
        if (!name.toUpperCase().equals(name)) {
            result = name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
        }
        result = EJCUtils.deleteWithPascalNotation(result, '-');
        result = EJCUtils.deleteWithPascalNotation(result, ' ');
        EJCUtils.assertLegalName(result);
        return result;
    }

    public static String encodeAttributeName(JType type, String name) throws IllegalNameException {
        String result = name;
        if (!name.toUpperCase().equals(name)) {
            result = name.substring(0, 1).toLowerCase() + name.substring(1, name.length());
        }
        result = EJCUtils.deleteWithPascalNotation(result, '-');
        result = EJCUtils.deleteWithPascalNotation(result, ' ');
        if (type != null && Collection.class.isAssignableFrom(type.getClass())) {
            result = result + "s";
        }
        EJCUtils.assertLegalName(result);
        return result;
    }

    public static String deleteWithPascalNotation(String value, char deleteChar) {
        StringBuilder result = new StringBuilder();
        boolean matchPrevious = false;
        for (int i = 0; i < value.length(); ++i) {
            char currentChar = value.charAt(i);
            if (currentChar == deleteChar) {
                matchPrevious = true;
                continue;
            }
            if (matchPrevious) {
                currentChar = Character.toUpperCase(currentChar);
                matchPrevious = false;
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    private static void assertLegalName(String name) throws IllegalNameException {
        if (reservedKeywords.contains(name)) {
            throw new IllegalNameException("Illegal attribute- or class-name. The name [" + name + "] is a reserved keyword in java.");
        }
    }

    static {
        String[] words;
        reservedKeywords = new HashSet();
        for (String w : words = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "assert", "enum"}) {
            reservedKeywords.add(w);
        }
    }
}

