/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ejc;

import java.util.ArrayList;
import java.util.List;
import org.milyn.ejc.BindingConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassConfig {
    private Class beanClass;
    private String beanId;
    private List<BindingConfig> bindings = new ArrayList<BindingConfig>();
    private boolean isArray;
    private String elementName;

    public ClassConfig(Class beanClass, String elementName) {
        this.beanClass = beanClass;
        this.elementName = elementName;
    }

    public ClassConfig(Class beanClass, String beanId, String elementName) {
        this.beanClass = beanClass;
        if (beanId == null) {
            beanId = this.getClassName(beanClass.getName());
            beanId = beanId.substring(0, 1).toLowerCase() + beanId.substring(1);
        }
        this.beanId = beanId;
        this.elementName = elementName;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public String getElementName() {
        return this.elementName;
    }

    public List<BindingConfig> getBindings() {
        return this.bindings;
    }

    public void setBindings(List<BindingConfig> bindings) {
        this.bindings = bindings;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean array) {
        this.isArray = array;
    }

    public String getBeanId() {
        if (this.beanId != null) {
            return this.beanId;
        }
        StringBuilder beanId = new StringBuilder(this.beanClass.getSimpleName());
        beanId.setCharAt(0, Character.toLowerCase(beanId.charAt(0)));
        return beanId.toString();
    }

    private String getClassName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }
}

