/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ejc;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.milyn.assertion.AssertArgument;
import org.milyn.ejc.BindingConfig;
import org.milyn.ejc.ClassConfig;
import org.milyn.ejc.ClassModel;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.pojogen.JClass;
import org.milyn.javabean.pojogen.JNamedType;
import org.milyn.util.FreeMarkerTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingWriter {
    private ClassModel classModel;
    private List<String> packagesIncluded;
    private List<String> packagesExcluded;
    private Stack<JClass> classStack = new Stack();
    private FreeMarkerTemplate template = new FreeMarkerTemplate("templates/bindingConfig.ftl.xml", BindingWriter.class);

    public BindingWriter(ClassModel classModel) throws ClassNotFoundException {
        AssertArgument.isNotNull((Object)classModel, (String)"classModel");
        this.packagesExcluded = null;
        this.packagesIncluded = this.parsePackages(classModel.getRoot().getPackageName());
        this.classModel = classModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(String bindingfile) throws IOException {
        HashMap<String, Object> templatingContextObject = new HashMap<String, Object>();
        ArrayList<ClassConfig> classConfigs = new ArrayList<ClassConfig>();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(new FileOutputStream(bindingfile));
            this.addClassConfig(classConfigs, this.classModel.getRoot(), null);
            templatingContextObject.put("classConfigs", classConfigs);
            templatingContextObject.put("classPackage", this.classModel.getRoot().getPackageName().replace('.', '/'));
            writer.write(this.template.apply(templatingContextObject));
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassConfig addClassConfig(List<ClassConfig> classConfigs, JClass beanClass, String beanId) {
        if (this.classStack.contains(beanClass)) {
            return null;
        }
        this.classStack.push(beanClass);
        try {
            ClassConfig classConfig = new ClassConfig(beanClass.getSkeletonClass(), beanId, this.classModel.getClassXmlElementName(beanClass.getClassName()));
            List fields = beanClass.getProperties();
            List<BindingConfig> bindings = classConfig.getBindings();
            String rootPackage = this.classModel.getRoot().getPackageName();
            classConfigs.add(classConfig);
            for (JNamedType field : fields) {
                Class type = field.getType().getType();
                Class decoder = DataDecoder.Factory.getInstance((Class)type);
                if (decoder != null) {
                    String xmlElementName = this.classModel.getClassXmlElementName(beanClass.getClassName()) + " " + this.classModel.getPropertyXmlElementName(beanClass.getClassName(), field.getName());
                    List<Map.Entry<String, String>> decoderConfigs = this.classModel.getPropertyDecoderConfigs(beanClass.getClassName(), field.getName());
                    bindings.add(new BindingConfig(field, xmlElementName, decoderConfigs));
                    continue;
                }
                if (Collection.class.isAssignableFrom(type)) {
                    this.addCollectionConfig(classConfigs, bindings, rootPackage, field, beanClass);
                    continue;
                }
                String typePackage = this.getPackageName(type.getName());
                if (this.isExcluded(typePackage) || !typePackage.startsWith(rootPackage) && !this.isIncluded(typePackage)) continue;
                String xmlElementName = this.classModel.getPropertyXmlElementName(this.getClassName(type.getName()), field.getName());
                if (field.getName() == null) {
                    xmlElementName = this.classModel.getClassXmlElementName(this.getClassName(type.getName())) + xmlElementName;
                }
                bindings.add(new BindingConfig(field, field.getName(), xmlElementName));
                String className = this.getClassName(field.getType().getType().getName());
                this.addClassConfig(classConfigs, this.classModel.getCreatedClasses().get(className), field.getName());
            }
            ClassConfig classConfig2 = classConfig;
            return classConfig2;
        }
        finally {
            this.classStack.pop();
        }
    }

    private String getClassName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private String getPackageName(String name) {
        return name.substring(0, name.lastIndexOf(46));
    }

    private void addCollectionConfig(List<ClassConfig> classConfigs, List<BindingConfig> bindings, String rootPackage, JNamedType field, JClass beanClass) {
        Class paramType = field.getType().getGenericType();
        if (paramType != null) {
            String wireBeanId = field.getName() + "_entry";
            String typePackage = this.getPackageName(paramType.getName());
            if (this.isExcluded(typePackage)) {
                return;
            }
            if (typePackage.startsWith(rootPackage) || this.isIncluded(typePackage)) {
                ClassConfig listConfig = new ClassConfig(ArrayList.class, field.getName(), this.classModel.getClassXmlElementName(beanClass.getClassName()));
                String xmlElementName = this.classModel.getPropertyXmlElementName(this.getClassName(paramType.getName()), field.getName());
                if (field.getName() == null) {
                    xmlElementName = this.classModel.getClassXmlElementName(beanClass.getClassName()) + xmlElementName;
                }
                listConfig.getBindings().add(new BindingConfig(wireBeanId, xmlElementName));
                classConfigs.add(listConfig);
                bindings.add(new BindingConfig(field, field.getName(), xmlElementName));
                String className = this.getClassName(paramType.getName());
                this.addClassConfig(classConfigs, this.classModel.getCreatedClasses().get(className), wireBeanId);
            }
        }
    }

    private boolean isIncluded(String packageName) {
        return this.packagesIncluded != null && this.isInPackageList(this.packagesIncluded, packageName);
    }

    private boolean isExcluded(String packageName) {
        return this.packagesExcluded != null && this.isInPackageList(this.packagesExcluded, packageName);
    }

    private boolean isInPackageList(List<String> packages, String typePackage) {
        for (String packageName : packages) {
            if (!typePackage.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    private List<String> parsePackages(String packagesString) {
        String[] packages = packagesString.split(";");
        ArrayList<String> packagesSet = new ArrayList<String>();
        for (String aPackage : packages) {
            packagesSet.add(aPackage.trim());
        }
        return packagesSet;
    }
}

