/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ejc;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.ejc.BeanWriter;
import org.milyn.ejc.BindingWriter;
import org.milyn.ejc.ClassModel;
import org.milyn.ejc.EJCLog;
import org.milyn.ejc.EJCLogFactory;
import org.milyn.ejc.EdiConfigReader;
import org.milyn.ejc.IllegalNameException;
import org.milyn.io.FileUtils;
import org.milyn.io.StreamUtils;
import org.xml.sax.SAXException;

public class EJC {
    private static Log LOG = EJCLogFactory.getLog(EJC.class);
    private static final String VERISON = "0.1";
    private static final String PARAMETER_BEAN_FOLDER = "-d";
    private static final String PARAMETER_BEAN_PACKAGE = "-p";
    private static final String PARAMETER_VERBOSE = "-version";
    private static final String PARAMETER_QUIET = "-quiet";
    private static final String PARAMETER_HELP = "-help";
    private static final String PARAMETER_VERSION = "-version";

    public void compile(InputStream configFile, String configName, String beanPackage, String beanFolder) throws EDIConfigurationException, IOException, SAXException, IllegalNameException, ClassNotFoundException {
        String bindingFile = beanFolder + "/" + beanPackage.replace('.', '/') + "/bindingconfig.xml";
        Edimap edimap = this.readEDIConfig(configFile);
        LOG.info((Object)"Reading the edi-configuration...");
        EdiConfigReader ediConfigReader = new EdiConfigReader();
        ClassModel model = ediConfigReader.parse(edimap, beanPackage);
        LOG.info((Object)("Writing java beans to " + beanFolder + "..."));
        BeanWriter.writeBeans(model, beanFolder, bindingFile);
        LOG.info((Object)"Creating bindingfile...");
        String bundleConfigPath = "/" + beanPackage.replace('.', '/') + "/edimappingconfig.xml";
        FileUtils.copyFile((String)configName, (String)(beanFolder + bundleConfigPath));
        BindingWriter bindingWriter = new BindingWriter(model);
        bindingWriter.generate(bindingFile);
        LOG.info((Object)"-----------------------------------------------------------------------");
        LOG.info((Object)" Compiltation complete.");
        LOG.info((Object)"-----------------------------------------------------------------------");
        LOG.info((Object)" Files are located in folder ");
        LOG.info((Object)(" " + beanFolder));
        LOG.info((Object)"-----------------------------------------------------------------------");
    }

    private Edimap readEDIConfig(InputStream inputStream) throws EDIConfigurationException, IOException, SAXException {
        EdifactModel edifactModel = new EdifactModel();
        edifactModel.parseSequence(inputStream);
        return edifactModel.getEdimap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, EDIConfigurationException, IllegalNameException, SAXException, ClassNotFoundException {
        EJC ejc = new EJC();
        if (args.length % 2 == 0) {
            System.out.println(EJC.writeUsageText());
            return;
        }
        String configFile = args[args.length - 1];
        String beanPackage = EJC.getParameter(PARAMETER_BEAN_PACKAGE, args);
        String beanFolder = EJC.getParameter(PARAMETER_BEAN_FOLDER, args);
        boolean isVerbose = EJC.containsParameter("-version", args);
        boolean isQuiet = EJC.containsParameter(PARAMETER_QUIET, args);
        if (EJC.containsParameter(PARAMETER_HELP, args)) {
            System.out.println(EJC.writeAboutText());
            System.out.println(EJC.writeUsageText());
            if (args.length == 1) {
                return;
            }
        }
        if (EJC.containsParameter("-version", args)) {
            System.out.println(EJC.writeVersionText());
            if (args.length == 1) {
                return;
            }
        }
        if (isVerbose && isQuiet) {
            LOG.error((Object)"Both 'quiet' and 'verbose' is activated. Only one of these can be active at once.");
            return;
        }
        ((EJCLog)LOG).setLevel(isVerbose ? EJCLogFactory.Level.DEBUG : (isQuiet ? EJCLogFactory.Level.ERROR : EJCLogFactory.Level.INFO));
        InputStream configInputStream = null;
        try {
            configInputStream = new ByteArrayInputStream(StreamUtils.readStream((InputStream)new FileInputStream(configFile)));
            ejc.compile(configInputStream, configFile, beanPackage, beanFolder);
        }
        finally {
            if (configInputStream != null) {
                configInputStream.close();
            }
        }
    }

    private static String writeAboutText() {
        return "\n\n***********************************************************************\n* A toolkit for compiling an edi-mapping-file into a class-structure  *\n* with a corresponding binding-config-file.                           *\n***********************************************************************\n";
    }

    private static String writeUsageText() {
        return "Usage: " + EJC.class.getName() + " [-options ...] <edi file/URL/dir>\n" + "Options:\n" + "\n" + "  -d <dir>           :  generated files will go into this directory\n" + "  -p <pkg>           :  specifies the target package\n" + "\n" + "  -verbose           :  be extra verbose\n" + "  -quiet             :  suppress compiler output\n" + "  -help              :  display this help message\n" + "  -version           :  display version information\n\n\n";
    }

    private static String writeVersionText() {
        return "ejc version 0.1\nMilyn Smooks toolkit for binding edi.";
    }

    private static String getParameter(String flag, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(flag) || i + 1 >= args.length) continue;
            return args[i + 1];
        }
        throw new RuntimeException("Mandatory command line parameter '' not specified.\n\n" + EJC.writeUsageText());
    }

    private static boolean containsParameter(String flag, String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase(flag)) continue;
            return true;
        }
        return false;
    }
}

