/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.ejc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.milyn.ejc.ClassModel;
import org.milyn.ejc.EJCLogFactory;
import org.milyn.ejc.EJCUtils;
import org.milyn.ejc.EdiConfigReader;
import org.milyn.ejc.IllegalNameException;
import org.milyn.javabean.pojogen.JClass;
import org.milyn.util.FreeMarkerTemplate;

public class BeanWriter {
    private static Log LOG = EJCLogFactory.getLog(EdiConfigReader.class);

    public static void writeBeans(ClassModel model, String folder, String bindingFile) throws IOException, IllegalNameException {
        folder = new File(folder).getCanonicalPath();
        for (JClass bean : model.getCreatedClasses().values()) {
            BeanWriter.writeToFile(folder, bean);
        }
        BeanWriter.writeFactoryClass(folder, model.getRoot(), bindingFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFactoryClass(String folder, JClass rootClass, String bindingFile) throws IllegalNameException, IOException {
        String packageName = rootClass.getPackageName();
        String className = rootClass.getClassName();
        String classId = EJCUtils.encodeAttributeName(null, rootClass.getClassName());
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("package", packageName);
        configs.put("className", className);
        configs.put("classId", classId);
        configs.put("bindingFile", new File(bindingFile).getName());
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter writer = null;
        try {
            File file = new File(folder + "/" + packageName.replace(".", "/"));
            fileOutputStream = new FileOutputStream(file.getCanonicalPath() + "/" + className + "Factory.java");
            writer = new OutputStreamWriter(fileOutputStream);
            FreeMarkerTemplate template = new FreeMarkerTemplate("templates/factoryClass.ftl.xml", BeanWriter.class);
            writer.write(template.apply(configs));
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(String folder, JClass bean) throws IOException {
        File file = new File(folder + "/" + bean.getPackageName().replace(".", "/"));
        if (!file.exists()) {
            file.mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileOutputStream = new FileOutputStream(file.getCanonicalPath() + "/" + bean.getClassName() + ".java");
            outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            bean.writeClass((Writer)outputStreamWriter);
        }
        finally {
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }
}

