/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.json;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.milyn.cdr.Parameter;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.Config;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.json.KeyMapDigester;
import org.milyn.xml.SmooksXMLReader;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONReader
implements SmooksXMLReader {
    private static Log logger = LogFactory.getLog(JSONReader.class);
    private static final String CONFIG_PARAM_KEY_MAP = "keyMap";
    private static final String XML_ROOT = "json";
    private static final String XML_ARRAY_ELEMENT_NAME = "element";
    private static final String DEFAULT_NULL_VALUE_REPLACEMENT = "";
    private static final Attributes EMPTY_ATTRIBS = new AttributesImpl();
    private static final JsonFactory jsonFactory = new JsonFactory();
    private ContentHandler contentHandler;
    private ExecutionContext executionContext;
    @ConfigParam(defaultVal="json")
    private String rootName;
    @ConfigParam(defaultVal="element")
    private String arrayElementName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String keyWhitspaceReplacement;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String keyPrefixOnNumeric;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String illegalElementNameCharReplacement;
    @ConfigParam(defaultVal="")
    private String nullValueReplacement;
    @ConfigParam(defaultVal="UTF-8")
    private Charset encoding;
    private boolean doKeyReplacement = false;
    private boolean doKeyWhitspaceReplacement = false;
    private boolean doPrefixOnNumericKey = false;
    private boolean doIllegalElementNameCharReplacement = false;
    private HashMap<String, String> keyMap = new HashMap();
    @Config
    private SmooksResourceConfiguration config;

    @Initialize
    public void initialize() {
        this.initKeyMap();
        this.doKeyReplacement = !this.keyMap.isEmpty();
        this.doKeyWhitspaceReplacement = this.keyWhitspaceReplacement != null;
        this.doPrefixOnNumericKey = this.keyPrefixOnNumeric != null;
        this.doIllegalElementNameCharReplacement = this.illegalElementNameCharReplacement != null;
    }

    public void setExecutionContext(ExecutionContext request) {
        this.executionContext = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource csvInputSource) throws IOException, SAXException {
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse JSON stream.");
        }
        if (this.executionContext == null) {
            throw new IllegalStateException("Smooks container 'executionContext' not set.  Cannot parse JSON stream.");
        }
        Reader jsonStreamReader = csvInputSource.getCharacterStream();
        if (jsonStreamReader == null) {
            jsonStreamReader = new InputStreamReader(csvInputSource.getByteStream(), this.encoding);
        }
        JsonParser jp = null;
        try {
            JsonToken t;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Creating JSON parser");
            }
            jp = jsonFactory.createJsonParser(jsonStreamReader);
            this.contentHandler.startDocument();
            this.contentHandler.startElement(DEFAULT_NULL_VALUE_REPLACEMENT, this.rootName, DEFAULT_NULL_VALUE_REPLACEMENT, EMPTY_ATTRIBS);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Starting JSON parsing");
            }
            boolean first = true;
            Stack<String> elementStack = new Stack<String>();
            Stack<Type> typeStack = new Stack<Type>();
            while ((t = jp.nextToken()) != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Token: " + t.name()));
                }
                switch (t) {
                    case START_OBJECT: 
                    case START_ARRAY: {
                        if (!first && !typeStack.empty() && typeStack.peek() == Type.ARRAY) {
                            this.contentHandler.startElement(DEFAULT_NULL_VALUE_REPLACEMENT, this.arrayElementName, DEFAULT_NULL_VALUE_REPLACEMENT, EMPTY_ATTRIBS);
                        }
                        typeStack.push(t == JsonToken.START_ARRAY ? Type.ARRAY : Type.OBJECT);
                        break;
                    }
                    case END_OBJECT: 
                    case END_ARRAY: {
                        boolean typeStackPeekIsArray;
                        typeStack.pop();
                        boolean bl = typeStackPeekIsArray = !typeStack.empty() && typeStack.peek() == Type.ARRAY;
                        if (!elementStack.empty() && !typeStackPeekIsArray) {
                            this.contentHandler.endElement(DEFAULT_NULL_VALUE_REPLACEMENT, (String)elementStack.pop(), DEFAULT_NULL_VALUE_REPLACEMENT);
                        }
                        if (!typeStackPeekIsArray) break;
                        this.contentHandler.endElement(DEFAULT_NULL_VALUE_REPLACEMENT, this.arrayElementName, DEFAULT_NULL_VALUE_REPLACEMENT);
                        break;
                    }
                    case FIELD_NAME: {
                        String text = jp.getText();
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Field name: " + text));
                        }
                        String name = this.getElementName(text);
                        this.contentHandler.startElement(DEFAULT_NULL_VALUE_REPLACEMENT, name, DEFAULT_NULL_VALUE_REPLACEMENT, EMPTY_ATTRIBS);
                        elementStack.add(name);
                        break;
                    }
                    default: {
                        String value = t == JsonToken.VALUE_NULL ? this.nullValueReplacement : jp.getText();
                        if (typeStack.peek() == Type.ARRAY) {
                            this.contentHandler.startElement(DEFAULT_NULL_VALUE_REPLACEMENT, this.arrayElementName, DEFAULT_NULL_VALUE_REPLACEMENT, EMPTY_ATTRIBS);
                        }
                        this.contentHandler.characters(value.toCharArray(), 0, value.length());
                        if (typeStack.peek() == Type.ARRAY) {
                            this.contentHandler.endElement(DEFAULT_NULL_VALUE_REPLACEMENT, this.arrayElementName, DEFAULT_NULL_VALUE_REPLACEMENT);
                            break;
                        }
                        this.contentHandler.endElement(DEFAULT_NULL_VALUE_REPLACEMENT, (String)elementStack.pop(), DEFAULT_NULL_VALUE_REPLACEMENT);
                    }
                }
                first = false;
            }
            this.contentHandler.endElement(DEFAULT_NULL_VALUE_REPLACEMENT, this.rootName, DEFAULT_NULL_VALUE_REPLACEMENT);
            this.contentHandler.endDocument();
        }
        finally {
            try {
                jp.close();
            }
            catch (Exception e) {}
        }
    }

    private String getElementName(String text) {
        boolean replacedKey = false;
        if (this.doKeyReplacement) {
            String mappedKey = this.keyMap.get(text);
            boolean bl = replacedKey = mappedKey != null;
            if (replacedKey) {
                text = mappedKey;
            }
        }
        if (!replacedKey) {
            if (this.doKeyWhitspaceReplacement) {
                text = text.replace(" ", this.keyWhitspaceReplacement);
            }
            if (this.doPrefixOnNumericKey && Character.isDigit(text.charAt(0))) {
                text = this.keyPrefixOnNumeric + text;
            }
            if (this.doIllegalElementNameCharReplacement) {
                text = text.replaceAll("^[.]|[^a-zA-Z0-9_.-]", this.illegalElementNameCharReplacement);
            }
        }
        return text;
    }

    private void initKeyMap() {
        Parameter keyMapParam = this.config.getParameter(CONFIG_PARAM_KEY_MAP);
        if (keyMapParam != null) {
            Element keyMapParamElement = keyMapParam.getXml();
            if (keyMapParamElement != null) {
                this.setKeyMap(KeyMapDigester.digest(keyMapParamElement));
            } else {
                logger.error((Object)"Sorry, the key properties must be available as XML DOM. Please configure using XML.");
            }
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public HashMap<String, String> getKeyMap() {
        return this.keyMap;
    }

    public void setKeyMap(HashMap<String, String> keyMap) {
        this.keyMap = keyMap;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public String getArrayElementName() {
        return this.arrayElementName;
    }

    public void setArrayElementName(String arrayElementName) {
        this.arrayElementName = arrayElementName;
    }

    public String getKeyWhitspaceReplacement() {
        return this.keyWhitspaceReplacement;
    }

    public void setKeyWhitspaceReplacement(String keyWhitspaceReplacement) {
        this.keyWhitspaceReplacement = keyWhitspaceReplacement;
    }

    public String getKeyPrefixOnNumeric() {
        return this.keyPrefixOnNumeric;
    }

    public void setKeyPrefixOnNumeric(String keyPrefixOnNumeric) {
        this.keyPrefixOnNumeric = keyPrefixOnNumeric;
    }

    public String getIllegalElementNameCharReplacement() {
        return this.illegalElementNameCharReplacement;
    }

    public void setIllegalElementNameCharReplacement(String illegalElementNameCharReplacement) {
        this.illegalElementNameCharReplacement = illegalElementNameCharReplacement;
    }

    public String getNullValueReplacement() {
        return this.nullValueReplacement;
    }

    public void setNullValueReplacement(String nullValueReplacement) {
        this.nullValueReplacement = nullValueReplacement;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler arg0) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        OBJECT,
        ARRAY;

    }
}

