/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.persistence;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.persistence.NonUniqueResultException;
import org.apache.commons.lang.StringUtils;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.javabean.repository.BeanId;
import org.milyn.javabean.repository.BeanIdRegister;
import org.milyn.javabean.repository.BeanRepository;
import org.milyn.javabean.repository.BeanRepositoryManager;
import org.milyn.persistence.ApplicationContextObjectStore;
import org.milyn.persistence.NoLookupResultException;
import org.milyn.persistence.OnNoResult;
import org.milyn.persistence.ParameterListType;
import org.milyn.persistence.parameter.NamedParameterContainer;
import org.milyn.persistence.parameter.Parameter;
import org.milyn.persistence.parameter.ParameterContainer;
import org.milyn.persistence.parameter.ParameterIndex;
import org.milyn.persistence.parameter.ParameterManager;
import org.milyn.persistence.parameter.PositionalParameterContainer;
import org.milyn.persistence.util.PersistenceUtil;
import org.milyn.scribe.ObjectStore;
import org.milyn.scribe.invoker.DaoInvoker;
import org.milyn.scribe.invoker.DaoInvokerFactory;
import org.milyn.scribe.register.DaoRegister;
import org.milyn.util.CollectionsUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@VisitBeforeReport(summary="Initializing parameter container to hold the parameters needed for the lookup.", detailTemplate="reporting/EntityLocator_before.html")
@VisitAfterReport(summary="Looking up entity to put under beanId '${resource.parameters.beanId}'.", detailTemplate="reporting/EntityLocator_after.html")
public class EntityLocator
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter,
Producer,
Consumer {
    @ConfigParam
    private int id;
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(name="dao", use=ConfigParam.Use.OPTIONAL)
    private String daoName;
    @ConfigParam(name="lookup", use=ConfigParam.Use.OPTIONAL)
    private String lookupName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String query;
    @ConfigParam(defaultVal="NULLIFY", decoder=OnNoResult.DataDecoder.class)
    private OnNoResult onNoResult;
    @ConfigParam(defaultVal="false")
    private boolean uniqueResult;
    @ConfigParam(defaultVal="NAMED", decoder=ParameterListType.DataDecoder.class)
    private ParameterListType parameterListType;
    @AppContext
    private ApplicationContext appContext;
    private ApplicationContextObjectStore objectStore;
    private ParameterIndex<?, ?> parameterIndex;
    private BeanId beanId;

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        if (StringUtils.isEmpty((String)this.lookupName) && StringUtils.isEmpty((String)this.query)) {
            throw new SmooksConfigurationException("A lookup name or  a query  needs to be set to be able to lookup anything");
        }
        if (StringUtils.isNotEmpty((String)this.lookupName) && StringUtils.isNotEmpty((String)this.query)) {
            throw new SmooksConfigurationException("Both the lookup name and the query can't be set at the same time");
        }
        BeanIdRegister beanIdRegister = BeanRepositoryManager.getInstance((ApplicationContext)this.appContext).getBeanIdRegister();
        this.beanId = beanIdRegister.register(this.beanIdName);
        this.parameterIndex = ParameterManager.initializeParameterIndex(this.id, this.parameterListType, this.appContext);
        this.objectStore = new ApplicationContextObjectStore(this.appContext);
    }

    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet((Object[])new String[]{this.beanIdName});
    }

    public boolean consumes(Object object) {
        return this.parameterIndex.containsParameter(object);
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.initParameterContainer(executionContext);
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.initParameterContainer(executionContext);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.lookup(executionContext);
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.lookup(executionContext);
    }

    public void initParameterContainer(ExecutionContext executionContext) {
        ParameterManager.initializeParameterContainer(this.id, this.parameterListType, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void lookup(ExecutionContext executionContext) {
        DaoRegister<?> emr = PersistenceUtil.getDAORegister(executionContext);
        Object dao = null;
        try {
            dao = this.daoName == null ? emr.getDefaultDao() : emr.getDao(this.daoName);
            if (dao == null) {
                throw new IllegalStateException("The DAO register returned null while getting the DAO '" + this.daoName + "'");
            }
            Object result = this.lookup(dao, executionContext);
            if (this.uniqueResult) {
                if (!(result instanceof Collection)) throw new SmooksConfigurationException("The returned result doesn't implement the '" + Collection.class.getName() + "' interface " + "and there for the unique result check can't be done.");
                Collection resultCollection = (Collection)result;
                if (resultCollection.size() == 1) {
                    for (Object value : resultCollection) {
                        result = value;
                    }
                } else {
                    if (resultCollection.size() != 1) throw new NonUniqueResultException("The DAO '" + this.daoName + "' returned multiple results for the lookup '" + this.lookupName + "'");
                    result = null;
                }
            }
            if (result == null && this.onNoResult == OnNoResult.EXCEPTION) {
                if (this.lookupName == null) throw new NoLookupResultException("The DAO '" + this.daoName + "' returned no results found for query '" + this.query + "'");
                throw new NoLookupResultException("The DAO '" + this.daoName + "' returned no results for lookup '" + this.lookupName + "'");
            }
            BeanRepository beanRepository = BeanRepository.getInstance((ExecutionContext)executionContext);
            if (result == null) {
                beanRepository.removeBean(this.beanId);
                return;
            } else {
                beanRepository.addBean(this.beanId, result);
            }
            return;
        }
        finally {
            if (dao != null) {
                emr.returnDao(dao);
            }
        }
    }

    public Object lookup(Object dao, ExecutionContext executionContext) {
        ParameterContainer<Parameter<?>> container = ParameterManager.getParameterContainer(this.id, executionContext);
        DaoInvoker daoInvoker = DaoInvokerFactory.getInstance().create(dao, (ObjectStore)this.objectStore);
        if (this.query == null) {
            if (this.parameterListType == ParameterListType.NAMED) {
                return daoInvoker.lookup(this.lookupName, ((NamedParameterContainer)container).getParameterMap());
            }
            return daoInvoker.lookup(this.lookupName, ((PositionalParameterContainer)container).getValues());
        }
        if (this.parameterListType == ParameterListType.NAMED) {
            return daoInvoker.lookupByQuery(this.query, ((NamedParameterContainer)container).getParameterMap());
        }
        return daoInvoker.lookupByQuery(this.query, ((PositionalParameterContainer)container).getValues());
    }
}

