/*
	Milyn - Copyright (C) 2006

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License (version 2.1) as published by the Free Software
	Foundation.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU Lesser General Public License for more details:
	http://www.gnu.org/licenses/lgpl.txt
*/
package org.milyn.persistence.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author <a href="mailto:maurice.zeijen@smies.com">maurice.zeijen@smies.com</a>
 *
 */
public class PositionalParameterIndex extends ParameterIndex<Integer, PositionalParameter>{

	/* (non-Javadoc)
	 * @see org.milyn.scribe.parameter.Index#createParameter(java.lang.Object)
	 */
	@Override
	protected PositionalParameter createParameter(Integer value) {
		return new PositionalParameter(this, value);
	}

	/* (non-Javadoc)
	 * @see org.milyn.persistence.parameter.ParameterIndex#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if(obj == this) {
			return true;
		}
		if(obj instanceof PositionalParameterIndex == false) {
			return false;
		}
		return equals((ParameterIndex<?,?>)obj);
	}
}
