/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.persistence;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.annotation.VisitAfterIf;
import org.milyn.delivery.annotation.VisitBeforeIf;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.javabean.repository.BeanId;
import org.milyn.javabean.repository.BeanIdRegister;
import org.milyn.javabean.repository.BeanRepository;
import org.milyn.javabean.repository.BeanRepositoryManager;
import org.milyn.persistence.ApplicationContextObjectStore;
import org.milyn.persistence.util.PersistenceUtil;
import org.milyn.scribe.ObjectStore;
import org.milyn.scribe.invoker.DaoInvoker;
import org.milyn.scribe.invoker.DaoInvokerFactory;
import org.milyn.scribe.register.DaoRegister;
import org.milyn.util.CollectionsUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@VisitBeforeIf(condition="parameters.containsKey('updateBefore') && parameters.updateBefore.value == 'true'")
@VisitAfterIf(condition="!parameters.containsKey('updateBefore') || parameters.updateBefore.value != 'true'")
@VisitBeforeReport(summary="Updating bean under beanId '${resource.parameters.beanId}'.", detailTemplate="reporting/EntityUpdater.html")
@VisitAfterReport(summary="Updating bean under beanId '${resource.parameters.beanId}'.", detailTemplate="reporting/EntityUpdater.html")
public class EntityUpdater
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter,
Producer,
Consumer {
    private static Log logger = LogFactory.getLog(EntityUpdater.class);
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(name="updatedBeanId", use=ConfigParam.Use.OPTIONAL)
    private String updatedBeanIdName;
    @ConfigParam(name="dao", use=ConfigParam.Use.OPTIONAL)
    private String daoName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String name;
    @AppContext
    private ApplicationContext appContext;
    private ObjectStore objectStore;
    private BeanId beanId;
    private BeanId updatedBeanId;

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        BeanIdRegister beanIdRegister = BeanRepositoryManager.getInstance((ApplicationContext)this.appContext).getBeanIdRegister();
        this.beanId = beanIdRegister.register(this.beanIdName);
        if (this.updatedBeanIdName != null) {
            this.updatedBeanId = beanIdRegister.register(this.updatedBeanIdName);
        }
        this.objectStore = new ApplicationContextObjectStore(this.appContext);
    }

    public Set<? extends Object> getProducts() {
        if (this.updatedBeanIdName == null) {
            return Collections.emptySet();
        }
        return CollectionsUtil.toSet((Object[])new String[]{this.updatedBeanIdName});
    }

    public boolean consumes(Object object) {
        return object.equals(this.beanIdName);
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.update(executionContext);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.update(executionContext);
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.update(executionContext);
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.update(executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(ExecutionContext executionContext) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating bean under BeanId '" + this.beanIdName + "' with DAO '" + this.daoName + "'."));
        }
        BeanRepository beanRepository = BeanRepositoryManager.getBeanRepository((ExecutionContext)executionContext);
        Object bean = beanRepository.getBean(this.beanId);
        DaoRegister<?> emr = PersistenceUtil.getDAORegister(executionContext);
        Object dao = null;
        try {
            Object result;
            dao = this.daoName == null ? emr.getDefaultDao() : emr.getDao(this.daoName);
            if (dao == null) {
                throw new IllegalStateException("The DAO register returned null while getting the DAO '" + this.daoName + "'");
            }
            DaoInvoker daoInvoker = DaoInvokerFactory.getInstance().create(dao, this.objectStore);
            Object object = result = this.name == null ? daoInvoker.update(bean) : daoInvoker.update(this.name, bean);
            if (this.updatedBeanId != null) {
                if (result == null) {
                    result = bean;
                }
                beanRepository.addBean(this.updatedBeanId, result);
            } else if (result != null && bean != result) {
                beanRepository.changeBean(this.beanId, bean);
            }
        }
        finally {
            if (dao != null) {
                emr.returnDao(dao);
            }
        }
    }
}

