/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.persistence;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXUtil;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.javabean.BeanRuntimeInfo;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.context.BeanContext;
import org.milyn.javabean.context.BeanIdStore;
import org.milyn.javabean.lifecycle.BeanContextLifecycleEvent;
import org.milyn.javabean.lifecycle.BeanContextLifecycleObserver;
import org.milyn.javabean.lifecycle.BeanLifecycle;
import org.milyn.javabean.repository.BeanId;
import org.milyn.persistence.ParameterListType;
import org.milyn.persistence.parameter.NamedParameterIndex;
import org.milyn.persistence.parameter.Parameter;
import org.milyn.persistence.parameter.ParameterContainer;
import org.milyn.persistence.parameter.ParameterManager;
import org.milyn.persistence.parameter.PositionalParameterIndex;
import org.milyn.util.CollectionsUtil;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@VisitBeforeReport(condition="parameters.containsKey('wireBeanId') || parameters.containsKey('valueAttributeName')", summary="<#if resource.parameters.wireBeanId??>Create bean lifecycle observer for the bean under the beanId '${resource.parameters.wireBeanId}'.<#elseif resource.parameters.valueAttributeName??>Populating <#if resource.parameters.name??>the '${resource.parameters.name}'</#if> parameter from the '${resource.parameters.valueAttributeName}' attribute.</#if>")
@VisitAfterReport(condition="!parameters.containsKey('valueAttributeName')", summary="<#if resource.parameters.wireBeanId??>Removing bean lifecycle observer for the bean under the beanId '${resource.parameters.wireBeanId}'.<#else>Populating <#if resource.parameters.name??>the '${resource.parameters.name}'</#if> parameter from <#if resource.parameters.expression??>an expression<#else>this element.</#if></#if>.")
public class EntityLocatorParameterVisitor
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter,
Consumer,
Producer {
    private static Log logger = LogFactory.getLog(EntityLocatorParameterVisitor.class);
    @ConfigParam(name="entityLookupperId")
    private int entityLocatorId;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String name;
    @ConfigParam
    private Integer index;
    @ConfigParam(defaultVal="NAMED", decoder=ParameterListType.DataDecoder.class)
    private ParameterListType parameterListType;
    @ConfigParam(name="wireBeanId", use=ConfigParam.Use.OPTIONAL)
    private String wireBeanIdName;
    @ConfigParam(defaultVal="##NULL")
    private MVELExpressionEvaluator expression;
    @ConfigParam(defaultVal="##NULL")
    private String valueAttributeName;
    @ConfigParam(name="type", use=ConfigParam.Use.OPTIONAL)
    private String typeAlias;
    @ConfigParam(name="default", use=ConfigParam.Use.OPTIONAL)
    private String defaultVal;
    @AppContext
    private ApplicationContext appContext;
    private Parameter<?> parameter;
    private BeanIdStore beanIdStore;
    private BeanRuntimeInfo wiredBeanRuntimeInfo;
    private BeanId wireBeanId;
    private boolean isAttribute = true;
    private DataDecoder decoder;
    private boolean beanWiring;

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initializing EntityLocatorParameterVisitor with name '" + this.name + "'"));
        }
        this.beanWiring = this.wireBeanIdName != null;
        this.isAttribute = this.valueAttributeName != null;
        this.beanIdStore = this.appContext.getBeanIdStore();
        if (this.parameterListType == ParameterListType.NAMED) {
            NamedParameterIndex parameterIndex = (NamedParameterIndex)ParameterManager.getParameterIndex(this.entityLocatorId, this.appContext);
            this.parameter = parameterIndex.register(this.name);
        } else {
            PositionalParameterIndex parameterIndex = (PositionalParameterIndex)ParameterManager.getParameterIndex(this.entityLocatorId, this.appContext);
            this.parameter = parameterIndex.register(this.index);
        }
    }

    public boolean consumes(Object object) {
        if (this.wireBeanIdName != null && object.equals(this.wireBeanIdName)) {
            return true;
        }
        return this.expression != null && this.expression.getExpression().indexOf(object.toString()) != -1;
    }

    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet((Object[])new Parameter[]{this.parameter});
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        if (this.beanWiring) {
            this.bindBeanValue(executionContext);
        } else if (this.isAttribute) {
            this.bindDomDataValue(element, executionContext);
        }
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        if (!this.beanWiring && !this.isAttribute) {
            this.bindDomDataValue(element, executionContext);
        }
        if (this.beanWiring) {
            this.removeBeanLifecycleObserver(executionContext);
        }
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        if (!this.isAttribute) {
            element.accumulateText();
        }
        if (this.beanWiring) {
            this.bindBeanValue(executionContext);
        } else if (this.isAttribute) {
            this.bindSaxDataValue(element, executionContext);
        }
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        if (!this.beanWiring && !this.isAttribute) {
            this.bindSaxDataValue(element, executionContext);
        }
        if (this.beanWiring) {
            this.removeBeanLifecycleObserver(executionContext);
        }
    }

    private void bindDomDataValue(Element element, ExecutionContext executionContext) {
        String dataString = this.isAttribute ? DomUtils.getAttributeValue((Element)element, (String)this.valueAttributeName) : DomUtils.getAllText((Element)element, (boolean)false);
        if (this.expression != null) {
            this.bindExpressionValue(executionContext);
        } else {
            this.populateAndSetPropertyValue(dataString, executionContext);
        }
    }

    private void bindSaxDataValue(SAXElement element, ExecutionContext executionContext) {
        String dataString = this.isAttribute ? SAXUtil.getAttribute((String)this.valueAttributeName, (Attributes)element.getAttributes()) : element.getTextContent();
        if (this.expression != null) {
            this.bindExpressionValue(executionContext);
        } else {
            this.populateAndSetPropertyValue(dataString, executionContext);
        }
    }

    private BeanId getWireBeanId() {
        if (this.wireBeanId == null) {
            this.wireBeanId = this.beanIdStore.register(this.wireBeanIdName);
        }
        return this.wireBeanId;
    }

    private void bindBeanValue(final ExecutionContext executionContext) {
        final BeanId targetBeanId = this.getWireBeanId();
        final BeanContext beanContext = executionContext.getBeanContext();
        Object bean = beanContext.getBean(targetBeanId);
        if (bean == null) {
            beanContext.addBeanLifecycleObserver(targetBeanId, BeanLifecycle.BEGIN, this.getId(), false, new BeanContextLifecycleObserver(){

                public void onBeanLifecycleEvent(BeanContextLifecycleEvent event) {
                    BeanRuntimeInfo wiredBeanRI = EntityLocatorParameterVisitor.this.getWiredBeanRuntimeInfo();
                    if (wiredBeanRI != null && wiredBeanRI.getClassification() == BeanRuntimeInfo.Classification.ARRAY_COLLECTION) {
                        beanContext.addBeanLifecycleObserver(targetBeanId, BeanLifecycle.CHANGE, EntityLocatorParameterVisitor.this.getId(), true, new BeanContextLifecycleObserver(){

                            public void onBeanLifecycleEvent(BeanContextLifecycleEvent event) {
                                EntityLocatorParameterVisitor.this.populateAndSetPropertyValue(event.getBean(), executionContext);
                            }
                        });
                    } else {
                        EntityLocatorParameterVisitor.this.populateAndSetPropertyValue(event.getBean(), executionContext);
                    }
                }
            });
        } else {
            this.populateAndSetPropertyValue(bean, executionContext);
        }
    }

    private void removeBeanLifecycleObserver(ExecutionContext executionContext) {
        executionContext.getBeanContext().removeBeanLifecycleObserver(this.getWireBeanId(), BeanLifecycle.BEGIN, this.getId());
    }

    private void bindExpressionValue(ExecutionContext executionContext) {
        Map beanMap = executionContext.getBeanContext().getBeanMap();
        Object dataObject = this.expression.getValue((Object)beanMap);
        if (dataObject instanceof String) {
            this.populateAndSetPropertyValue((String)dataObject, executionContext);
        } else {
            this.populateAndSetPropertyValue(dataObject, executionContext);
        }
    }

    private void populateAndSetPropertyValue(String dataString, ExecutionContext executionContext) {
        Object dataObject = this.decodeDataString(dataString, executionContext);
        this.populateAndSetPropertyValue(dataObject, executionContext);
    }

    private void populateAndSetPropertyValue(Object dataObject, ExecutionContext executionContext) {
        if (dataObject == null) {
            return;
        }
        ParameterContainer<Parameter<?>> container = ParameterManager.getParameterContainer(this.entityLocatorId, executionContext);
        container.put(this.parameter, dataObject);
    }

    private Object decodeDataString(String dataString, ExecutionContext executionContext) throws DataDecodeException {
        if ((dataString == null || dataString.equals("")) && this.defaultVal != null) {
            if (this.defaultVal.equals("null")) {
                return null;
            }
            dataString = this.defaultVal;
        }
        if (this.decoder == null) {
            this.decoder = this.getDecoder(executionContext);
        }
        return this.decoder.decode(dataString);
    }

    private DataDecoder getDecoder(ExecutionContext executionContext) throws DataDecodeException {
        List decoders = executionContext.getDeliveryConfig().getObjects("decoder:" + this.typeAlias);
        if (decoders == null || decoders.isEmpty()) {
            this.decoder = DataDecoder.Factory.create((String)this.typeAlias);
        } else {
            if (!(decoders.get(0) instanceof DataDecoder)) {
                throw new DataDecodeException("Configured decoder '" + this.typeAlias + ":" + decoders.get(0).getClass().getName() + "' is not an instance of " + DataDecoder.class.getName());
            }
            this.decoder = (DataDecoder)decoders.get(0);
        }
        return this.decoder;
    }

    private BeanRuntimeInfo getWiredBeanRuntimeInfo() {
        if (this.wiredBeanRuntimeInfo == null) {
            this.wiredBeanRuntimeInfo = BeanRuntimeInfo.getBeanRuntimeInfo((String)this.wireBeanIdName, (ApplicationContext)this.appContext);
        }
        return this.wiredBeanRuntimeInfo;
    }

    public String getId() {
        return EntityLocatorParameterVisitor.class.getName() + "#" + this.entityLocatorId + "#" + this.name;
    }
}

