/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.routing.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.db.AbstractDataSource;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.annotation.VisitAfterIf;
import org.milyn.delivery.annotation.VisitBeforeIf;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.repository.BeanId;
import org.milyn.javabean.repository.BeanIdRegister;
import org.milyn.javabean.repository.BeanRepository;
import org.milyn.javabean.repository.BeanRepositoryManager;
import org.milyn.routing.db.StatementExec;
import org.milyn.routing.db.StatementType;
import org.w3c.dom.Element;

@VisitBeforeIf(condition="parameters.containsKey('executeBefore') && parameters.executeBefore.value == 'true'")
@VisitAfterIf(condition="!parameters.containsKey('executeBefore') || parameters.executeBefore.value != 'true'")
@VisitBeforeReport(summary="Execute statement '${resource.parameters.statement}' on Datasource '${resource.parameters.datasource}'.", detailTemplate="reporting/SQLExecutor.html")
@VisitAfterReport(summary="Execute statement '${resource.parameters.statement}' on Datasource '${resource.parameters.datasource}'.", detailTemplate="reporting/SQLExecutor.html")
public class SQLExecutor
implements SAXVisitBefore,
SAXVisitAfter,
DOMElementVisitor {
    @ConfigParam
    private String datasource;
    @ConfigParam
    private String statement;
    private StatementExec statementExec;
    private String rsAppContextKey;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String resultSetName;
    @ConfigParam(defaultVal="EXECUTION", choice={"EXECUTION", "APPLICATION"}, decoder=ResultSetScopeDecoder.class)
    private ResultSetScope resultSetScope;
    @ConfigParam(defaultVal="900000")
    private long resultSetTTL;
    @AppContext
    private ApplicationContext appContext;
    private BeanId resultSetBeanId;

    @Initialize
    public void intitialize() throws SmooksConfigurationException {
        this.statementExec = new StatementExec(this.statement);
        if (this.statementExec.getStatementType() == StatementType.QUERY && this.resultSetName == null) {
            throw new SmooksConfigurationException("Sorry, query statements must be accompanied by a 'resultSetName' property, under whose value the query results are bound.");
        }
        if (this.resultSetName != null) {
            BeanRepositoryManager beanRepositoryManager = BeanRepositoryManager.getInstance((ApplicationContext)this.appContext);
            BeanIdRegister beanIdRegister = beanRepositoryManager.getBeanIdRegister();
            this.resultSetBeanId = beanIdRegister.register(this.resultSetName);
        }
        this.rsAppContextKey = this.datasource + ":" + this.statement;
    }

    public void visitBefore(SAXElement saxElement, ExecutionContext executionContext) throws SmooksException, IOException {
        this.executeSQL(executionContext);
    }

    public void visitAfter(SAXElement saxElement, ExecutionContext executionContext) throws SmooksException, IOException {
        this.executeSQL(executionContext);
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.executeSQL(executionContext);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.executeSQL(executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQL(ExecutionContext executionContext) throws SmooksException {
        block15: {
            Connection connection = AbstractDataSource.getConnection((String)this.datasource, (ExecutionContext)executionContext);
            BeanRepository beanRepository = BeanRepositoryManager.getBeanRepository((ExecutionContext)executionContext);
            Map beanMap = beanRepository.getBeanMap();
            try {
                if (!this.statementExec.isJoin()) {
                    if (this.statementExec.getStatementType() == StatementType.QUERY) {
                        if (this.resultSetScope == ResultSetScope.EXECUTION) {
                            beanRepository.addBean(this.resultSetBeanId, this.statementExec.executeUnjoinedQuery(connection, new Object[0]));
                            break block15;
                        }
                        ApplicationContext appContext = executionContext.getContext();
                        ResultSetContextObject rsContextObj = ResultSetContextObject.getInstance(this.rsAppContextKey, appContext);
                        if (rsContextObj.hasExpired()) {
                            ResultSetContextObject resultSetContextObject = rsContextObj;
                            synchronized (resultSetContextObject) {
                                if (rsContextObj.hasExpired()) {
                                    rsContextObj.resultSet = this.statementExec.executeUnjoinedQuery(connection, new Object[0]);
                                    rsContextObj.expiresAt = System.currentTimeMillis() + this.resultSetTTL;
                                }
                            }
                        }
                        List resultMap = rsContextObj.resultSet;
                        beanRepository.addBean(this.resultSetBeanId, (Object)resultMap);
                        break block15;
                    }
                    this.statementExec.executeUnjoinedUpdate(connection, new Object[0]);
                    break block15;
                }
                if (this.statementExec.getStatementType() == StatementType.QUERY) {
                    ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
                    this.statementExec.executeJoinedQuery(connection, beanMap, resultMap);
                    beanRepository.addBean(this.resultSetBeanId, resultMap);
                    break block15;
                }
                if (this.resultSetBeanId == null) {
                    this.statementExec.executeJoinedUpdate(connection, beanMap);
                    break block15;
                }
                Object resultSetObj = beanRepository.getBean(this.resultSetBeanId);
                if (resultSetObj != null) {
                    try {
                        List resultSet = (List)resultSetObj;
                        this.statementExec.executeJoinedStatement(connection, resultSet);
                        break block15;
                    }
                    catch (ClassCastException e) {
                        throw new SmooksException("Cannot execute joined statement '" + this.statementExec.getStatement() + "' on ResultSet '" + this.resultSetName + "'.  Must be of type 'List<Map<String, Object>>'.  Is of type '" + resultSetObj.getClass().getName() + "'.");
                    }
                }
                throw new SmooksException("Cannot execute joined statement '" + this.statementExec.getStatement() + "' on ResultSet '" + this.resultSetName + "'.  ResultSet not found in ExecutionContext.");
            }
            catch (SQLException e) {
                throw new SmooksException("Error executing SQL Statement '" + this.statement + "'.", (Throwable)e);
            }
        }
    }

    private static class ResultSetContextObject {
        private List<Map<String, Object>> resultSet;
        private long expiresAt = 0L;

        private ResultSetContextObject() {
        }

        private boolean hasExpired() {
            return this.expiresAt <= System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ResultSetContextObject getInstance(String rsAppContextKey, ApplicationContext appContext) {
            ResultSetContextObject rsContextObj = (ResultSetContextObject)appContext.getAttribute((Object)rsAppContextKey);
            if (rsContextObj == null) {
                ApplicationContext applicationContext = appContext;
                synchronized (applicationContext) {
                    rsContextObj = (ResultSetContextObject)appContext.getAttribute((Object)rsAppContextKey);
                    if (rsContextObj == null) {
                        rsContextObj = new ResultSetContextObject();
                        appContext.setAttribute((Object)rsAppContextKey, (Object)rsContextObj);
                    }
                }
            }
            return rsContextObj;
        }
    }

    public static class ResultSetScopeDecoder
    implements DataDecoder {
        public Object decode(String data) throws DataDecodeException {
            ResultSetScope scope;
            data = data.trim();
            try {
                scope = ResultSetScope.valueOf(data);
            }
            catch (IllegalArgumentException e) {
                throw new DataDecodeException("Failed to decode ResultSetScope value '" + data + "'.  Allowed values are " + Arrays.asList(ResultSetScope.values()) + ".");
            }
            return scope;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ResultSetScope {
        EXECUTION,
        APPLICATION;

    }
}

