/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.routing.jms;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.annotation.Uninitialize;
import org.milyn.delivery.annotation.VisitAfterIf;
import org.milyn.delivery.annotation.VisitBeforeIf;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXElementVisitor;
import org.milyn.delivery.sax.SAXText;
import org.milyn.routing.SmooksRoutingException;
import org.milyn.routing.jms.AcknowledgeModeEnum;
import org.milyn.routing.jms.JMSProperties;
import org.milyn.routing.jms.JNDIProperties;
import org.milyn.routing.jms.message.creationstrategies.MessageCreationStrategy;
import org.milyn.routing.jms.message.creationstrategies.StrategyFactory;
import org.milyn.routing.jms.message.creationstrategies.TextMessageCreationStrategy;
import org.milyn.templating.freemarker.FreeMarkerUtils;
import org.milyn.util.FreeMarkerTemplate;
import org.w3c.dom.Element;

@VisitBeforeIf(condition="parameters.containsKey('executeBefore') && parameters.executeBefore.value == 'true'")
@VisitAfterIf(condition="!parameters.containsKey('executeBefore') || parameters.executeBefore.value != 'true'")
public class JMSRouter
implements DOMElementVisitor,
SAXElementVisitor {
    private final Log logger = LogFactory.getLog(JMSRouter.class);
    private final JNDIProperties jndiProperties = new JNDIProperties();
    private final JMSProperties jmsProperties = new JMSProperties();
    @ConfigParam(use=ConfigParam.Use.REQUIRED)
    private String beanId;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String correlationIdPattern;
    private FreeMarkerTemplate correlationIdTemplate;
    @ConfigParam(defaultVal="200")
    private int highWaterMark;
    @ConfigParam(defaultVal="60000")
    private long highWaterMarkTimeout;
    @ConfigParam(defaultVal="1000")
    private long highWaterMarkPollFrequency;
    private MessageCreationStrategy msgCreationStrategy = new TextMessageCreationStrategy();
    private Destination destination;
    private Connection connection;
    private MessageProducer msgProducer;
    private Session session;

    public void visitAfter(Element element, ExecutionContext execContext) throws SmooksException {
        this.visit(execContext);
    }

    public void visitBefore(Element element, ExecutionContext execContext) throws SmooksException {
        this.visit(execContext);
    }

    public void visitAfter(SAXElement element, ExecutionContext execContext) throws SmooksException, IOException {
        this.visit(execContext);
    }

    public void visitBefore(SAXElement element, ExecutionContext execContext) throws SmooksException, IOException {
        this.visit(execContext);
    }

    private void visit(ExecutionContext execContext) throws SmooksException {
        Message message = this.msgCreationStrategy.createJMSMessage(this.beanId, execContext, this.session);
        if (this.correlationIdTemplate != null) {
            this.setCorrelationID(execContext, message);
        }
        this.sendMessage(message);
    }

    public void onChildElement(SAXElement saxElement, SAXElement saxElement2, ExecutionContext execContect) throws SmooksException, IOException {
    }

    public void onChildText(SAXElement saxElement, SAXText saxText, ExecutionContext execContext) throws SmooksException, IOException {
    }

    @Initialize
    public void initialize() throws SmooksConfigurationException, JMSException {
        InitialContext context = null;
        boolean initialized = false;
        try {
            if (this.correlationIdPattern != null) {
                this.correlationIdTemplate = new FreeMarkerTemplate(this.correlationIdPattern);
            }
            context = new InitialContext();
            this.destination = (Destination)context.lookup(this.jmsProperties.getDestinationName());
            this.msgProducer = this.createMessageProducer(this.destination, context);
            this.setMessageProducerProperties();
            initialized = true;
        }
        catch (NamingException e) {
            String errorMsg = "NamingException while trying to lookup [" + this.jmsProperties.getDestinationName() + "]";
            this.logger.error((Object)errorMsg, (Throwable)e);
            throw new SmooksConfigurationException(errorMsg, (Throwable)e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    this.logger.warn((Object)"NamingException while trying to close initial Context");
                }
            }
            if (!initialized) {
                this.releaseJMSResources();
            }
        }
    }

    @Uninitialize
    public void uninitialize() throws JMSException {
        this.releaseJMSResources();
    }

    protected MessageProducer createMessageProducer(Destination destination, Context context) throws JMSException {
        try {
            ConnectionFactory connFactory = (ConnectionFactory)context.lookup(this.jmsProperties.getConnectionFactoryName());
            this.connection = this.jmsProperties.getSecurityPrincipal() == null && this.jmsProperties.getSecurityCredential() == null ? connFactory.createConnection() : connFactory.createConnection(this.jmsProperties.getSecurityPrincipal(), this.jmsProperties.getSecurityCredential());
            this.session = this.connection.createSession(this.jmsProperties.isTransacted(), AcknowledgeModeEnum.getAckMode(this.jmsProperties.getAcknowledgeMode().toUpperCase()).getAcknowledgeModeInt());
            this.msgProducer = this.session.createProducer(destination);
            this.connection.start();
            this.logger.info((Object)"JMS Connection started");
        }
        catch (JMSException e) {
            String errorMsg = "JMSException while trying to create MessageProducer for Queue [" + this.jmsProperties.getDestinationName() + "]";
            this.releaseJMSResources();
            throw new SmooksConfigurationException(errorMsg, (Throwable)e);
        }
        catch (NamingException e) {
            String errorMsg = "NamingException while trying to lookup ConnectionFactory [" + this.jmsProperties.getConnectionFactoryName() + "]";
            this.releaseJMSResources();
            throw new SmooksConfigurationException(errorMsg, (Throwable)e);
        }
        return this.msgProducer;
    }

    protected void setMessageProducerProperties() throws SmooksConfigurationException {
        try {
            this.msgProducer.setTimeToLive(this.jmsProperties.getTimeToLive());
            this.msgProducer.setPriority(this.jmsProperties.getPriority());
            int deliveryModeInt = "non-persistent".equals(this.jmsProperties.getDeliveryMode()) ? 2 : 1;
            this.msgProducer.setDeliveryMode(deliveryModeInt);
        }
        catch (JMSException e) {
            String errorMsg = "JMSException while trying to set JMS Header Fields";
            throw new SmooksConfigurationException("JMSException while trying to set JMS Header Fields", (Throwable)e);
        }
    }

    protected void sendMessage(Message message) throws SmooksRoutingException {
        try {
            this.waitWhileAboveHighWaterMark();
        }
        catch (JMSException e) {
            throw new SmooksRoutingException("Exception while attempting to check JMS Queue High Water Mark.", e);
        }
        try {
            this.msgProducer.send(message);
        }
        catch (JMSException e) {
            String errorMsg = "JMSException while sending Message.";
            throw new SmooksRoutingException("JMSException while sending Message.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitWhileAboveHighWaterMark() throws JMSException, SmooksRoutingException {
        if (this.highWaterMark == -1) {
            return;
        }
        if (this.session instanceof QueueSession) {
            QueueSession queueSession = (QueueSession)this.session;
            QueueBrowser queueBrowser = queueSession.createBrowser((Queue)this.destination);
            try {
                int length = this.getQueueLength(queueBrowser);
                long start = System.currentTimeMillis();
                if (this.logger.isDebugEnabled() && length >= this.highWaterMark) {
                    this.logger.debug((Object)("Length of JMS destination Queue '" + this.jmsProperties.getDestinationName() + "' has reached " + length + ".  High Water Mark is " + this.highWaterMark + ".  Waiting for Queue length to drop."));
                }
                while (length >= this.highWaterMark && System.currentTimeMillis() < start + this.highWaterMarkTimeout) {
                    try {
                        Thread.sleep(this.highWaterMarkPollFrequency);
                    }
                    catch (InterruptedException e) {
                        this.logger.error((Object)"Interrupted", (Throwable)e);
                        queueBrowser.close();
                        return;
                    }
                    length = this.getQueueLength(queueBrowser);
                }
                if (length >= this.highWaterMark) {
                    throw new SmooksRoutingException("Failed to route JMS message to Queue destination '" + ((Queue)this.destination).getQueueName() + "'. Timed out (" + this.highWaterMarkTimeout + " ms) waiting for queue length to drop below High Water Mark (" + this.highWaterMark + ").  Consider increasing 'highWaterMark' and/or 'highWaterMarkTimeout' param values.");
                }
            }
            finally {
                queueBrowser.close();
            }
        }
    }

    private int getQueueLength(QueueBrowser queueBrowser) throws JMSException {
        int length = 0;
        Enumeration queueEnum = queueBrowser.getEnumeration();
        while (queueEnum.hasMoreElements()) {
            ++length;
            queueEnum.nextElement();
        }
        return length;
    }

    protected void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (JMSException e) {
                String errorMsg = "JMSException while trying to close connection";
                this.logger.error((Object)"JMSException while trying to close connection", (Throwable)e);
            }
        }
    }

    protected void close(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (JMSException e) {
                String errorMsg = "JMSException while trying to close session";
                this.logger.error((Object)"JMSException while trying to close session", (Throwable)e);
            }
        }
    }

    public Destination getDestination() {
        return this.destination;
    }

    @ConfigParam(use=ConfigParam.Use.OPTIONAL, defaultVal="org.jnp.interfaces.NamingContextFactory")
    public void setJndiContextFactory(String contextFactory) {
        this.jndiProperties.setContextFactory(contextFactory);
    }

    public String getJndiContectFactory() {
        return this.jndiProperties.getContextFactory();
    }

    @ConfigParam(use=ConfigParam.Use.OPTIONAL, defaultVal="jnp://localhost:1099")
    public void setJndiProviderUrl(String providerUrl) {
        this.jndiProperties.setProviderUrl(providerUrl);
    }

    public String getJndiProviderUrl() {
        return this.jndiProperties.getProviderUrl();
    }

    public String getJndiNamingFactoryUrl() {
        return this.jndiProperties.getNamingFactoryUrlPkgs();
    }

    @ConfigParam(use=ConfigParam.Use.OPTIONAL, defaultVal="org.jboss.naming:java.naming.factory.url.pkgs")
    public void setJndiNamingFactoryUrl(String pkgUrl) {
        this.jndiProperties.setNamingFactoryUrlPkgs(pkgUrl);
    }

    @ConfigParam(use=ConfigParam.Use.REQUIRED)
    public void setDestinationName(String destinationName) {
        this.jmsProperties.setDestinationName(destinationName);
    }

    public String getDestinationName() {
        return this.jmsProperties.getDestinationName();
    }

    @ConfigParam(choice={"persistent", "non-persistent"}, defaultVal="persistent", use=ConfigParam.Use.OPTIONAL)
    public void setDeliveryMode(String deliveryMode) {
        this.jmsProperties.setDeliveryMode(deliveryMode);
    }

    private void setCorrelationID(ExecutionContext execContext, Message message) {
        Map beanMap = FreeMarkerUtils.getMergedModel((ExecutionContext)execContext);
        String correlationId = this.correlationIdTemplate.apply((Object)beanMap);
        try {
            message.setJMSCorrelationID(correlationId);
        }
        catch (JMSException e) {
            throw new SmooksException("Failed to set CorrelationID '" + correlationId + "' on message.", (Throwable)e);
        }
    }

    public String getDeliveryMode() {
        return this.jmsProperties.getDeliveryMode();
    }

    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    public void setTimeToLive(long timeToLive) {
        this.jmsProperties.setTimeToLive(timeToLive);
    }

    public long getTimeToLive() {
        return this.jmsProperties.getTimeToLive();
    }

    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    public void setSecurityPrincipal(String securityPrincipal) {
        this.jmsProperties.setSecurityPrincipal(securityPrincipal);
    }

    public String getSecurityPrincipal() {
        return this.jmsProperties.getSecurityPrincipal();
    }

    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    public void setSecurityCredential(String securityCredential) {
        this.jmsProperties.setSecurityCredential(securityCredential);
    }

    public String getSecurityCredential() {
        return this.jmsProperties.getSecurityCredential();
    }

    @ConfigParam(use=ConfigParam.Use.OPTIONAL, defaultVal="false")
    public void setTransacted(boolean transacted) {
        this.jmsProperties.setTransacted(transacted);
    }

    public boolean isTransacted() {
        return this.jmsProperties.isTransacted();
    }

    @ConfigParam(defaultVal="ConnectionFactory", use=ConfigParam.Use.OPTIONAL)
    public void setConnectionFactoryName(String connectionFactoryName) {
        this.jmsProperties.setConnectionFactoryName(connectionFactoryName);
    }

    public String getConnectionFactoryName() {
        return this.jmsProperties.getConnectionFactoryName();
    }

    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    public void setPriority(int priority) {
        this.jmsProperties.setPriority(priority);
    }

    public int getPriority() {
        return this.jmsProperties.getPriority();
    }

    @ConfigParam(defaultVal="AUTO_ACKNOWLEDGE", choice={"AUTO_ACKNOWLEDGE", "CLIENT_ACKNOWLEDGE", "DUPS_OK_ACKNOWLEDGE"})
    public void setAcknowledgeMode(String jmsAcknowledgeMode) {
        this.jmsProperties.setAcknowledgeMode(jmsAcknowledgeMode);
    }

    public String getAcknowledgeMode() {
        return this.jmsProperties.getAcknowledgeMode();
    }

    @ConfigParam(defaultVal="TextMessage", choice={"TextMessage", "ObjectMessage"})
    public void setMessageType(String messageType) {
        this.msgCreationStrategy = StrategyFactory.getInstance().createStrategy(messageType);
        this.jmsProperties.setMessageType(messageType);
    }

    public void setMsgCreationStrategy(MessageCreationStrategy msgCreationStrategy) {
        this.msgCreationStrategy = msgCreationStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseJMSResources() throws JMSException {
        if (this.connection != null) {
            try {
                try {
                    this.connection.stop();
                }
                finally {
                    try {
                        this.closeProducer();
                    }
                    finally {
                        this.closeSession();
                    }
                }
            }
            catch (JMSException e) {
                this.logger.error((Object)"JMSException while trying to stop JMS Connection.", (Throwable)e);
            }
            finally {
                this.connection.close();
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeProducer() {
        if (this.msgProducer != null) {
            try {
                this.msgProducer.close();
            }
            catch (JMSException e) {
                this.logger.error((Object)"JMSException while trying to close JMS Message Producer.", (Throwable)e);
            }
            finally {
                this.msgProducer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (JMSException e) {
                this.logger.error((Object)"JMSException while trying to close JMS Session.", (Throwable)e);
            }
            finally {
                this.session = null;
            }
        }
    }
}

