/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.routing.basic;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.milyn.SmooksException;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.DOMVisitAfter;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.DynamicSAXElementVisitorList;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXElementVisitor;
import org.milyn.delivery.sax.SAXText;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.delivery.sax.SAXVisitor;
import org.milyn.delivery.sax.WriterUtil;
import org.milyn.javabean.repository.BeanRepository;
import org.milyn.util.CollectionsUtil;
import org.milyn.xml.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentSerializer
implements SAXVisitBefore,
SAXVisitAfter,
DOMVisitAfter,
Producer {
    private String bindTo;
    private boolean omitXMLDeclaration;
    private boolean childContentOnly;

    @ConfigParam
    public FragmentSerializer setBindTo(String bindTo) {
        this.bindTo = bindTo;
        return this;
    }

    @ConfigParam(defaultVal="false")
    public FragmentSerializer setOmitXMLDeclaration(boolean omitXMLDeclaration) {
        this.omitXMLDeclaration = omitXMLDeclaration;
        return this;
    }

    @ConfigParam(defaultVal="false")
    public FragmentSerializer setChildContentOnly(boolean childContentOnly) {
        this.childContentOnly = childContentOnly;
        return this;
    }

    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet((Object[])new String[]{this.bindTo});
    }

    public void visitBefore(SAXElement saxElement, ExecutionContext executionContext) throws SmooksException, IOException {
        HashMap<String, SAXSerializer> fragmentSerializers = (HashMap<String, SAXSerializer>)executionContext.getAttribute(FragmentSerializer.class);
        if (fragmentSerializers == null) {
            fragmentSerializers = new HashMap<String, SAXSerializer>();
            executionContext.setAttribute(FragmentSerializer.class, fragmentSerializers);
        }
        SAXSerializer serializer = new SAXSerializer();
        fragmentSerializers.put(this.bindTo, serializer);
        if (!this.omitXMLDeclaration) {
            serializer.fragmentWriter.write("<?xml version=\"1.0\"?>\n");
        }
        DynamicSAXElementVisitorList.addDynamicVisitor((SAXVisitor)serializer, (ExecutionContext)executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitAfter(SAXElement saxElement, ExecutionContext executionContext) throws SmooksException, IOException {
        Map fragmentSerializers = (Map)executionContext.getAttribute(FragmentSerializer.class);
        SAXSerializer serializer = (SAXSerializer)fragmentSerializers.get(this.bindTo);
        try {
            BeanRepository.getInstance((ExecutionContext)executionContext).addBean(this.bindTo, (Object)serializer.fragmentWriter.toString().trim());
        }
        finally {
            DynamicSAXElementVisitorList.removeDynamicVisitor((SAXVisitor)serializer, (ExecutionContext)executionContext);
        }
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        String serializedFragment = this.childContentOnly ? XmlUtil.serialize((NodeList)element.getChildNodes(), (boolean)false) : XmlUtil.serialize((Node)element, (boolean)true);
        if (!this.omitXMLDeclaration) {
            serializedFragment = "<?xml version=\"1.0\"?>\n" + serializedFragment;
        }
        BeanRepository.getInstance((ExecutionContext)executionContext).addBean(this.bindTo, (Object)serializedFragment);
    }

    private class SAXSerializer
    implements SAXElementVisitor {
        int depth = 0;
        StringWriter fragmentWriter = new StringWriter();
        Set<String> declaredPrefixes = new HashSet<String>();

        private SAXSerializer() {
        }

        public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
            this.addNamepsaceDecls(element);
            if (FragmentSerializer.this.childContentOnly) {
                if (this.depth > 0) {
                    WriterUtil.writeStartElement((SAXElement)element, (Writer)this.fragmentWriter, (boolean)true);
                }
            } else {
                WriterUtil.writeStartElement((SAXElement)element, (Writer)this.fragmentWriter, (boolean)true);
            }
            ++this.depth;
        }

        public void onChildElement(SAXElement element, SAXElement childElement, ExecutionContext executionContext) throws SmooksException, IOException {
        }

        public void onChildText(SAXElement element, SAXText text, ExecutionContext executionContext) throws SmooksException, IOException {
            WriterUtil.writeText((SAXText)text, (Writer)this.fragmentWriter);
        }

        public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
            --this.depth;
            if (FragmentSerializer.this.childContentOnly) {
                if (this.depth > 0) {
                    WriterUtil.writeEndElement((SAXElement)element, (Writer)this.fragmentWriter);
                }
            } else {
                WriterUtil.writeEndElement((SAXElement)element, (Writer)this.fragmentWriter);
            }
        }

        private void addNamepsaceDecls(SAXElement element) {
            this.addAttrNamespaceDecls(element);
            QName qName = element.getName();
            this.addNamespace(qName.getPrefix(), qName.getNamespaceURI(), element);
        }

        private void addAttrNamespaceDecls(SAXElement element) {
            Attributes attributes = element.getAttributes();
            int attrCount = attributes.getLength();
            for (int i = 0; i < attrCount; ++i) {
                int indexOf;
                String uri = attributes.getURI(i);
                if (uri.equals("http://www.w3.org/2000/xmlns/")) {
                    this.declaredPrefixes.add(attributes.getLocalName(i));
                    continue;
                }
                String qName = attributes.getQName(i);
                if (qName == null || (indexOf = qName.indexOf(58)) == -1) continue;
                String prefix = qName.substring(0, indexOf);
                this.addNamespace(prefix, uri, element);
            }
        }

        private void addNamespace(String prefix, String namespaceURI, SAXElement element) {
            if (this.declaredPrefixes.contains(prefix)) {
                return;
            }
            String prefixNS = element.getAttribute("http://www.w3.org/2000/xmlns/", prefix);
            if (prefixNS != null && prefixNS.length() != 0) {
                return;
            }
            Attributes attributes = element.getAttributes();
            AttributesImpl attributesCopy = new AttributesImpl();
            attributesCopy.setAttributes(attributes);
            if (prefix.length() > 0) {
                attributesCopy.addAttribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, null, namespaceURI);
            } else {
                attributesCopy.addAttribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns", null, namespaceURI);
            }
            element.setAttributes((Attributes)attributesCopy);
            this.declaredPrefixes.add(prefix);
        }
    }
}

