/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.rules.regex;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.container.ExecutionContext;
import org.milyn.resource.URIResourceLocator;
import org.milyn.rules.RuleEvalResult;
import org.milyn.rules.RuleProvider;
import org.milyn.rules.regex.RegexRuleEvalResult;

public class RegexProvider
implements RuleProvider {
    private static Log logger = LogFactory.getLog(RegexProvider.class);
    private String src;
    private String providerName;
    private Map<String, Pattern> rules = new HashMap<String, Pattern>();

    public RegexProvider() {
    }

    public RegexProvider(String src) {
        this.setSrc(src);
    }

    public RuleEvalResult evaluate(String ruleName, CharSequence selectedData, ExecutionContext context) throws SmooksException {
        AssertArgument.isNotNullAndNotEmpty((String)ruleName, (String)"ruleName");
        AssertArgument.isNotNull((Object)selectedData, (String)"selectedData");
        Pattern pattern = this.rules.get(ruleName);
        if (pattern == null) {
            throw new SmooksException("Unknown rule name '" + ruleName + "' on Regex RuleProvider '" + this.providerName + "'.");
        }
        boolean matched = pattern.matcher(selectedData).matches();
        return new RegexRuleEvalResult(matched, ruleName, this.providerName, pattern, ((Object)selectedData).toString());
    }

    public String getName() {
        return this.providerName;
    }

    public void setName(String name) {
        this.providerName = name;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
        this.loadRules(src);
    }

    protected void loadRules(String ruleFile) {
        InputStream ruleStream;
        if (ruleFile == null) {
            throw new SmooksException("ruleFile not specified.");
        }
        try {
            ruleStream = new URIResourceLocator().getResource(ruleFile);
        }
        catch (IOException e) {
            throw new SmooksException("Failed to open rule file '" + ruleFile + "'.", (Throwable)e);
        }
        Properties rawRuleTable = new Properties();
        try {
            rawRuleTable.load(ruleStream);
        }
        catch (IOException e) {
            throw new SmooksException("Error reading InputStream to rule file '" + ruleFile + "'.", (Throwable)e);
        }
        finally {
            try {
                ruleStream.close();
            }
            catch (IOException e) {
                logger.debug((Object)("Error closing InputStream to Regex Rule file '" + ruleFile + "'."), (Throwable)e);
            }
        }
        Set<Map.Entry<Object, Object>> ruleEntrySet = rawRuleTable.entrySet();
        for (Map.Entry<Object, Object> rule : ruleEntrySet) {
            String ruleName = (String)rule.getKey();
            String rulePattern = (String)rule.getValue();
            this.rules.put(ruleName, Pattern.compile(rulePattern));
        }
    }
}

