/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.servlet.delivery;

import java.lang.reflect.Constructor;
import javax.servlet.http.HttpServletResponse;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.classpath.ClasspathUtils;
import org.milyn.container.ExecutionContext;
import org.milyn.servlet.delivery.ServletResponseWrapper;
import org.milyn.util.ClassUtil;

public abstract class ServletResponseWrapperFactory {
    public static ServletResponseWrapper createServletResponseWrapper(SmooksResourceConfiguration resourceConfig, ExecutionContext executionContext, HttpServletResponse originalResponse) {
        Constructor constructor;
        Class runtime = null;
        try {
            String className = ClasspathUtils.toClassName((String)resourceConfig.getResource());
            runtime = ClassUtil.forName((String)className, ServletResponseWrapperFactory.class);
        }
        catch (ClassNotFoundException e) {
            IllegalStateException state = new IllegalStateException("Unable to load " + resourceConfig.getResource());
            state.initCause(e);
            throw state;
        }
        try {
            constructor = runtime.getConstructor(ExecutionContext.class, HttpServletResponse.class);
        }
        catch (SecurityException e) {
            IllegalStateException state = new IllegalStateException("Container doesn't have permissions to load class " + runtime);
            state.initCause(e);
            throw state;
        }
        catch (NoSuchMethodException e) {
            IllegalStateException state = new IllegalStateException(runtime + " must contain a constructor with an arg signature of (" + ExecutionContext.class + ", " + HttpServletResponse.class + ")");
            state.initCause(e);
            throw state;
        }
        try {
            return (ServletResponseWrapper)((Object)constructor.newInstance(executionContext, originalResponse));
        }
        catch (ClassCastException e) {
            IllegalStateException state = new IllegalStateException("Failed to construct " + resourceConfig.getParameter("class") + ".  Must be an instance of " + ServletResponseWrapper.class);
            state.initCause(e);
            throw state;
        }
        catch (Exception e) {
            IllegalStateException state = new IllegalStateException("Failed to construct " + resourceConfig.getParameter("class") + ".");
            state.initCause(e);
            throw state;
        }
    }
}

