/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.servlet.http;

import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.delivery.ContentHandler;

public class HeaderAction
implements ContentHandler {
    public static final int ACTION_ADD = 0;
    public static final int ACTION_REMOVE = 1;
    private int action;
    private String headerName;
    private String headerValue;

    public void setConfiguration(SmooksResourceConfiguration resourceConfig) {
        if (resourceConfig == null) {
            IllegalStateException state = new IllegalStateException("Bad HeaderAction defintion.");
            state.initCause(new IllegalArgumentException("null 'unitDef' arg in constructor call."));
            throw state;
        }
        String actionParam = resourceConfig.getStringParameter("action");
        if (actionParam == null) {
            throw new IllegalStateException("'action' param not defined on HeaderAction SmooksResourceConfiguration.");
        }
        if ((actionParam = actionParam.trim().toLowerCase()).equals("add")) {
            this.action = 0;
        } else if (actionParam.equals("remove")) {
            this.action = 1;
        } else {
            throw new IllegalStateException("Unsupported header action '" + actionParam + "' defined on HeaderAction SmooksResourceConfiguration.");
        }
        this.headerName = resourceConfig.getStringParameter("header-name");
        if (this.headerName == null) {
            throw new IllegalStateException("'header-name' param not defined on HeaderAction SmooksResourceConfiguration.");
        }
        this.headerValue = resourceConfig.getStringParameter("header-value");
        if (this.action == 0 && this.headerValue == null) {
            throw new IllegalStateException("'header-value' param not defined on 'add' HeaderAction SmooksResourceConfiguration.");
        }
    }

    public int getAction() {
        return this.action;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String getHeaderValue() {
        if (this.action != 0) {
            throw new IllegalStateException("Illegal call to getHeaderValue() when action not 'add'.");
        }
        return this.headerValue;
    }

    public boolean equals(Object obj) {
        String stringObj;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof HeaderAction) {
            HeaderAction actionObj = (HeaderAction)obj;
            if (actionObj.action == this.action && actionObj.headerName.equals(this.headerName) && actionObj.headerValue.equals(this.headerValue)) {
                return true;
            }
        } else if (obj instanceof String && (stringObj = (String)obj).equals(this.headerName)) {
            return true;
        }
        return false;
    }

    public String toString() {
        return "HeaderAction: " + this.action + ", " + this.headerName + ", " + this.headerValue;
    }
}

