/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.servlet.delivery;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Filter;
import org.milyn.delivery.dom.SmooksDOMFilter;
import org.milyn.payload.FilterResult;
import org.milyn.payload.FilterSource;
import org.milyn.servlet.delivery.ServletResponseWrapper;
import org.milyn.servlet.http.HeaderAction;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLServletResponseWrapper
extends ServletResponseWrapper {
    private static Log logger = LogFactory.getLog(XMLServletResponseWrapper.class);
    private SmooksServletOutputStream stream;
    private PrintWriter printWriter;
    private Filter smooksFilter;
    private CharArrayWriter charArrayWriter = new CharArrayWriter();
    private List addHeaderActions = new Vector();
    private List removeHeaderActions = new Vector();
    public static final String SOURCE_DOCUMENT = XMLServletResponseWrapper.class.toString();

    public XMLServletResponseWrapper(ExecutionContext executionContext, HttpServletResponse originalResponse) {
        super(executionContext, originalResponse);
        this.smooksFilter = executionContext.getDeliveryConfig().newFilter(executionContext);
        this.initHeaderActions(executionContext.getDeliveryConfig().getObjects("http-response-header"));
    }

    private void initHeaderActions(List headerActions) {
        if (headerActions == null) {
            return;
        }
        for (int i = 0; i < headerActions.size(); ++i) {
            HeaderAction action = (HeaderAction)headerActions.get(i);
            if (action.getAction() == 0) {
                this.addHeaderActions.add(action);
                continue;
            }
            this.removeHeaderActions.add(action);
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.printWriter != null) {
            throw new IllegalStateException("Call to 'getOutputStream()' after call to 'getWriter()'.");
        }
        if (this.stream != null) {
            return this.stream;
        }
        this.stream = new SmooksServletOutputStream(this, this.charArrayWriter);
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.stream != null) {
            throw new IllegalStateException("Call to 'getWriter()' after call to 'getOutputStream()'.");
        }
        if (this.printWriter != null) {
            return this.printWriter;
        }
        this.printWriter = new SmooksPrintWriter(this.charArrayWriter, this);
        return this.printWriter;
    }

    public void addHeader(String name, String value) {
        if (this.assertAddHeader(name)) {
            super.addHeader(name, value);
        }
    }

    public void setDateHeader(String name, long value) {
        if (this.assertAddHeader(name)) {
            super.setDateHeader(name, value);
        }
    }

    public void setHeader(String name, String value) {
        if (this.assertAddHeader(name)) {
            super.setHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (this.assertAddHeader(name)) {
            super.setIntHeader(name, value);
        }
    }

    private boolean assertAddHeader(String name) {
        int removeCount = this.removeHeaderActions.size();
        for (int i = 0; i < removeCount; ++i) {
            if (!this.removeHeaderActions.get(i).equals(name)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverResponse() throws IOException {
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream(10240);
        this.modifyResponseHeaders();
        OutputStreamWriter writer = new OutputStreamWriter(outBuffer, this.getCharacterEncoding()){

            public void close() throws IOException {
                super.close();
            }
        };
        char[] content = this.charArrayWriter.toCharArray();
        try {
            Document sourceDoc = (Document)this.getContainerRequest().getAttribute((Object)SOURCE_DOCUMENT);
            if (sourceDoc == null) {
                StreamSource source = new StreamSource(new CharArrayReader(content));
                StreamResult result = new StreamResult(writer);
                FilterSource.setSource((ExecutionContext)this.getContainerRequest(), (Source)source);
                FilterResult.setResults((ExecutionContext)this.getContainerRequest(), (Result[])new Result[]{result});
                Filter.setCurrentExecutionContext((ExecutionContext)this.getContainerRequest());
                try {
                    this.smooksFilter.doFilter();
                }
                finally {
                    Filter.removeCurrentExecutionContext();
                }
            } else {
                logger.info((Object)"Filtering W3C DOM from down-stream Servlet/Filter.");
                if (this.smooksFilter instanceof SmooksDOMFilter) {
                    SmooksDOMFilter domFilter = (SmooksDOMFilter)this.smooksFilter;
                    Node deliveryNode = domFilter.filter(sourceDoc);
                    domFilter.serialize(deliveryNode, (Writer)writer);
                }
            }
            super.setIntHeader("Content-Length", outBuffer.size());
            this.getResponse().getOutputStream().write(outBuffer.toByteArray(), 0, outBuffer.size());
        }
        catch (SmooksException e) {
            IOException ioE = new IOException("Unable to deliver response.");
            PrintWriter printWriter = new PrintWriter(writer);
            String contentString = new String(content);
            ioE.initCause(e);
            printWriter.println("<pre>");
            ioE.printStackTrace(printWriter);
            printWriter.println("</pre>");
            printWriter.println("<hr/>");
            printWriter.println("<pre>");
            contentString = contentString.replaceAll("<", "&lt;");
            contentString = contentString.replaceAll(">", "&gt;");
            printWriter.write(contentString);
            printWriter.println("</pre>");
            throw ioE;
        }
        finally {
            this.getResponse().getOutputStream().flush();
        }
    }

    private void modifyResponseHeaders() {
        ServletResponse response = this.getResponse();
        for (int i = 0; i < this.addHeaderActions.size(); ++i) {
            HeaderAction action = (HeaderAction)this.addHeaderActions.get(i);
            if (action.getHeaderName().equals("Content-Type")) {
                response.setContentType(action.getHeaderValue());
                continue;
            }
            if (action.getHeaderName().equals("Content-Length")) {
                try {
                    response.setContentLength(Integer.parseInt(action.getHeaderValue()));
                }
                catch (NumberFormatException fe) {}
                continue;
            }
            super.setHeader(action.getHeaderName(), action.getHeaderValue());
        }
    }

    public void close() {
        if (this.printWriter != null) {
            this.printWriter.close();
        }
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                logger.warn((Object)"Response wrapper stream close error.", (Throwable)e);
            }
        }
    }

    class SmooksPrintWriter
    extends PrintWriter {
        CharArrayWriter charArrayWriter;
        ServletResponseWrapper responseWrapper;

        private SmooksPrintWriter(CharArrayWriter charArrayWriter, ServletResponseWrapper responseWrapper) throws IOException {
            super(charArrayWriter);
            this.charArrayWriter = charArrayWriter;
            this.responseWrapper = responseWrapper;
        }

        public void close() {
            super.close();
            this.charArrayWriter.close();
        }
    }

    class SmooksServletOutputStream
    extends ServletOutputStream {
        CharArrayWriter charArrayWriter;
        PrintWriter printWriter;
        ServletResponseWrapper responseWrapper;
        String charSet;

        private SmooksServletOutputStream(XMLServletResponseWrapper responseWrapper, CharArrayWriter charArrayWriter) {
            this.responseWrapper = responseWrapper;
            this.charArrayWriter = charArrayWriter;
            this.printWriter = new PrintWriter(charArrayWriter);
            this.charSet = responseWrapper.getCharacterEncoding();
        }

        public void close() throws IOException {
            this.charArrayWriter.close();
            this.printWriter.close();
            super.close();
        }

        public void write(int b) throws IOException {
            this.printWriter.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.printWriter.write(new String(b, off, len, this.charSet));
        }

        public void write(byte[] b) throws IOException {
            this.printWriter.write(new String(b, this.charSet));
        }

        public void print(boolean arg0) throws IOException {
            this.printWriter.print(arg0);
        }

        public void print(char arg0) throws IOException {
            this.printWriter.print(arg0);
        }

        public void print(double arg0) throws IOException {
            this.printWriter.print(arg0);
        }

        public void print(float arg0) throws IOException {
            this.printWriter.print(arg0);
        }

        public void print(int arg0) throws IOException {
            this.printWriter.print(arg0);
        }

        public void print(long arg0) throws IOException {
            this.printWriter.print(arg0);
        }

        public void print(String arg0) throws IOException {
            this.printWriter.print(arg0);
        }

        public void println() throws IOException {
            this.printWriter.println();
        }

        public void println(boolean arg0) throws IOException {
            this.printWriter.println(arg0);
        }

        public void println(char arg0) throws IOException {
            this.printWriter.println(arg0);
        }

        public void println(double arg0) throws IOException {
            this.printWriter.println(arg0);
        }

        public void println(float arg0) throws IOException {
            this.printWriter.println(arg0);
        }

        public void println(int arg0) throws IOException {
            this.printWriter.println(arg0);
        }

        public void println(long arg0) throws IOException {
            this.printWriter.println(arg0);
        }

        public void println(String arg0) throws IOException {
            this.printWriter.println(arg0);
        }
    }
}

