/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.profile.ProfileStore;
import org.milyn.resource.ContainerResourceLocator;
import org.milyn.servlet.DeviceProfiler;
import org.milyn.servlet.container.HttpServletExecutionContext;
import org.milyn.servlet.container.ServletApplicationContext;
import org.milyn.servlet.delivery.ServletResponseWrapper;
import org.milyn.servlet.delivery.ServletResponseWrapperFactory;
import org.milyn.servlet.delivery.XMLServletResponseWrapper;
import org.milyn.useragent.UnknownUseragentException;
import org.xml.sax.SAXException;

public class SmooksServletFilter
implements Filter {
    private static final String SMOOKS_CONFIG_PARAM = "SmooksConfig";
    private static final String DEFAULT_CONFIG = "/smooks-config.xml";
    private ServletApplicationContext smooksContainerContext;
    private FilterToServletConfigAdapter servletConfig;
    private static Log logger = LogFactory.getLog(SmooksServletFilter.class);

    public void init(FilterConfig config) throws ServletException {
        try {
            this.servletConfig = new FilterToServletConfigAdapter(config);
            this.smooksContainerContext = new ServletApplicationContext(config.getServletContext(), this.servletConfig);
            this.loadConfigStore();
            DeviceProfiler.setProfileStore((ProfileStore)this.smooksContainerContext.getProfileStore(), (ServletContext)this.servletConfig.getServletContext());
            logger.info((Object)"Smooks Servlet Filter initalised.");
        }
        catch (Exception e) {
            throw new ServletException("Smooks configuration load failure.", (Throwable)e);
        }
    }

    private void loadConfigStore() throws IllegalArgumentException, IOException, SAXException, URISyntaxException {
        ContainerResourceLocator containerResLocator = this.smooksContainerContext.getResourceLocator();
        InputStream smooksConfigStream = containerResLocator.getResource(SMOOKS_CONFIG_PARAM, DEFAULT_CONFIG);
        this.smooksContainerContext.getStore().registerResources("smooks-config", smooksConfigStream);
        logger.info((Object)"Smooks Config Store load complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ServletResponseWrapper responseWrapper = null;
        try {
            long startTime = 0L;
            HttpServletExecutionContext executionContext = new HttpServletExecutionContext((HttpServletRequest)request, this.servletConfig, this.smooksContainerContext);
            if (logger.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
            }
            if ((responseWrapper = this.getResponseWrapper(request.getParameter("smooksrw"), response, executionContext)) == null) {
                responseWrapper = this.getResponseWrapper("html-smooksrw", response, executionContext);
            }
            if (responseWrapper == null) {
                responseWrapper = new XMLServletResponseWrapper(executionContext, (HttpServletResponse)response);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Applying response wrapper [" + ((Object)((Object)responseWrapper)).getClass() + "] to request [" + ((HttpServletRequest)request).getRequestURI() + "]."));
            }
            filterChain.doFilter(request, (ServletResponse)responseWrapper);
            responseWrapper.deliverResponse();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("[doFilter] " + (System.currentTimeMillis() - startTime) + "ms"));
            }
        }
        catch (UnknownUseragentException e) {
            logger.error((Object)"Unknown Device.  Smooks not being used to deliver content.", (Throwable)e);
            filterChain.doFilter(request, response);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (responseWrapper != null) {
                responseWrapper.close();
            }
        }
    }

    private ServletResponseWrapper getResponseWrapper(String selector, ServletResponse response, ExecutionContext executionContext) {
        List resourceConfigList;
        ServletResponseWrapper responseWrapper = null;
        if (selector != null && (resourceConfigList = executionContext.getDeliveryConfig().getSmooksResourceConfigurations(selector)) != null && !resourceConfigList.isEmpty()) {
            responseWrapper = ServletResponseWrapperFactory.createServletResponseWrapper((SmooksResourceConfiguration)resourceConfigList.get(0), executionContext, (HttpServletResponse)response);
        }
        return responseWrapper;
    }

    public void destroy() {
        this.smooksContainerContext.getStore().close();
        this.servletConfig.getServletContext().removeAttribute(DeviceProfiler.PROFILE_STORE_CTX_KEY);
    }

    private class FilterToServletConfigAdapter
    implements ServletConfig {
        private FilterConfig config;

        private FilterToServletConfigAdapter(FilterConfig config) {
            this.config = config;
        }

        public String getServletName() {
            return this.config.getFilterName();
        }

        public ServletContext getServletContext() {
            return this.config.getServletContext();
        }

        public String getInitParameter(String paramName) {
            return this.config.getInitParameter(paramName);
        }

        public Enumeration getInitParameterNames() {
            return this.config.getInitParameterNames();
        }
    }
}

