/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.servlet.container;

import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.milyn.cdr.SmooksResourceConfigurationStore;
import org.milyn.container.ApplicationContext;
import org.milyn.profile.DefaultProfileStore;
import org.milyn.profile.ProfileStore;
import org.milyn.resource.ContainerResourceLocator;
import org.milyn.resource.ExternalResourceLocator;
import org.milyn.resource.ServletResourceLocator;
import org.milyn.resource.URIResourceLocator;

public class ServletApplicationContext
implements ApplicationContext {
    private ServletResourceLocator resourceLocator;
    private ServletContext servletContext;
    private SmooksResourceConfigurationStore resStore;
    private DefaultProfileStore profileStore = new DefaultProfileStore();

    public ServletApplicationContext(ServletContext servletContext, ServletConfig servletConfig) {
        if (servletContext == null) {
            throw new IllegalArgumentException("null 'servletContext' arg in constructor call.");
        }
        if (servletConfig == null) {
            throw new IllegalArgumentException("null 'servletConfig' arg in constructor call.");
        }
        this.servletContext = servletContext;
        this.resourceLocator = new ServletResourceLocator(servletConfig, (ExternalResourceLocator)new URIResourceLocator());
        this.resStore = new SmooksResourceConfigurationStore((ApplicationContext)this);
    }

    public ContainerResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    public void setAttribute(Object key, Object value) {
        this.servletContext.setAttribute(key.toString(), value);
    }

    public Object getAttribute(Object key) {
        return this.servletContext.getAttribute(key.toString());
    }

    public void removeAttribute(Object key) {
        this.servletContext.removeAttribute(key.toString());
    }

    public SmooksResourceConfigurationStore getStore() {
        return this.resStore;
    }

    public ProfileStore getProfileStore() {
        return this.profileStore;
    }

    public void setResourceLocator(ContainerResourceLocator resourceLocator) {
        throw new UnsupportedOperationException("Cannot set the resource locator on the " + ServletApplicationContext.class.getName() + " class.");
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Map getAttributes() {
        throw new UnsupportedOperationException("Method getAttributes is not implemented");
    }
}

