/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.servlet.container;

import java.net.URI;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.ContentDeliveryConfigBuilder;
import org.milyn.event.ExecutionEventListener;
import org.milyn.profile.ProfileSet;
import org.milyn.servlet.ServletUAContext;
import org.milyn.servlet.container.ServletApplicationContext;
import org.milyn.useragent.UAContext;
import org.milyn.useragent.UnknownUseragentException;
import org.milyn.useragent.request.HttpRequest;

public class HttpServletExecutionContext
implements ExecutionContext,
HttpRequest {
    private static Log logger = LogFactory.getLog(HttpServletExecutionContext.class);
    private HttpServletRequest servletRequest;
    private UAContext uaContext;
    private ContentDeliveryConfig deliveryConfig;
    private ApplicationContext applicationContext;
    private URI requestURI;
    private ExecutionEventListener executionListener;
    private Throwable terminationError;

    public HttpServletExecutionContext(HttpServletRequest servletRequest, ServletConfig servletConfig, ServletApplicationContext containerContext) throws UnknownUseragentException {
        if (servletRequest == null) {
            throw new IllegalArgumentException("null 'servletRequest' arg in constructor call.");
        }
        if (containerContext == null) {
            throw new IllegalArgumentException("null 'applicationContext' arg in constructor call.");
        }
        this.servletRequest = servletRequest;
        this.applicationContext = containerContext;
        this.uaContext = ServletUAContext.getInstance((HttpServletRequest)servletRequest, (ServletConfig)servletConfig);
        this.deliveryConfig = ContentDeliveryConfigBuilder.getConfig((ProfileSet)this.uaContext.getProfileSet(), (ApplicationContext)containerContext, null);
    }

    public void setDocumentSource(URI docSource) {
        logger.error((Object)"Cannot set the document source on this context implementation.");
    }

    public URI getDocumentSource() {
        if (this.requestURI == null) {
            String queryString = this.servletRequest.getQueryString();
            this.requestURI = queryString != null ? URI.create(this.servletRequest.getRequestURL().toString() + "?" + queryString) : URI.create(this.servletRequest.getRequestURL().toString());
        }
        return this.requestURI;
    }

    public String getHeader(String name) {
        return this.servletRequest.getHeader(name);
    }

    public String getParameter(String name) {
        return this.servletRequest.getParameter(name);
    }

    public Enumeration getParameterNames() {
        return this.servletRequest.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        return this.servletRequest.getParameterValues(name);
    }

    public ApplicationContext getContext() {
        return this.applicationContext;
    }

    public ProfileSet getTargetProfiles() {
        return this.uaContext.getProfileSet();
    }

    public ContentDeliveryConfig getDeliveryConfig() {
        return this.deliveryConfig;
    }

    public void setContentEncoding(String contentEncoding) throws IllegalArgumentException {
        logger.error((Object)"Cannot set the contentEncoding on this context implementation.");
    }

    public String getContentEncoding() {
        return this.servletRequest.getCharacterEncoding();
    }

    public void setEventListener(ExecutionEventListener listener) {
        this.executionListener = listener;
    }

    public ExecutionEventListener getEventListener() {
        return this.executionListener;
    }

    public void setTerminationError(Throwable terminationError) {
        this.terminationError = terminationError;
    }

    public Throwable getTerminationError() {
        return this.terminationError;
    }

    public String getConfigParameter(String name) {
        return this.getConfigParameter(name, null);
    }

    public String getConfigParameter(String name, String defaultVal) {
        return ParameterAccessor.getStringParameter((String)name, (String)defaultVal, (ContentDeliveryConfig)this.deliveryConfig);
    }

    public boolean isDefaultSerializationOn() {
        return true;
    }

    public void setAttribute(Object key, Object value) {
        this.servletRequest.setAttribute(key.toString(), value);
    }

    public Object getAttribute(Object key) {
        return this.servletRequest.getAttribute(key.toString());
    }

    public void removeAttribute(Object key) {
        this.servletRequest.removeAttribute(key.toString());
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public Map getAttributes() {
        throw new UnsupportedOperationException("Method getAttributes is not implemented");
    }
}

