/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.test.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AntRunner {
    private Project project = new Project();

    public AntRunner(String antScript, String ... properties) throws IOException {
        StackTraceElement[] thisStack = Thread.currentThread().getStackTrace();
        for (int i = 0; i < thisStack.length; ++i) {
            StackTraceElement stackFrame = thisStack[i];
            if (!stackFrame.getClassName().equals(this.getClass().getName())) continue;
            StackTraceElement callerStackFrame = thisStack[i + 1];
            try {
                Class<?> callerClass = Class.forName(callerStackFrame.getClassName());
                InputStream antScriptStream = callerClass.getResourceAsStream(antScript);
                if (antScriptStream == null) {
                    throw new RuntimeException("Unable resolve Ant Script resource '" + antScript + "' relative to caller class '" + callerClass.getName() + "'.");
                }
                this.configureProject(antScriptStream, properties);
                return;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unexpected Exception: Unable resolve caller Class '" + callerStackFrame.getClassName() + "' for AntRunner on current Thread.");
            }
        }
        throw new RuntimeException("Unexpected Exception: Unable resolve caller Class for AntRunner on current Thread.");
    }

    public AntRunner(InputStream antScript, String ... properties) throws IOException {
        this.configureProject(antScript, properties);
    }

    public AntRunner run(String target) {
        if (target == null) {
            throw new IllegalArgumentException("null 'target' argument.");
        }
        this.project.executeTarget(target);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureProject(InputStream antScript, String[] properties) throws IOException {
        if (antScript == null) {
            throw new IllegalArgumentException("null 'antScript' argument.");
        }
        try {
            this.project.init();
            DefaultLogger antLogger = new DefaultLogger();
            antLogger.setErrorPrintStream(System.err);
            antLogger.setOutputPrintStream(System.out);
            antLogger.setMessageOutputLevel(2);
            this.project.addBuildListener((BuildListener)antLogger);
            this.project.setBaseDir(new File("./"));
            File executeScript = new File("./target/ant-exec.xml");
            FileOutputStream fileOs = new FileOutputStream(executeScript);
            try {
                byte[] readBuf = new byte[254];
                int readCount = 0;
                while ((readCount = antScript.read(readBuf)) != -1) {
                    fileOs.write(readBuf, 0, readCount);
                }
            }
            finally {
                fileOs.flush();
                fileOs.close();
            }
            ProjectHelper.configureProject((Project)this.project, (File)executeScript);
            if (properties != null) {
                for (String property : properties) {
                    int eqIndex = property.indexOf(61);
                    if (eqIndex == -1 || eqIndex + 1 == property.length()) {
                        throw new RuntimeException("Invalid AntRunner property '" + property + "'.  No value.");
                    }
                    String key = property.substring(0, eqIndex);
                    String value = property.substring(eqIndex + 1, property.length());
                    this.project.setProperty(key, value);
                }
            }
        }
        finally {
            antScript.close();
        }
    }
}

