/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.ExampleURIs;
import java.io.IOException;
import java.net.URI;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataType;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.OWLList;
import org.mindswap.owl.vocabulary.XSD;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.expression.Condition;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.grounding.WSDLGrounding;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.IfThenElse;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Produce;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.process.execution.DefaultProcessMonitor;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.Loc;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.process.variable.OutputBinding;
import org.mindswap.owls.process.variable.Parameter;
import org.mindswap.owls.process.variable.ValueConstant;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.DataPropertyAtom;
import org.mindswap.swrl.SWRLDataObject;
import org.mindswap.swrl.SWRLFactory;
import org.mindswap.utils.URIUtils;

public class CreateComplexProcess {
    OWLKnowledgeBase kb;
    OWLOntology ont;
    SWRLFactory.ISWRLFactory swrl;
    Process BookFinder;
    Process BNPrice;
    Process AmazonPrice;
    OWLDataType xsdString;
    OWLDataType xsdFloat;
    OWLClass Price;
    OWLDataProperty amount;
    Input CP_AmazonPrice;
    Input CP_BNPrice;
    Output CP_Bookstore;
    Output CP_OutputPrice;

    private URI uri(String localName) {
        return URIUtils.createURI(ExampleURIs.FIND_CHEAPER_BOOK_OWLS12, localName);
    }

    private Service createService() {
        Service service = this.ont.createService(this.uri("TestService"));
        CompositeProcess process = this.createProcess();
        Profile profile = this.createProfile(process);
        WSDLGrounding grounding = this.createGrounding(process);
        service.addProfile(profile);
        service.setProcess(process);
        service.addGrounding(grounding);
        return service;
    }

    private Profile createProfile(Process process) {
        int i;
        Profile profile = this.ont.createProfile(this.uri("TestProfile"));
        profile.setLabel("Cheaper Book Finder", null);
        profile.setTextDescription("Find the price of book in Amazon and Barnes & Nobles and return the cheaper price");
        for (i = 0; i < process.getInputs().size(); ++i) {
            Input input = (Input)process.getInputs().get(i);
            profile.addInput(input);
        }
        for (i = 0; i < process.getOutputs().size(); ++i) {
            Output output = (Output)process.getOutputs().get(i);
            profile.addOutput(output);
        }
        return profile;
    }

    private WSDLGrounding createGrounding(CompositeProcess process) {
        WSDLGrounding grounding = this.ont.createWSDLGrounding(this.uri("TestGrounding"));
        OWLIndividualList<Process> list = process.getComposedOf().getAllProcesses(false);
        for (Process p : list) {
            if (!(p instanceof AtomicProcess)) continue;
            grounding.addGrounding((AtomicGrounding)((AtomicProcess)p).getGrounding().castTo(WSDLAtomicGrounding.class));
        }
        return grounding;
    }

    private CompositeProcess createProcess() {
        CompositeProcess process = this.ont.createCompositeProcess(this.uri("TestProcess"));
        Input inputBookName = process.createInput(this.uri("BookName"), this.xsdString);
        Output outputBookstore = process.createOutput(this.uri("Bookstore"), this.xsdString);
        Output outputBookPrice = process.createOutput(this.uri("BookPrice"), this.Price);
        Sequence sequence = this.ont.createSequence(null);
        process.setComposedOf(sequence);
        Perform FindBookInfo = this.ont.createPerform(this.uri("FindBookInfo"));
        FindBookInfo.setProcess(this.BookFinder);
        FindBookInfo.addBinding(this.BookFinder.getInput(), OWLS_1_2.Process.ThisPerform, inputBookName);
        sequence.addComponent(FindBookInfo);
        SplitJoin split = this.ont.createSplitJoin(null);
        Perform FindAmazonPrice = this.ont.createPerform(this.uri("FindAmazonPrice"));
        FindAmazonPrice.setProcess(this.AmazonPrice);
        FindAmazonPrice.addBinding(this.AmazonPrice.getInput(), FindBookInfo, this.BookFinder.getOutput());
        split.addComponent(FindAmazonPrice);
        Perform FindBNPrice = this.ont.createPerform(this.uri("FindBNPrice"));
        FindBNPrice.setProcess(this.BNPrice);
        FindBNPrice.addBinding(this.BNPrice.getInput(), FindBookInfo, this.BookFinder.getOutput());
        split.addComponent(FindBNPrice);
        sequence.addComponent(split);
        CompositeProcess ComparePricesProc = this.createComparePricesProcess();
        Perform ComparePrices = this.ont.createPerform(this.uri("ComparePrices"));
        ComparePrices.setProcess(ComparePricesProc);
        ComparePrices.addBinding(this.CP_AmazonPrice, FindAmazonPrice, this.AmazonPrice.getOutput());
        ComparePrices.addBinding(this.CP_BNPrice, FindBNPrice, this.BNPrice.getOutput());
        sequence.addComponent(ComparePrices);
        Result result = process.createResult(null);
        result.addBinding(outputBookstore, ComparePrices, this.CP_Bookstore);
        result.addBinding(outputBookPrice, ComparePrices, this.CP_OutputPrice);
        return process;
    }

    private CompositeProcess createComparePricesProcess() {
        CompositeProcess ComparePricesProc = this.ont.createCompositeProcess(this.uri("ComparePricesProcess"));
        this.CP_AmazonPrice = ComparePricesProc.createInput(this.uri("CP_AmazonPrice"), this.Price);
        this.CP_BNPrice = ComparePricesProc.createInput(this.uri("CP_BNPrice"), this.Price);
        Loc CP_AmazonPriceAmount = ComparePricesProc.createLoc(this.uri("CP_AmazonPriceAmount"), this.xsdFloat);
        Loc CP_BNPriceAmount = ComparePricesProc.createLoc(this.uri("CP_BNPriceAmount"), this.xsdFloat);
        this.CP_OutputPrice = ComparePricesProc.createOutput(this.uri("CP_OutputPrice"), this.Price);
        this.CP_Bookstore = ComparePricesProc.createOutput(this.uri("CP_Bookstore"), this.xsdString);
        Condition.SWRL precondition1 = this.ont.createSWRLCondition(null);
        DataPropertyAtom atom1 = this.swrl.createDataPropertyAtom(this.amount, this.CP_AmazonPrice, CP_AmazonPriceAmount);
        OWLList<Atom> list1 = this.swrl.createList(atom1);
        precondition1.setBody(list1);
        ComparePricesProc.addCondition(precondition1);
        Condition.SWRL precondition2 = this.ont.createSWRLCondition(null);
        DataPropertyAtom atom2 = this.swrl.createDataPropertyAtom(this.amount, this.CP_BNPrice, CP_BNPriceAmount);
        OWLList<Atom> list2 = this.swrl.createList(atom2);
        precondition2.setBody(list2);
        ComparePricesProc.addCondition(precondition2);
        IfThenElse ifThenElse = this.ont.createIfThenElse(null);
        ComparePricesProc.setComposedOf(ifThenElse);
        Condition.SWRL condition = this.ont.createSWRLCondition(null);
        BuiltinAtom atom = this.swrl.createLessThan(CP_BNPriceAmount.castTo(SWRLDataObject.class), CP_AmazonPriceAmount.castTo(SWRLDataObject.class));
        OWLList<Atom> list = this.swrl.createList(atom);
        condition.setBody(list);
        ifThenElse.setCondition(condition);
        ifThenElse.setThen(this.createProduceSequence("BN", this.CP_BNPrice));
        ifThenElse.setElse(this.createProduceSequence("Amazon", this.CP_AmazonPrice));
        return ComparePricesProc;
    }

    private Sequence createProduceSequence(String bookstore, Input price) {
        Produce producePrice = this.ont.createProduce(this.uri("Produce" + bookstore + "Price"));
        producePrice.addBinding(this.CP_OutputPrice, OWLS_1_2.Process.ThisPerform, (Parameter)price);
        Produce produceName = this.ont.createProduce(this.uri("Produce" + bookstore + "Name"));
        OutputBinding binding = this.ont.createOutputBinding(null);
        binding.setProcessVar(this.CP_Bookstore);
        ValueConstant valueData = this.ont.createValueConstant(this.ont.createDataValue(bookstore), binding);
        binding.setValue(valueData);
        produceName.addBinding(binding);
        Sequence sequence = this.ont.createSequence(null);
        sequence.addComponent(producePrice);
        sequence.addComponent(produceName);
        return sequence;
    }

    public void run() throws ExecutionException, IOException {
        this.kb = OWLFactory.createKB();
        this.ont = this.kb.createOntology(ExampleURIs.FIND_CHEAPER_BOOK_OWLS12);
        this.swrl = SWRLFactory.createFactory(this.ont);
        this.BookFinder = this.kb.readService(ExampleURIs.BOOK_FINDER_OWLS12).getProcess();
        this.BNPrice = this.kb.readService(ExampleURIs.BN_BOOK_PRICE_OWLS12).getProcess();
        this.AmazonPrice = this.kb.readService(ExampleURIs.AMAZON_BOOK_PRICE_OWLS12).getProcess();
        this.ont.addImport(this.kb.getOntology(ExampleURIs.BOOK_FINDER_OWLS12));
        this.ont.addImport(this.kb.getOntology(ExampleURIs.BN_BOOK_PRICE_OWLS12));
        this.ont.addImport(this.kb.getOntology(ExampleURIs.AMAZON_BOOK_PRICE_OWLS12));
        this.xsdString = this.kb.getDataType(XSD.string);
        this.xsdFloat = this.kb.getDataType(XSD.xsdFloat);
        this.Price = this.kb.getClass(URIUtils.createURI(URI.create("http://on.cs.unibas.ch/owl/concepts.owl#"), "Price"));
        this.amount = this.kb.getDataProperty(URIUtils.createURI(URI.create("http://on.cs.unibas.ch/owl/concepts.owl#"), "amount"));
        Service s = this.createService();
        this.ont.write(System.out, ExampleURIs.FIND_CHEAPER_BOOK_OWLS12);
        System.out.println();
        ProcessExecutionEngine exec = OWLSFactory.createExecutionEngine();
        exec.addMonitor(new DefaultProcessMonitor());
        Process process = s.getProcess();
        ValueMap<Input, OWLValue> inputs = new ValueMap<Input, OWLValue>();
        inputs.setValue(process.getInput(), this.kb.createDataValue("City of Glass"));
        ValueMap<Output, OWLValue> outputs = exec.execute(process, inputs, this.kb);
        String bookstore = outputs.getStringValue(process.getOutput("Bookstore"));
        OWLIndividual price = outputs.getIndividualValue(process.getOutput("BookPrice"));
        System.out.println("Cheaper price found in " + bookstore);
        System.out.println("Price is $" + price.getProperty(this.amount));
        System.out.println();
    }

    public static void main(String[] args) {
        CreateComplexProcess test = new CreateComplexProcess();
        try {
            test.run();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

