/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.ExampleURIs;
import java.net.URI;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.vocabulary.XSD;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.JavaAtomicGrounding;
import org.mindswap.owls.grounding.JavaGrounding;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.service.Service;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.URIUtils;

public class CreateJavaGrounding {
    public static void main(String[] args) throws Exception {
        CreateJavaGrounding test = new CreateJavaGrounding();
        test.run();
    }

    public void run() throws Exception {
        URI baseURI = ExampleURIs.JGROUNDING_OWLS12;
        OWLOntology ont = OWLFactory.createKB().createOntology(baseURI);
        Service service = ont.createService(URIUtils.createURI(baseURI, "MyService"));
        AtomicProcess process = ont.createAtomicProcess(URIUtils.createURI(baseURI, "MyProcess"));
        service.setProcess(process);
        Input input1 = ont.createInput(URIUtils.createURI(baseURI, "myInput1"));
        input1.setParamType(ont.getDataType(XSD.xsdInt));
        input1.setProcess(process);
        Input input2 = ont.createInput(URIUtils.createURI(baseURI, "myInput2"));
        input2.setParamType(ont.getDataType(XSD.xsdDouble));
        input2.setProcess(process);
        Output output = ont.createOutput(URIUtils.createURI(baseURI, "myOutput"));
        output.setParamType(ont.getDataType(XSD.string));
        output.setProcess(process);
        JavaAtomicGrounding jAtomicGround = ont.createJavaAtomicGrounding(URIUtils.createURI(baseURI, "MyJAtomGround"));
        jAtomicGround.setOutput(URIUtils.createURI(baseURI, "JPar1"), String.class.getName(), output);
        jAtomicGround.addInputParameter(URIUtils.createURI(baseURI, "JIn1"), Integer.TYPE.getName(), 0, input1);
        jAtomicGround.addInputParameter(URIUtils.createURI(baseURI, "JIn2"), Double.class.getName(), 1, input2);
        jAtomicGround.setClazz(CreateJavaGrounding.class.getName());
        jAtomicGround.setMethod("testIt");
        jAtomicGround.setProcess(process);
        JavaGrounding jGrounding = ont.createJavaGrounding(URIUtils.createURI(baseURI, "MyJGrounding"));
        jGrounding.addGrounding(jAtomicGround);
        jGrounding.setService(service);
        ont.write(System.out, baseURI);
        ValueMap<Input, OWLValue> inputs = new ValueMap<Input, OWLValue>();
        inputs.setValue(process.getInput("myInput1"), ont.createDataValue(72));
        inputs.setValue(process.getInput("myInput2"), ont.createDataValue(80.0));
        System.out.println();
        System.out.println("Executing service ...");
        System.out.println("with inputs:      " + inputs);
        ProcessExecutionEngine exec = OWLSFactory.createExecutionEngine();
        long time = System.nanoTime();
        ValueMap<Output, OWLValue> outputs = exec.execute(process, inputs, null);
        time = (System.nanoTime() - time) / 1000L;
        System.out.printf("returned outputs: %s%n", outputs);
        System.out.printf("execution took:   %6d\u00b5s%n", time);
    }

    public String testIt(int x, Double y) throws Exception {
        double z = (double)x * y;
        System.out.printf("%d * %.1f = %.1f%n", x, y, z);
        return "Return value of JavaGrounding " + z;
    }
}

