/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.ExampleURIs;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.mindswap.common.Variable;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.grounding.WSDLGrounding;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.URIUtils;
import org.mindswap.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSequence {
    public static final URI baseURI = URI.create("http://www.example.org/BookPrice.owl#");
    OWLOntology ont;

    Service createSequenceService(List<Service> services) {
        Service service = this.ont.createService(URIUtils.createURI(baseURI, "BookService"));
        CompositeProcess process = this.ont.createCompositeProcess(URIUtils.createURI(baseURI, "BookProcess"));
        Profile profile = this.ont.createProfile(URIUtils.createURI(baseURI, "BookProfile"));
        WSDLGrounding grounding = this.ont.createWSDLGrounding(URIUtils.createURI(baseURI, "BookGrounding"));
        System.out.println(this.ont.getKB().getServices(false));
        this.createSequenceProcess(process, services);
        this.createProfile(profile, process);
        OWLIndividualList<Process> list = process.getComposedOf().getAllProcesses(false);
        for (Process pc : list) {
            AtomicGrounding<?> ag;
            if (!(pc instanceof AtomicProcess) || (ag = ((AtomicProcess)pc).getGrounding()) == null) continue;
            grounding.addGrounding((AtomicGrounding)ag.castTo(WSDLAtomicGrounding.class));
        }
        profile.setLabel(this.createLabel(services), null);
        profile.setTextDescription(profile.getLabel(null));
        service.addProfile(profile);
        service.setProcess(process);
        service.addGrounding(grounding);
        return service;
    }

    String createLabel(List<Service> services) {
        String label = "[";
        for (int i = 0; i < services.size(); ++i) {
            Service s = services.get(i);
            if (i > 0) {
                label = label + " + ";
            }
            label = label + s.getLabel(null);
        }
        label = label + "]";
        return label;
    }

    Profile createProfile(Profile profile, Process process) {
        for (Input input : process.getInputs()) {
            profile.addInput(input);
        }
        for (Output output : process.getOutputs()) {
            profile.addOutput(output);
        }
        return profile;
    }

    CompositeProcess createSequenceProcess(CompositeProcess compositeProcess, List<Service> services) {
        boolean createOutput;
        Input input;
        Sequence sequence = this.ont.createSequence(null);
        compositeProcess.setComposedOf(sequence);
        Perform[] performs = new Perform[services.size()];
        for (int i = 0; i < services.size(); ++i) {
            Service s = services.get(i);
            Process p = s.getProcess();
            performs[i] = this.ont.createPerform(null);
            performs[i].setProcess(p);
            sequence.addComponent(performs[i]);
            if (i <= 0) continue;
            Perform prevPerform = performs[i - 1];
            input = (Input)p.getInputs().get(0);
            Output output = (Output)prevPerform.getProcess().getOutputs().get(0);
            performs[i].addBinding(input, prevPerform, output);
        }
        Perform firstPerform = performs[0];
        Perform lastPerform = performs[services.size() - 1];
        boolean createInput = firstPerform.getProcess().getInputs().size() > 0;
        boolean bl = createOutput = lastPerform.getProcess().getOutputs().size() > 0;
        if (createInput) {
            input = (Input)firstPerform.getProcess().getInputs().get(0);
            Input newInput = this.ont.createInput(URIUtils.createURI(baseURI, "TestInput"));
            newInput.setLabel(input.getLabel(null), null);
            newInput.setParamType(input.getParamType());
            newInput.setProcess(compositeProcess);
            performs[0].addBinding(input, OWLS_1_2.Process.ThisPerform, newInput);
        }
        if (createOutput) {
            Output output = (Output)lastPerform.getProcess().getOutputs().get(0);
            Output newOutput = this.ont.createOutput(URIUtils.createURI(baseURI, "TestOutput"));
            newOutput.setLabel(output.toPrettyString(), null);
            newOutput.setParamType(output.getParamType());
            newOutput.setProcess(compositeProcess);
            Result result = this.ont.createResult(null);
            result.addBinding(newOutput, lastPerform, output);
            compositeProcess.addResult(result);
        }
        return compositeProcess;
    }

    public void runTest() throws Exception {
        OWLKnowledgeBase kb = OWLFactory.createKB();
        this.ont = kb.createOntology(URIUtils.standardURI(baseURI));
        ProcessExecutionEngine exec = OWLSFactory.createExecutionEngine();
        Service s1 = kb.readService(ExampleURIs.BOOK_FINDER_OWLS12);
        Service s2 = kb.readService(ExampleURIs.BN_BOOK_PRICE_OWLS12);
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(s1);
        services.add(s2);
        Service s = this.createSequenceService(services);
        this.ont.write(System.out, baseURI);
        System.out.println();
        Process process = s.getProcess();
        ValueMap<Input, OWLValue> inputs = new ValueMap<Input, OWLValue>();
        inputs.setValue((Input)((Variable)process.getInputs().get(0)), kb.createDataValue("City of Glass"));
        System.out.print("Executing...");
        ValueMap<Output, OWLValue> outputs = exec.execute(process, inputs, kb);
        System.out.println("done");
        OWLIndividual outValue = outputs.getIndividualValue(process.getOutput());
        System.out.println("Book Price = ");
        System.out.println(Utils.formatRDF(outValue.toRDF(true, true)));
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        CreateSequence test = new CreateSequence();
        test.runTest();
    }
}

