/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.ExampleURIs;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.execution.DefaultProcessMonitor;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.service.Service;
import org.mindswap.query.ValueMap;

public class ExecutionMonitor {
    public static void main(String[] args) throws Exception {
        ProcessExecutionEngine exec = OWLSFactory.createExecutionEngine();
        exec.addMonitor(new CustomProcessMonitor());
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.setReasoner("Pellet");
        Service service = kb.readService(ExampleURIs.FRENCH_DICTIONARY_OWLS12);
        Process process = service.getProcess();
        ValueMap<Input, OWLValue> inputs = new ValueMap<Input, OWLValue>();
        inputs.setValue(process.getInput("InputString"), kb.createDataValue("mere"));
        exec.execute(process, inputs, kb);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CustomProcessMonitor
    extends DefaultProcessMonitor {
        JTextArea textArea;
        JButton execButton;

        public CustomProcessMonitor() {
            JFrame info = new JFrame("Execution results");
            this.textArea = new JTextArea(15, 40);
            this.textArea.setEditable(false);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.execButton = new JButton("Continue");
            this.execButton.setEnabled(false);
            this.execButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CustomProcessMonitor.this.execButton.setEnabled(false);
                }
            });
            this.print("Initializing...");
            info.setDefaultCloseOperation(3);
            info.getContentPane().setLayout(new BoxLayout(info.getContentPane(), 1));
            info.getContentPane().add(new JScrollPane(this.textArea));
            info.getContentPane().add(this.execButton);
            this.execButton.setAlignmentX(0.5f);
            info.pack();
            info.setVisible(true);
        }

        private void print(String msg) {
            this.textArea.append(msg);
            this.textArea.setCaretPosition(this.textArea.getText().length());
        }

        private void println(String msg) {
            this.textArea.append(msg + "\n");
            this.textArea.setCaretPosition(this.textArea.getText().length());
        }

        private void println() {
            this.textArea.append("\n");
            this.textArea.setCaretPosition(this.textArea.getText().length());
        }

        @Override
        public void executionStarted() {
            this.println("done.");
            this.println();
        }

        @Override
        public void executionFinished() {
            this.println();
            this.println("No more processes to execute, execution finished succesfully!");
            this.println();
        }

        @Override
        public void executionStarted(Process process, ValueMap<Input, OWLValue> inputs) {
            this.println("Process: " + process);
            this.println("Inputs: ");
            for (Input input : process.getInputs()) {
                this.print(input.getLabel(null) + " =  ");
                OWLValue value = inputs.getValue(input);
                if (value.isDataValue()) {
                    this.println(value.toString());
                    continue;
                }
                OWLIndividual ind = (OWLIndividual)value;
                if (ind.isAnon()) {
                    this.println(ind.toRDF(false, false));
                    continue;
                }
                this.println(value.toString());
            }
            this.println();
            this.println("Click 'Continue' to start execution");
            this.execButton.setEnabled(true);
            while (this.execButton.isEnabled()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.println();
            this.print("Executing...");
        }

        @Override
        public void executionFinished(Process process, ValueMap<Input, OWLValue> inputs, ValueMap<Output, OWLValue> outputs) {
            this.println("done.");
            this.println();
            this.println("Outputs: ");
            for (Output output : process.getOutputs()) {
                this.print(output.getLabel(null) + " =  ");
                OWLValue value = outputs.getValue(output);
                if (value.isDataValue()) {
                    this.println(value.toString());
                    continue;
                }
                OWLIndividual ind = (OWLIndividual)value;
                if (ind.isAnon()) {
                    this.println(ind.toRDF(false, false));
                    continue;
                }
                this.println(value.toString());
            }
            this.println();
            this.println("Click 'Continue' to go to next process execution");
            this.execButton.setEnabled(true);
            while (this.execButton.isEnabled()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.println();
        }

        @Override
        public void executionFailed(ExecutionException e) {
            this.println();
            this.println("Execution failed: ");
            this.println(e.toString());
            e.printStackTrace();
        }
    }
}

