/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.ExampleURIs;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.mindswap.common.ClosableIterator;
import org.mindswap.common.DLMatch;
import org.mindswap.common.Variable;
import org.mindswap.exceptions.ParseException;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.service.Service;
import org.mindswap.query.QueryLanguage;
import org.mindswap.query.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matchmaker {
    private final OWLKnowledgeBase kb = OWLFactory.createKB();

    public Matchmaker() {
        this.kb.setReasoner("Pellet");
    }

    public void addOntology(URI ont) throws IOException {
        System.out.printf("Reading %s%n", ont);
        this.kb.read(ont);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ValueMap<Variable, OWLValue>> findServices(boolean getProducers) {
        String hasParameter = getProducers ? "process:hasOutput" : "process:hasInput";
        String queryString = "SELECT * WHERE \t   (?process rdf:type process:Process)\t   (?process " + hasParameter + " ?param)" + "USING " + "      process FOR <" + "http://www.daml.org/services/owl-s/1.2/Process.owl#" + ">";
        ArrayList<ValueMap<Variable, OWLValue>> services = new ArrayList<ValueMap<Variable, OWLValue>>();
        ClosableIterator<ValueMap<Variable, OWLValue>> results = null;
        try {
            results = this.kb.makeQuery(queryString, QueryLanguage.RDQL).execute(null);
            while (results.hasNext()) {
                services.add((ValueMap<Variable, OWLValue>)results.next());
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        return services;
    }

    private List<ValueMap<Variable, OWLValue>> findOutputs() {
        return this.findServices(true);
    }

    private List<ValueMap<Variable, OWLValue>> findInputs() {
        return this.findServices(false);
    }

    public DLMatch getMatchType(OWLType outputType, OWLType inputType) {
        if (outputType.isEquivalentTo(inputType)) {
            return DLMatch.EXACT;
        }
        if (outputType.isSubTypeOf(inputType)) {
            return DLMatch.SUBSUME;
        }
        if (inputType.isSubTypeOf(outputType)) {
            return DLMatch.PLUG_IN;
        }
        return DLMatch.FAIL;
    }

    public List<Match> computeMatches() {
        ArrayList<Match> matches = new ArrayList<Match>();
        System.out.println("Computing matches (" + this.kb.size() + " statements in KB) ...");
        List<ValueMap<Variable, OWLValue>> producers = this.findOutputs();
        List<ValueMap<Variable, OWLValue>> consumers = this.findInputs();
        for (ValueMap<Variable, OWLValue> producer : producers) {
            Output output = producer.getIndividualValue("param").castTo(Output.class);
            OWLType outputType = output.getParamType();
            for (ValueMap<Variable, OWLValue> consumer : consumers) {
                Input input = consumer.getIndividualValue("param").castTo(Input.class);
                OWLType inputType = input.getParamType();
                DLMatch matchType = this.getMatchType(outputType, inputType);
                if (DLMatch.FAIL.equals((Object)matchType)) continue;
                matches.add(new Match(matchType, output, input));
            }
        }
        return matches;
    }

    public static void printMatches(List<Match> matches) {
        if (matches.isEmpty()) {
            System.out.println("<EMPTY>");
        } else {
            for (Match match : matches) {
                System.out.println(match);
            }
        }
        System.out.println();
    }

    public static void main(String[] args) throws IOException {
        Matchmaker matchmaker = new Matchmaker();
        matchmaker.addOntology(ExampleURIs.AMAZON_BOOK_PRICE_OWLS12);
        matchmaker.addOntology(ExampleURIs.BN_BOOK_PRICE_OWLS12);
        matchmaker.addOntology(ExampleURIs.BOOK_FINDER_OWLS12);
        matchmaker.addOntology(ExampleURIs.CURRENCY_CONVERTER_OWLS12);
        matchmaker.addOntology(ExampleURIs.DICTIONARY_OWLS12);
        matchmaker.addOntology(ExampleURIs.ZIP_CODE_FINDER_OWLS12);
        matchmaker.addOntology(ExampleURIs.FIND_LAT_LONG_OWLS12);
        matchmaker.addOntology(ExampleURIs.BABELFISH_TRANSLATOR_OWLS12);
        long time = System.currentTimeMillis();
        List<Match> matches = matchmaker.computeMatches();
        System.out.printf("%nMatches (MATCHING_DEGREE Output -> Input):%n", new Object[0]);
        Matchmaker.printMatches(matches);
        System.out.printf("Computation of matches took %dms%n", System.currentTimeMillis() - time);
    }

    public static class Match {
        private final DLMatch matchType;
        boolean listMatch;
        private final Service outputService;
        private final Output output;
        private final Service inputService;
        private final Input input;

        public Match(DLMatch matchType, Output output, Input input) {
            this.matchType = matchType;
            this.outputService = output.getService();
            this.output = output;
            this.inputService = input.getService();
            this.input = input;
        }

        public String toString() {
            String str = "";
            str = str + (Object)((Object)this.matchType) + " ";
            if (this.listMatch) {
                str = str + ".LIST";
            }
            str = str + this.outputService.getLocalName() + "." + this.output.getLocalName();
            str = str + " -> ";
            str = str + this.inputService.getLocalName() + "." + this.input.getLocalName();
            return str;
        }
    }
}

