/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.ExampleURIs;
import impl.owl.WrappedIndividual;
import impl.owls.profile.ProfileImpl;
import org.mindswap.exceptions.CastingException;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;
import org.mindswap.owl.OWLObjectConverterRegistry;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.profile.ServiceParameter;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.FLAServiceOnt;
import org.mindswap.owls.vocabulary.OWLS_1_2;

public class OWLSExtensions {
    public static void main(String[] args) throws Exception {
        OWLSExtensions test = new OWLSExtensions();
        test.run();
    }

    public void run() throws Exception {
        OWLObjectConverterRegistry.instance().registerConverter(OwnerEntity.class, new OwnerConverter());
        OWLObjectConverterRegistry.instance().registerConverter(Profile.class, new ExtendedProfileConverter());
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.setReasoner("Pellet");
        Service s = kb.readService(ExampleURIs.DICTIONARY_OWLS12);
        ExtendedProfile profile = s.getProfile().castTo(ExtendedProfile.class);
        OwnerEntity owner = profile.getOwner();
        System.out.println("Service name: " + profile.getServiceName());
        System.out.println();
        System.out.println("Display service parameters using generic functions");
        System.out.println("--------------------------------------------------");
        OWLIndividualList<ServiceParameter> params = profile.getServiceParameters();
        for (ServiceParameter param : params) {
            System.out.println("Service Parameter: ");
            System.out.println("  Name  : " + param.getName());
            System.out.println("  Value : " + param.getParameter());
        }
        System.out.println();
        System.out.println("Display service parameters using custom functions");
        System.out.println("-------------------------------------------------");
        System.out.println("Owner: ");
        System.out.println("  Name : " + owner.getLabel(null));
        System.out.println("  ID   : " + owner.getEntityID());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtendedProfileConverter
    implements OWLObjectConverter<Profile> {
        @Override
        public boolean canCast(OWLObject object, boolean strictConversion) {
            return object instanceof OWLIndividual && ((OWLIndividual)object).isType(OWLS_1_2.Profile.Profile);
        }

        @Override
        public Profile cast(OWLObject object, boolean strictConversion) {
            if (this.canCast(object, strictConversion)) {
                return new ExtendedProfile((OWLIndividual)object);
            }
            throw CastingException.create(object, ExtendedProfile.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OwnerConverter
    implements OWLObjectConverter<OwnerEntity> {
        @Override
        public boolean canCast(OWLObject object, boolean strictConversion) {
            return object instanceof OWLIndividual && ((OWLIndividual)object).isType(FLAServiceOnt.OwnerEntity);
        }

        @Override
        public OwnerEntity cast(OWLObject object, boolean strictConversion) {
            if (this.canCast(object, strictConversion)) {
                return new OwnerEntity((OWLIndividual)object);
            }
            throw CastingException.create(object, OwnerEntity.class);
        }
    }

    public static class OwnerEntity
    extends WrappedIndividual {
        public OwnerEntity(OWLIndividual ind) {
            super(ind);
        }

        public String getEntityID() {
            return this.getPropertyAsString(FLAServiceOnt.ownerEntityID);
        }
    }

    public static class ExtendedProfile
    extends ProfileImpl {
        public ExtendedProfile(OWLIndividual ind) {
            super(ind);
        }

        public OwnerEntity getOwner() {
            OWLIndividual ind = this.getServiceParameterValue(FLAServiceOnt.ownedBy);
            return ind == null ? null : ind.castTo(OwnerEntity.class);
        }
    }
}

