/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.ExampleURIs;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.service.Service;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.ProcessUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreconditionUsage {
    public void run() throws Exception {
        long time = System.currentTimeMillis();
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.setReasoner("Pellet");
        Service service = kb.readService(ExampleURIs.BABELFISH_TRANSLATOR_OWLS12);
        Process process = service.getProcess();
        Input inLang = process.getInput("InputLanguage");
        Input outLang = process.getInput("OutputLanguage");
        OWLIndividual English = kb.getIndividual(URI.create("http://on.cs.unibas.ch/owl/2003/09/factbook/languages.rdf#English"));
        OWLIndividual Italian = kb.getIndividual(URI.create("http://on.cs.unibas.ch/owl/2003/09/factbook/languages.rdf#Italian"));
        OWLIndividual Russian = kb.getIndividual(URI.create("http://on.cs.unibas.ch/owl/2003/09/factbook/languages.rdf#Russian"));
        OWLIndividual German = kb.getIndividual(URI.create("http://on.cs.unibas.ch/owl/2003/09/factbook/languages.rdf#German"));
        ValueMap<Input, OWLIndividual> values = new ValueMap<Input, OWLIndividual>();
        System.out.println("Find all possible languages that can be used");
        System.out.println("------------------------------------------------");
        PreconditionUsage.printAllowedValues(process, values);
        System.out.println("Find languages that English can be translated to");
        System.out.println("------------------------------------------------");
        values.setValue(inLang, English);
        PreconditionUsage.printAllowedValues(process, values);
        System.out.println("Find languages that Italian can be translated to");
        System.out.println("------------------------------------------------");
        values.clear();
        values.setValue(inLang, Italian);
        PreconditionUsage.printAllowedValues(process, values);
        System.out.println("Find languages that can be translated from Russian");
        System.out.println("--------------------------------------------------");
        values.clear();
        values.setValue(outLang, Russian);
        PreconditionUsage.printAllowedValues(process, values);
        System.out.println("Find languages that can be translated from German");
        System.out.println("--------------------------------------------------");
        values.clear();
        values.setValue(outLang, German);
        PreconditionUsage.printAllowedValues(process, values);
        System.out.println("took " + (System.currentTimeMillis() - time) + "ms");
    }

    public static void printAllowedValues(Process process, ValueMap<Input, OWLIndividual> values) {
        System.out.println("Given Binding:");
        if (values.isEmpty()) {
            System.out.println("   <NONE>");
        } else {
            for (Input input : values.getVariables()) {
                OWLIndividual value = values.getIndividualValue(input);
                System.out.println("   " + input.getLocalName() + " = " + value.getLocalName());
            }
        }
        System.out.println("Allowed values:");
        Map<Input, Set<OWLValue>> allowedValues = ProcessUtils.getAllowedValues(process, values);
        for (Map.Entry<Input, Set<OWLValue>> entry : allowedValues.entrySet()) {
            Input input = entry.getKey();
            Set<OWLValue> set = entry.getValue();
            System.out.print("   " + input.getLocalName() + " = [");
            Iterator<OWLValue> j = set.iterator();
            while (j.hasNext()) {
                OWLIndividual value = (OWLIndividual)j.next();
                System.out.print(value.getLocalName());
                if (!j.hasNext()) continue;
                System.out.print(", ");
            }
            System.out.println("]");
        }
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        PreconditionUsage test = new PreconditionUsage();
        test.run();
    }
}

