/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.ExampleURIs;
import impl.owls.service.ServiceImpl;
import java.net.URI;
import org.mindswap.exceptions.CastingException;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;
import org.mindswap.owl.OWLObjectConverterRegistry;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.vocabulary.RDFS;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.WSDLGrounding;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.utils.URIUtils;

public class ServiceExtension {
    private static final String EXTENDED_SERVICE_CLASS_NAME = "ExtendedService";

    public static void main(String[] args) throws Exception {
        ServiceExtension test = new ServiceExtension();
        ExtendedServiceConverter converter = new ExtendedServiceConverter();
        OWLObjectConverterRegistry.instance().registerConverter(ExtendedService.class, converter);
        OWLObjectConverterRegistry.instance().extendByConverter(Service.class, converter);
        test.runRead();
        System.out.println("");
        test.runCreate();
    }

    public void runCreate() throws Exception {
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.setReasoner("Pellet");
        OWLOntology ont = kb.createOntology(ExampleURIs.SERVICE_EXTENSION_OWLS12);
        OWLClass ExtendedService2 = ont.createClass(URIUtils.createURI(ExampleURIs.SERVICE_EXTENSION_OWLS12, EXTENDED_SERVICE_CLASS_NAME));
        ExtendedService2.addProperty(RDFS.subClassOf, OWLS_1_2.Service.Service);
        URI serviceURI = URIUtils.createURI(ExampleURIs.SERVICE_EXTENSION_OWLS12, "TestService");
        OWLIndividual serviceInd = ont.createInstance(ExtendedService2, serviceURI);
        Service s = serviceInd.castTo(Service.class);
        ExtendedService service = s.castTo(ExtendedService.class);
        AtomicProcess process = ont.createAtomicProcess(URIUtils.createURI(ExampleURIs.SERVICE_EXTENSION_OWLS12, "TestProcess"));
        Profile profile = ont.createProfile(URIUtils.createURI(ExampleURIs.SERVICE_EXTENSION_OWLS12, "TestProfile"));
        WSDLGrounding grounding = ont.createWSDLGrounding(URIUtils.createURI(ExampleURIs.SERVICE_EXTENSION_OWLS12, "TestGrounding"));
        service.addProfile(profile);
        service.setProcess(process);
        service.addGrounding(grounding);
        service.setAdditionalProperty("test");
        System.out.println("Create extended service:");
        System.out.println("Service name: " + service.getLocalName());
        System.out.println("Profile name: " + service.getProfile().getLocalName());
        System.out.println("Process name: " + service.getProcess().getLocalName());
        System.out.println("Grounding name: " + service.getGrounding().getLocalName());
        System.out.println("additional property: " + service.getAdditionalProperty());
    }

    public void runRead() throws Exception {
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.setReasoner("Pellet");
        Service s = kb.readService(ExampleURIs.SERVICE_EXTENSION_OWLS12);
        ExtendedService service = s.castTo(ExtendedService.class);
        Profile profile = service.getProfile();
        Process process = service.getProcess();
        Grounding<?, ?> grounding = service.getGrounding();
        String additionalProperty = service.getAdditionalProperty();
        System.out.println("Read extended service:");
        System.out.println("Service name: " + service.getLocalName());
        System.out.println("Profile name: " + profile.getLocalName());
        System.out.println("Process name: " + process.getLocalName());
        System.out.println("Grounding name: " + grounding.getLocalName());
        System.out.println("additional property: " + additionalProperty);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtendedServiceConverter
    implements OWLObjectConverter<ExtendedService> {
        private static final OWLClass ExtendedService = OWLFactory.createKB().createClass(URIUtils.createURI(ExampleURIs.SERVICE_EXTENSION_OWLS12, "ExtendedService"));

        @Override
        public boolean canCast(OWLObject object, boolean strictConversion) {
            return object instanceof OWLIndividual && ((OWLIndividual)object).isType(ExtendedService);
        }

        @Override
        public ExtendedService cast(OWLObject object, boolean strictConversion) {
            if (this.canCast(object, strictConversion)) {
                return new ExtendedService((OWLIndividual)object);
            }
            throw CastingException.create(object, ExtendedService.class);
        }
    }

    public static class ExtendedService
    extends ServiceImpl {
        OWLDataProperty additionalProperty = this.getOntology().createDataProperty(URIUtils.createURI(ExampleURIs.SERVICE_EXTENSION_OWLS12, "additionalProperty"));

        public ExtendedService(OWLIndividual ind) {
            super(ind);
        }

        public String getAdditionalProperty() {
            return this.getPropertyAsString(this.additionalProperty);
        }

        public void setAdditionalProperty(String value) {
            this.setProperty(this.additionalProperty, value);
        }
    }
}

