/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;

public class Translator {
    public void translate(String fileURI, Writer out) throws Exception {
        URI uri = new URI(fileURI);
        OWLKnowledgeBase kb = OWLFactory.createKB();
        kb.setAutoTranslate(true);
        OWLOntology ont = kb.read(uri);
        ont.write(out, null);
    }

    public void run(String service) throws Exception {
        Translator translator = new Translator();
        translator.translate(service, new PrintWriter(System.out));
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            if (args.length < 1) {
                System.err.println("Not enough parameters");
            }
            if (args.length > 1) {
                System.err.println("Too many parameters");
            }
            System.err.println("usage: java Translator <serviceURI>");
            System.exit(0);
        }
        Translator translator = new Translator();
        translator.translate(args[0], new PrintWriter(System.out));
    }
}

