/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_GreaterThan;
import com.hp.hpl.jena.sparql.expr.E_GreaterThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_LessThan;
import com.hp.hpl.jena.sparql.expr.E_LessThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_NotEquals;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.lang.rdql.ParsedLiteral;
import com.hp.hpl.jena.sparql.lang.rdql.Q_Equal;
import com.hp.hpl.jena.sparql.lang.rdql.Q_GreaterThan;
import com.hp.hpl.jena.sparql.lang.rdql.Q_GreaterThanOrEqual;
import com.hp.hpl.jena.sparql.lang.rdql.Q_LessThan;
import com.hp.hpl.jena.sparql.lang.rdql.Q_LessThanOrEqual;
import com.hp.hpl.jena.sparql.lang.rdql.Q_NotEqual;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementVisitorBase;
import com.hp.hpl.jena.vocabulary.RDF;
import impl.jena.OWLDataValueImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mindswap.common.Parser;
import org.mindswap.common.Variable;
import org.mindswap.exceptions.NotImplementedException;
import org.mindswap.exceptions.ParseException;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.list.OWLList;
import org.mindswap.query.ABoxQuery;
import org.mindswap.query.QueryLanguage;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.SWRLDataObject;
import org.mindswap.swrl.SWRLDataVariable;
import org.mindswap.swrl.SWRLFactory;
import org.mindswap.swrl.SWRLIndividualObject;
import org.mindswap.swrl.SWRLIndividualVariable;
import org.mindswap.swrl.SWRLObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ABoxQueryParser
implements Parser<String, ABoxQuery<Variable>> {
    private static final String varNS = "var:";
    private final OWLModel model;
    private final QueryLanguage lang;

    public ABoxQueryParser(OWLModel model, QueryLanguage lang) {
        this.model = model;
        this.lang = lang;
    }

    @Override
    public ABoxQuery<Variable> parse(String queryString) throws ParseException {
        Query query;
        if (queryString == null) {
            throw new ParseException((Object)queryString, "Query string null.");
        }
        try {
            switch (this.lang) {
                case RDQL: {
                    query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxRDQL);
                    break;
                }
                default: {
                    query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxSPARQL);
                    break;
                }
            }
        }
        catch (QueryException e) {
            throw new ParseException((Object)queryString, (Throwable)e);
        }
        SWRLFactory.ISWRLFactory swrlFactory = SWRLFactory.createFactory(this.model);
        HashMap<String, Variable> vars = new HashMap<String, Variable>();
        Element elmnt = query.getQueryPattern();
        ElementVisitor v = new ElementVisitor(this.model, swrlFactory, vars);
        elmnt.visit((com.hp.hpl.jena.sparql.syntax.ElementVisitor)v);
        OWLList<Atom> atomList = v.getAtomList();
        ArrayList resultVars = new ArrayList();
        for (String var : query.getResultVars()) {
            resultVars.add(vars.get("?" + var));
        }
        return new ABoxQuery<Variable>(atomList, resultVars);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ElementVisitor
    extends ElementVisitorBase {
        private final OWLModel owlModel;
        private final SWRLFactory.ISWRLFactory swrlFactory;
        private final Map<String, Variable> vars;
        private OWLList<Atom> atoms;

        ElementVisitor(OWLModel model, SWRLFactory.ISWRLFactory swrlFactory, Map<String, Variable> vars) {
            this.owlModel = model;
            this.swrlFactory = swrlFactory;
            this.vars = vars;
            this.atoms = swrlFactory.createList();
        }

        OWLList<Atom> getAtomList() {
            return this.atoms;
        }

        public void visit(ElementTriplesBlock elementtriplesblock) {
            for (Triple t : elementtriplesblock.getPattern()) {
                try {
                    if (t.getPredicate().isVariable()) {
                        throw new IllegalArgumentException("Variables cannot be used in predicate position in ABoxQuery");
                    }
                    Atom atom = null;
                    String predURI = t.getPredicate().getURI();
                    if (RDF.type.getURI().equals(predURI)) {
                        if (t.getObject().isVariable()) {
                            throw new IllegalArgumentException("Variables cannot be used as objects of rdf:type triples in ABoxQuery");
                        }
                        OWLClass c = this.owlModel.createClass(new URI(t.getObject().getURI()));
                        SWRLIndividualObject arg = this.makeIndividalObject(t.getSubject());
                        atom = this.swrlFactory.createClassAtom(c, arg);
                    } else {
                        SWRLObject arg2;
                        SWRLIndividualObject arg1;
                        OWLProperty p = this.owlModel.getProperty(new URI(predURI));
                        if (p == null) {
                            throw new IllegalArgumentException(predURI + " is unknown [Object|Datatype]Property in the backing OWL model.");
                        }
                        if (p.isDatatypeProperty()) {
                            OWLDataProperty dp = this.owlModel.createDataProperty(p.getURI());
                            arg1 = this.makeIndividalObject(t.getSubject());
                            arg2 = this.makeDataObject(t.getObject());
                            atom = this.swrlFactory.createDataPropertyAtom(dp, arg1, (SWRLDataObject)arg2);
                        } else if (p.isObjectProperty()) {
                            OWLObjectProperty op = this.owlModel.createObjectProperty(p.getURI());
                            arg1 = this.makeIndividalObject(t.getSubject());
                            arg2 = this.makeIndividalObject(t.getObject());
                            atom = this.swrlFactory.createIndividualPropertyAtom(op, arg1, (SWRLIndividualObject)arg2);
                        }
                    }
                    if (atom == null) continue;
                    this.atoms = this.atoms.cons(atom);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e.getInput() + " appearing in the query string is not a valid URI!");
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void visit(ElementFilter elementfilter) {
            Expr expr = elementfilter.getExpr();
            try {
                BuiltinAtom atom;
                if (expr instanceof Expression) {
                    Expression e = (Expression)expr;
                    SWRLDataObject arg1 = this.makeDataObject(e.getArg(0));
                    SWRLDataObject arg2 = this.makeDataObject(e.getArg(1));
                    if (e instanceof Q_Equal) {
                        atom = this.swrlFactory.createEqual(arg1, arg2);
                    } else if (e instanceof Q_NotEqual) {
                        atom = this.swrlFactory.createNotEqual(arg1, arg2);
                    } else if (e instanceof Q_GreaterThan) {
                        atom = this.swrlFactory.createGreaterThan(arg1, arg2);
                    } else if (e instanceof Q_GreaterThanOrEqual) {
                        atom = this.swrlFactory.createGreaterThanOrEqual(arg1, arg2);
                    } else if (e instanceof Q_LessThan) {
                        atom = this.swrlFactory.createLessThan(arg1, arg2);
                    } else {
                        if (!(e instanceof Q_LessThanOrEqual)) throw new IllegalArgumentException("Unsupported constraint expression " + e + " used in RDQL query.");
                        atom = this.swrlFactory.createLessThanOrEqual(arg1, arg2);
                    }
                } else {
                    if (!expr.isFunction()) return;
                    ExprFunction f = (ExprFunction)expr;
                    SWRLDataObject arg1 = this.makeDataObject(f.getArg(0));
                    SWRLDataObject arg2 = this.makeDataObject(f.getArg(1));
                    if (f instanceof E_Equals) {
                        atom = this.swrlFactory.createEqual(arg1, arg2);
                    } else if (f instanceof E_NotEquals) {
                        atom = this.swrlFactory.createNotEqual(arg1, arg2);
                    } else if (f instanceof E_GreaterThan) {
                        atom = this.swrlFactory.createGreaterThan(arg1, arg2);
                    } else if (f instanceof E_GreaterThanOrEqual) {
                        atom = this.swrlFactory.createGreaterThanOrEqual(arg1, arg2);
                    } else if (f instanceof E_LessThan) {
                        atom = this.swrlFactory.createLessThan(arg1, arg2);
                    } else {
                        if (!(f instanceof E_LessThanOrEqual)) throw new IllegalArgumentException("Unsupported constraint (filter) " + f + " used in SPARQL query.");
                        atom = this.swrlFactory.createLessThanOrEqual(arg1, arg2);
                    }
                }
                this.atoms = this.atoms.cons(atom);
                return;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getInput() + " is not a valid URI!");
            }
        }

        public void visit(ElementGroup elementgroup) {
            for (Element e : elementgroup.getElements()) {
                e.visit((com.hp.hpl.jena.sparql.syntax.ElementVisitor)this);
            }
        }

        private SWRLDataObject makeDataObject(Expr expr) throws URISyntaxException {
            if (expr.isVariable()) {
                return this.swrlFactory.createDataVariable(new URI(ABoxQueryParser.varNS + expr.getVarName()));
            }
            if (expr.isConstant()) {
                OWLDataValue value;
                NodeValue nv = (NodeValue)expr;
                if (nv.isInteger()) {
                    value = this.owlModel.createDataValue(nv.getInteger());
                } else if (nv.isDouble()) {
                    value = this.owlModel.createDataValue(nv.getDouble());
                } else if (nv.isFloat()) {
                    value = this.owlModel.createDataValue(Float.valueOf(nv.getFloat()));
                } else if (nv.isBoolean()) {
                    value = this.owlModel.createDataValue(nv.getBoolean());
                } else if (nv.isString()) {
                    value = this.owlModel.createDataValue(nv.getString());
                } else if (nv.isDecimal()) {
                    value = this.owlModel.createDataValue(nv.getDecimal());
                } else if (nv.hasDateTime()) {
                    value = this.owlModel.createDataValue(nv.getDateTime());
                } else {
                    throw new NotImplementedException();
                }
                return this.swrlFactory.wrapDataValue(value);
            }
            throw new IllegalArgumentException("Nested constraint (filter) near " + expr + " can not be transformed to SWRL atom.");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private SWRLDataObject makeDataObject(Expression expr) throws URISyntaxException {
            if (expr.isVariable()) {
                return this.swrlFactory.createDataVariable(new URI(ABoxQueryParser.varNS + expr.getName()));
            }
            if (!expr.isConstant()) throw new IllegalArgumentException("Nested constraint expressions near " + expr + " can not be transformed to SWRL atom.");
            OWLDataValue value = null;
            if (expr instanceof ParsedLiteral) {
                ParsedLiteral lit = (ParsedLiteral)expr;
                if (lit.isInt()) {
                    value = this.owlModel.createDataValue(lit.getInt());
                    return this.swrlFactory.wrapDataValue(value);
                } else if (lit.isDouble()) {
                    value = this.owlModel.createDataValue(lit.getDouble());
                    return this.swrlFactory.wrapDataValue(value);
                } else if (lit.isBoolean()) {
                    value = this.owlModel.createDataValue(lit.getBoolean());
                    return this.swrlFactory.wrapDataValue(value);
                } else if (lit.isString()) {
                    value = this.owlModel.createDataValue(lit.getString());
                    return this.swrlFactory.wrapDataValue(value);
                } else {
                    if (!lit.isURI()) throw new NotImplementedException();
                    value = this.owlModel.createDataValue(URI.create(lit.getURI()));
                }
                return this.swrlFactory.wrapDataValue(value);
            } else {
                value = this.owlModel.createDataValue(expr.getValue());
            }
            return this.swrlFactory.wrapDataValue(value);
        }

        private SWRLDataObject makeDataObject(Node node) throws URISyntaxException {
            if (node.isVariable()) {
                SWRLDataVariable var = this.swrlFactory.createDataVariable(new URI(ABoxQueryParser.varNS + node.getName()));
                this.vars.put(node.toString(), var);
                return var;
            }
            OWLDataValueImpl value = new OWLDataValueImpl((Literal)new LiteralImpl(node, (EnhGraph)this.owlModel.getImplementation()));
            return this.swrlFactory.wrapDataValue(value);
        }

        private SWRLIndividualObject makeIndividalObject(Node node) throws URISyntaxException {
            if (node.isVariable()) {
                SWRLIndividualVariable var = this.swrlFactory.createIndividualVariable(new URI(ABoxQueryParser.varNS + node.getName()));
                this.vars.put(node.toString(), var);
                return var;
            }
            OWLIndividual ind = this.owlModel.createIndividual(null, new URI(node.getURI()));
            return this.swrlFactory.wrapIndividual(ind);
        }
    }
}

