/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMiniReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.LocationMapper;
import impl.jena.ABoxQueryParser;
import impl.jena.OWLConverters;
import impl.jena.OWLKnowledgeBaseImpl;
import impl.jena.OWLKnowledgeBaseManagerImpl;
import impl.owl.CastingList;
import impl.owl.OWLIndividualListImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mindswap.common.Parser;
import org.mindswap.common.Variable;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBaseManager;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLObjectConverterRegistry;
import org.mindswap.owl.OWLProvider;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.query.ABoxQuery;
import org.mindswap.query.QueryLanguage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenaOWLProvider
implements OWLProvider {
    private static final Logger logger = LoggerFactory.getLogger(JenaOWLProvider.class);
    private static final OWLIndividualListImpl<OWLIndividual> EMPTY_LIST = new OWLIndividualListImpl(Collections.emptyList());

    static final Reasoner createReasoner(String reasonerName) {
        if (Reasoners.Pellet.name().equals(reasonerName)) {
            PelletOptions.USE_CLASSIFICATION_MONITOR = PelletOptions.MonitorType.NONE;
            return PelletReasonerFactory.theInstance().create();
        }
        if (Reasoners.OWL.name().equals(reasonerName)) {
            return OWLFBRuleReasonerFactory.theInstance().create(null);
        }
        if (Reasoners.OWLMini.name().equals(reasonerName)) {
            return OWLMiniReasonerFactory.theInstance().create(null);
        }
        if (Reasoners.OWLMicro.name().equals(reasonerName)) {
            return OWLMicroReasonerFactory.theInstance().create(null);
        }
        if (Reasoners.RDFS.name().equals(reasonerName)) {
            return RDFSRuleReasonerFactory.theInstance().create(null);
        }
        if (Reasoners.Transitive.name().equals(reasonerName)) {
            return TransitiveReasonerFactory.theInstance().create(null);
        }
        return null;
    }

    @Override
    public List<String> getReasonerNames() {
        ArrayList<String> reasoners = new ArrayList<String>();
        for (Reasoners r : Reasoners.values()) {
            reasoners.add(r.name());
        }
        return reasoners;
    }

    @Override
    public OWLKnowledgeBaseImpl createKB() {
        OntModelSpec spec = JenaOWLProvider.createOntSpec(null);
        return new OWLKnowledgeBaseImpl(new OWLKnowledgeBaseManagerImpl(spec));
    }

    @Override
    public OWLKnowledgeBaseImpl createKB(OWLKnowledgeBaseManager manager) {
        if (manager != null) {
            if (manager instanceof OWLKnowledgeBaseManagerImpl) {
                return new OWLKnowledgeBaseImpl((OWLKnowledgeBaseManagerImpl)manager);
            }
            logger.debug("Instance of {} expected, actual type {}. Will use default KB manager instead.", OWLKnowledgeBaseManagerImpl.class, manager.getClass());
        }
        return this.createKB();
    }

    @Override
    public OWLKnowledgeBaseManager createKBManager() {
        FileManager fm = new FileManager(new LocationMapper(LocationMapper.get()));
        FileManager.setStdLocators((FileManager)fm);
        OntDocumentManager odm = new OntDocumentManager(fm, "file:ont-policy.rdf;file:etc/ont-policy.rdf");
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM.getBaseModelMaker(), OntModelSpec.OWL_DL_MEM.getImportModelMaker(), odm, null, OntModelSpec.OWL_DL_MEM.getLanguage());
        return new OWLKnowledgeBaseManagerImpl(spec);
    }

    public <T extends OWLIndividual> OWLIndividualListImpl<T> createIndividualList() {
        return new OWLIndividualListImpl();
    }

    public <T extends OWLIndividual> OWLIndividualListImpl<T> createIndividualList(int capacity) {
        return new OWLIndividualListImpl(capacity);
    }

    @Override
    public Parser<String, ABoxQuery<Variable>> createABoxQueryParser(OWLModel model, QueryLanguage lang) {
        return new ABoxQueryParser(model, lang);
    }

    public <T extends OWLIndividual> OWLIndividualListImpl<T> castList(List<? extends OWLIndividual> list, Class<T> castTarget) {
        assert (list != null && castTarget != null) : "Illegal: list and/or cast target parameter was null.";
        OWLIndividualList result = this.createIndividualList();
        for (OWLIndividual oWLIndividual : list) {
            OWLIndividual element = (OWLIndividual)oWLIndividual.castTo(castTarget);
            ((OWLIndividualListImpl)result).add(element);
        }
        return result;
    }

    @Override
    public <T extends OWLIndividual> CastingList<T> wrapList(List<? extends OWLIndividual> list, Class<T> castTarget) {
        return new CastingList<T>(list, castTarget);
    }

    public <T extends OWLIndividual> OWLIndividualListImpl<T> emptyIndividualList() {
        return EMPTY_LIST;
    }

    public <T extends OWLIndividual> OWLIndividualListImpl<T> unmodifiableIndividualList(List<T> list) {
        return new OWLIndividualListImpl<T>(Collections.unmodifiableList(list));
    }

    @Override
    public void registerConverters(OWLObjectConverterRegistry registry) {
        OWLConverters.registerConverters(registry);
    }

    static OntModelSpec createOntSpec(OntModelSpec source) {
        if (source == null) {
            return new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        }
        OntModelSpec spec = new OntModelSpec(source);
        spec.setReasoner(null);
        spec.setReasonerFactory(null);
        return spec;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Reasoners {
        Pellet,
        OWL,
        OWLMini,
        OWLMicro,
        RDFS,
        Transitive;

    }
}

