/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.rdf.model.Resource;
import impl.jena.OWLAnnotationPropertyImpl;
import impl.jena.OWLClassImpl;
import impl.jena.OWLDataPropertyImpl;
import impl.jena.OWLEntityImpl;
import impl.jena.OWLIndividualImpl;
import impl.jena.OWLObjectPropertyImpl;
import impl.owl.CombinedOWLConverter;
import java.net.URI;
import java.util.ArrayList;
import org.mindswap.exceptions.CastingException;
import org.mindswap.owl.OWLAnnotationProperty;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataType;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;
import org.mindswap.owl.OWLObjectConverterRegistry;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLType;

class OWLConverters {
    OWLConverters() {
    }

    static final void registerConverters(OWLObjectConverterRegistry registry) {
        AnnotationPropertyConverter annPropConverter = new AnnotationPropertyConverter();
        ObjectPropertyConverter objPropConverter = new ObjectPropertyConverter();
        DataPropertyConverter dataPropConverter = new DataPropertyConverter();
        ArrayList pCs = new ArrayList(3);
        pCs.add(objPropConverter);
        pCs.add(dataPropConverter);
        pCs.add(annPropConverter);
        CombinedOWLConverter propConverter = new CombinedOWLConverter(OWLProperty.class, pCs);
        ClassConverter classConverter = new ClassConverter();
        DataTypeConverter dataTypeConverter = new DataTypeConverter();
        ArrayList tCs = new ArrayList(2);
        tCs.add(classConverter);
        tCs.add(dataTypeConverter);
        CombinedOWLConverter typeConverter = new CombinedOWLConverter(OWLType.class, tCs);
        IndividualConverter indConverter = new IndividualConverter();
        ArrayList eCs = new ArrayList(5);
        eCs.add(classConverter);
        eCs.add(objPropConverter);
        eCs.add(dataPropConverter);
        eCs.add(indConverter);
        eCs.add(annPropConverter);
        CombinedOWLConverter entityConverter = new CombinedOWLConverter(OWLEntity.class, eCs);
        registry.registerConverter(OWLIndividual.class, indConverter);
        registry.registerConverter(OWLAnnotationProperty.class, annPropConverter);
        registry.registerConverter(OWLObjectProperty.class, objPropConverter);
        registry.registerConverter(OWLDataProperty.class, dataPropConverter);
        registry.registerConverter(OWLProperty.class, propConverter);
        registry.registerConverter(OWLClass.class, classConverter);
        registry.registerConverter(OWLDataType.class, dataTypeConverter);
        registry.registerConverter(OWLType.class, typeConverter);
        registry.registerConverter(OWLEntity.class, entityConverter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DataTypeConverter
    implements OWLObjectConverter<OWLDataType> {
        DataTypeConverter() {
        }

        @Override
        public boolean canCast(OWLObject object, boolean strictConversion) {
            if (object instanceof OWLDataType) {
                return true;
            }
            if (object instanceof OWLEntity) {
                OWLEntity entity = (OWLEntity)object;
                return entity.getKB().getDataType(entity.getURI()) != null;
            }
            return false;
        }

        @Override
        public OWLDataType cast(OWLObject object, boolean strictConversion) {
            if (object instanceof OWLDataType) {
                return (OWLDataType)object;
            }
            if (this.canCast(object, strictConversion)) {
                OWLEntity entity = (OWLEntity)object;
                URI uri = entity.getURI();
                return entity.getKB().getDataType(uri);
            }
            throw CastingException.create(object, OWLDataType.class);
        }

        public String toString() {
            return "Converter " + OWLEntity.class.getSimpleName() + " -> " + OWLDataType.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IndividualConverter
    implements OWLObjectConverter<OWLIndividual> {
        IndividualConverter() {
        }

        @Override
        public boolean canCast(OWLObject object, boolean strictConversion) {
            return object instanceof OWLEntityImpl;
        }

        @Override
        public OWLIndividual cast(OWLObject object, boolean strictConversion) {
            if (object instanceof OWLIndividual) {
                return (OWLIndividual)object;
            }
            if (this.canCast(object, strictConversion)) {
                OWLEntityImpl entity = (OWLEntityImpl)object;
                Object res = entity.getImplementation();
                return new OWLIndividualImpl(entity.getOntology(), (Resource)res);
            }
            throw CastingException.create(object, OWLIndividual.class);
        }

        public String toString() {
            return "Converter " + OWLEntity.class.getSimpleName() + " -> " + OWLIndividual.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ClassConverter
    implements OWLObjectConverter<OWLClass> {
        ClassConverter() {
        }

        @Override
        public boolean canCast(OWLObject object, boolean strictConversion) {
            if (object instanceof OWLClass) {
                return true;
            }
            if (object instanceof OWLEntityImpl) {
                OWLEntityImpl entity = (OWLEntityImpl)object;
                Object res = entity.getImplementation();
                return !strictConversion || res.canAs(OntClass.class);
            }
            return false;
        }

        @Override
        public OWLClass cast(OWLObject object, boolean strictConversion) {
            if (object instanceof OWLClass) {
                return (OWLClass)object;
            }
            if (this.canCast(object, strictConversion)) {
                OWLEntityImpl entity = (OWLEntityImpl)object;
                Object res = entity.getImplementation();
                OntClass c = (OntClass)res.as(OntClass.class);
                return new OWLClassImpl(entity.getOntology(), c);
            }
            throw CastingException.create(object, OWLClass.class);
        }

        public String toString() {
            return "Converter " + OWLEntity.class.getSimpleName() + " -> " + OWLClass.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DataPropertyConverter
    implements OWLObjectConverter<OWLDataProperty> {
        DataPropertyConverter() {
        }

        @Override
        public boolean canCast(OWLObject object, boolean strictConversion) {
            if (object instanceof OWLDataProperty) {
                return true;
            }
            if (object instanceof OWLEntityImpl) {
                OWLEntityImpl entity = (OWLEntityImpl)object;
                Object res = entity.getImplementation();
                return !strictConversion || res.canAs(DatatypeProperty.class);
            }
            return false;
        }

        @Override
        public OWLDataProperty cast(OWLObject object, boolean strictConversion) {
            if (object instanceof OWLDataProperty) {
                return (OWLDataProperty)object;
            }
            if (this.canCast(object, strictConversion)) {
                OWLEntityImpl entity = (OWLEntityImpl)object;
                Object res = entity.getImplementation();
                DatatypeProperty prop = (DatatypeProperty)res.as(DatatypeProperty.class);
                return new OWLDataPropertyImpl(entity.getOntology(), prop);
            }
            throw CastingException.create(object, OWLDataProperty.class);
        }

        public String toString() {
            return "Converter " + OWLEntity.class.getSimpleName() + " -> " + OWLDataProperty.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ObjectPropertyConverter
    implements OWLObjectConverter<OWLObjectProperty> {
        ObjectPropertyConverter() {
        }

        @Override
        public boolean canCast(OWLObject object, boolean strictConversion) {
            if (object instanceof OWLObjectProperty) {
                return true;
            }
            if (object instanceof OWLEntityImpl) {
                OWLEntityImpl entity = (OWLEntityImpl)object;
                Object res = entity.getImplementation();
                return !strictConversion || res.canAs(ObjectProperty.class);
            }
            return false;
        }

        @Override
        public OWLObjectProperty cast(OWLObject object, boolean strictConversion) {
            if (object instanceof OWLObjectProperty) {
                return (OWLObjectProperty)object;
            }
            if (this.canCast(object, strictConversion)) {
                OWLEntityImpl entity = (OWLEntityImpl)object;
                Object res = entity.getImplementation();
                ObjectProperty prop = (ObjectProperty)res.as(ObjectProperty.class);
                return new OWLObjectPropertyImpl(entity.getOntology(), prop);
            }
            throw CastingException.create(object, OWLObjectProperty.class);
        }

        public String toString() {
            return "Converter " + OWLEntity.class.getSimpleName() + " -> " + OWLObjectProperty.class.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class AnnotationPropertyConverter
    implements OWLObjectConverter<OWLAnnotationProperty> {
        AnnotationPropertyConverter() {
        }

        @Override
        public boolean canCast(OWLObject source, boolean strictConversion) {
            if (source instanceof OWLAnnotationProperty) {
                return true;
            }
            if (source instanceof OWLEntityImpl) {
                OWLEntityImpl entity = (OWLEntityImpl)source;
                Object res = entity.getImplementation();
                return !strictConversion || res.canAs(AnnotationProperty.class);
            }
            return false;
        }

        @Override
        public OWLAnnotationProperty cast(OWLObject source, boolean strictConversion) {
            if (source instanceof OWLAnnotationProperty) {
                return (OWLAnnotationProperty)source;
            }
            if (this.canCast(source, strictConversion)) {
                OWLEntityImpl entity = (OWLEntityImpl)source;
                Object res = entity.getImplementation();
                AnnotationProperty prop = (AnnotationProperty)res.as(AnnotationProperty.class);
                return new OWLAnnotationPropertyImpl(entity.getOntology(), prop);
            }
            throw CastingException.create(source, OWLAnnotationProperty.class);
        }

        public String toString() {
            return "Converter " + OWLEntity.class.getSimpleName() + " -> " + OWLAnnotationProperty.class.getSimpleName();
        }
    }
}

