/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import impl.owl.OWLObjectImpl;
import java.net.URI;
import org.mindswap.owl.OWLDataType;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLType;
import org.mindswap.utils.URIUtils;

public class OWLDataTypeImpl
extends OWLObjectImpl
implements OWLDataType {
    private final OWLKnowledgeBase kb;
    private final RDFDatatype datatype;
    private final URI datatypeURI;

    public OWLDataTypeImpl(OWLKnowledgeBase kb, RDFDatatype datatype) {
        if (datatype == null) {
            throw new IllegalArgumentException("RDF datatype is null");
        }
        this.datatype = datatype;
        this.datatypeURI = URIUtils.createURI(datatype.getURI());
        this.kb = kb;
    }

    public RDFDatatype getImplementation() {
        return this.datatype;
    }

    public final boolean isDataType() {
        return true;
    }

    public final boolean isClass() {
        return false;
    }

    public URI getURI() {
        return this.datatypeURI;
    }

    public boolean equals(Object object) {
        if (object instanceof OWLDataTypeImpl) {
            return this.datatype.equals(((OWLDataTypeImpl)object).datatype);
        }
        return false;
    }

    public int hashCode() {
        return this.datatype.hashCode();
    }

    public boolean isDisjointWith(OWLType type) {
        return this.kb.isDisjoint(this, type);
    }

    public boolean isSubTypeOf(OWLType type) {
        return this.kb.isSubTypeOf(this, type);
    }

    public boolean isEquivalentTo(OWLType type) {
        return this.kb.isEquivalent(this, type);
    }

    public String toString() {
        return this.datatype.toString();
    }

    public boolean isValid(String lexicalForm) {
        if (this.datatype != null) {
            return this.datatype.isValid(lexicalForm);
        }
        throw new UnsupportedOperationException("Datatype without validation support.");
    }

    public boolean isValidValue(Object valueForm) {
        if (this.datatype != null) {
            return this.datatype.isValidValue(valueForm);
        }
        throw new UnsupportedOperationException("Datatype without validation support.");
    }

    public Object parse(String lexicalForm) {
        try {
            if (this.datatype != null) {
                return this.datatype.parse(lexicalForm);
            }
            throw new UnsupportedOperationException("Datatype without parse support.");
        }
        catch (DatatypeFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String unparse(Object value) {
        if (this.datatype != null) {
            return this.datatype.unparse(value);
        }
        throw new UnsupportedOperationException("Datatype without parse support.");
    }
}

