/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.vocabulary.RDFS;
import impl.jena.OWLDataValueImpl;
import impl.jena.OWLIndividualImpl;
import impl.jena.OWLKnowledgeBaseImpl;
import impl.jena.OWLOntologyImpl;
import impl.owl.OWLIndividualListImpl;
import impl.owl.OWLObjectImpl;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.utils.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLEntityImpl<R extends Resource>
extends OWLObjectImpl
implements OWLEntity {
    protected final R resource;
    protected final OWLOntologyImpl ontology;

    public OWLEntityImpl(OWLOntologyImpl ontology, R resource) {
        this.resource = resource;
        this.ontology = ontology;
    }

    @Override
    public OWLKnowledgeBaseImpl getKB() {
        return this.ontology.getKB();
    }

    @Override
    public OWLOntologyImpl getOntology() {
        return this.ontology;
    }

    @Override
    public boolean isAnon() {
        return this.resource.isAnon();
    }

    @Override
    public URI getURI() {
        return this.resource.isAnon() ? null : URI.create(this.resource.getURI());
    }

    @Override
    public String getLocalName() {
        return this.resource.isAnon() ? null : URIUtils.getLocalName(this.resource.getURI());
    }

    @Override
    public String getQName() {
        return this.resource.isAnon() ? null : this.getKB().getQNames().shortForm(this.resource.getURI());
    }

    @Override
    public String getNamespace() {
        return this.resource.getNameSpace();
    }

    @Override
    public String getLabel(String lang) {
        Literal value = this.getDataValue(RDFS.label, lang);
        return value == null ? null : value.getLexicalForm();
    }

    @Override
    public List<String> getLabels() {
        return this.getLiterals(RDFS.label);
    }

    @Override
    public void setLabel(String label, String lang) {
        this.removeDataValues(RDFS.label, lang);
        this.ontology.ontModel.add(this.resource, RDFS.label, label, lang);
    }

    @Override
    public List<OWLDataValue> getPropertiesAsDataValue(URI propURI) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        return this.getDataValues(prop);
    }

    @Override
    public OWLIndividualList<?> getPropertiesAsIndividual(URI propURI) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        return this.getIndividuals(prop);
    }

    @Override
    public OWLDataValue getPropertyAsDataValue(URI propURI, String lang) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        Literal lit = this.getDataValue(prop, lang);
        return lit == null ? null : new OWLDataValueImpl(lit);
    }

    @Override
    public OWLIndividual getPropertyAsIndividual(URI propURI) {
        RDFNode n;
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        Statement s = this.ontology.getKB().ontModel.getProperty(this.resource, prop);
        if (s != null && (n = s.getObject()).isResource()) {
            return new OWLIndividualImpl(this.ontology, (Resource)n.as(Resource.class));
        }
        return null;
    }

    @Override
    public void addProperty(URI propURI, OWLDataValue value) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        this.ontology.ontModel.add(this.resource, prop, (RDFNode)value.getImplementation());
    }

    @Override
    public void addProperty(URI propURI, OWLEntity value) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        this.ontology.ontModel.add(this.resource, prop, (RDFNode)value.getImplementation());
    }

    @Override
    public void addProperty(URI propURI, String value, String lang) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        this.ontology.ontModel.add(this.resource, prop, value, lang);
    }

    @Override
    public void setProperty(URI propURI, OWLDataValue value) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        this.removeDataValues(prop, value.getLanguage());
        this.ontology.ontModel.add(this.resource, prop, (RDFNode)value.getImplementation());
    }

    @Override
    public void setProperty(URI propURI, OWLEntity value) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        this.ontology.getKB().removeAll((Resource)this.resource, prop, null);
        this.ontology.ontModel.add(this.resource, prop, (RDFNode)value.getImplementation());
    }

    @Override
    public void setProperty(URI propURI, String value, String lang) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        this.removeDataValues(prop, lang);
        this.ontology.ontModel.add(this.resource, prop, value, lang);
    }

    protected List<String> getLiterals(Property prop) {
        ArrayList<String> list = new ArrayList<String>();
        NodeIterator it = this.ontology.getKB().ontModel.listObjectsOfProperty(this.resource, prop);
        while (it.hasNext()) {
            RDFNode node = it.next();
            if (!node.isLiteral()) continue;
            list.add(((Literal)node.as(Literal.class)).getString());
        }
        it.close();
        return list;
    }

    protected List<OWLDataValue> getDataValues(Property prop) {
        ArrayList<OWLDataValue> list = new ArrayList<OWLDataValue>();
        NodeIterator it = this.ontology.getKB().ontModel.listObjectsOfProperty(this.resource, prop);
        while (it.hasNext()) {
            RDFNode node = it.next();
            if (!node.isLiteral()) continue;
            list.add(new OWLDataValueImpl((Literal)node.as(Literal.class)));
        }
        it.close();
        return list;
    }

    protected OWLIndividualList<?> getIndividuals(Property prop) {
        OWLIndividualListImpl<OWLIndividualImpl> list = new OWLIndividualListImpl<OWLIndividualImpl>();
        NodeIterator it = this.ontology.getKB().ontModel.listObjectsOfProperty(this.resource, prop);
        while (it.hasNext()) {
            RDFNode node = it.next();
            if (!node.isResource()) continue;
            list.add(new OWLIndividualImpl(this.ontology, (Resource)node.as(Resource.class)));
        }
        it.close();
        return list;
    }

    protected Literal getDataValue(Property prop, String lang) {
        Literal found = null;
        NodeIterator it = this.ontology.getKB().ontModel.listObjectsOfProperty(this.resource, prop);
        while (it.hasNext()) {
            RDFNode node = it.next();
            if (!node.isLiteral()) continue;
            Literal l = (Literal)node.as(Literal.class);
            String lLang = l.getLanguage();
            if (lang == null || lang.equalsIgnoreCase(lLang)) {
                found = l;
                break;
            }
            if (lLang != null && lLang.length() > 1 && lang.equalsIgnoreCase(lLang.substring(0, 2))) {
                found = l;
                continue;
            }
            if (found != null || lLang != null) continue;
            found = l;
        }
        it.close();
        return found;
    }

    protected void removeDataValues(Property prop, String lang) {
        if (lang == null) {
            this.ontology.getKB().removeAll((Resource)this.resource, prop, null);
        } else {
            StmtIterator it = this.ontology.getKB().ontModel.listStatements(this.resource, prop, null, lang);
            while (it.hasNext()) {
                this.ontology.getKB().removeAll((Resource)this.resource, prop, ((Statement)it.next()).getObject());
            }
            it.close();
        }
    }

    @Override
    public String toString() {
        return this.resource.isAnon() ? "Anonymous (" + this.resource.getId() + ")" : this.resource.getURI();
    }

    @Override
    public String toPrettyString() {
        String value = this.getLabel(null);
        if (value == null) {
            value = this.isAnon() ? "Anonymous (" + this.resource.getId() + ")" : this.ontology.getKB().getQNames().shortForm(this.resource.getURI());
        }
        return value;
    }

    @Override
    public void removeProperties(URI propURI) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        this.ontology.getKB().removeAll((Resource)this.resource, prop, null);
    }

    public R getImplementation() {
        return this.resource;
    }

    @Override
    public String getAnonID() {
        if (this.isAnon()) {
            return this.resource.getId().getLabelString();
        }
        return null;
    }

    @Override
    public OWLEntityImpl<?> rename(URI newURI) {
        String newURIasString;
        String string = newURIasString = newURI == null ? null : newURI.toString();
        if (this.isAnon() && newURIasString == null || newURIasString != null && newURIasString.equals(this.resource.getURI())) {
            return this;
        }
        Node resourceN = this.resource.asNode();
        Model m = this.resource.getModel();
        Graph g = m.getGraph();
        Graph rawGraph = g instanceof InfGraph ? ((InfGraph)g).getRawGraph() : g;
        final HashSet reflexiveTriples = new HashSet();
        ExtendedIterator i = rawGraph.find(resourceN, null, null);
        i = i.andThen((Iterator)rawGraph.find(null, null, resourceN)).filterKeep((Filter)new Filter<Triple>(){

            public boolean accept(Triple o) {
                if (o.getSubject().equals((Object)o.getObject())) {
                    reflexiveTriples.add(o);
                    return false;
                }
                return true;
            }
        });
        Resource newRes = newURIasString == null ? m.createResource() : m.createResource(newURIasString);
        Node newResN = newRes.asNode();
        while (i.hasNext()) {
            Triple t = (Triple)i.next();
            Node subj = t.getSubject().equals((Object)resourceN) ? newResN : t.getSubject();
            Node obj = t.getObject().equals((Object)resourceN) ? newResN : t.getObject();
            rawGraph.add(Triple.create((Node)subj, (Node)t.getPredicate(), (Node)obj));
            i.remove();
        }
        for (Triple rt : reflexiveTriples) {
            rawGraph.delete(rt);
            rawGraph.add(Triple.create((Node)newResN, (Node)rt.getPredicate(), (Node)newResN));
        }
        if (rawGraph != g) {
            ((InfGraph)g).rebind();
        }
        return this.wrap(newRes);
    }

    protected abstract OWLEntityImpl<R> wrap(Resource var1);
}

