/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelExtract;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StatementBoundary;
import com.hp.hpl.jena.rdf.model.StatementBoundaryBase;
import com.hp.hpl.jena.vocabulary.OWL;
import impl.jena.OWLEntityImpl;
import impl.jena.OWLOntologyImpl;
import impl.jena.OWLWriterImpl;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLValue;
import org.mindswap.utils.RDFUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLIndividualImpl
extends OWLEntityImpl<Resource>
implements OWLIndividual {
    public OWLIndividualImpl(OWLOntologyImpl ontology, Resource resource) {
        super(ontology, resource);
    }

    @Override
    public boolean hasProperty(OWLProperty prop) {
        return this.ontology.getKB().contains(this, prop, null);
    }

    @Override
    public OWLIndividual getProperty(OWLObjectProperty prop) {
        return this.ontology.getKB().getProperty((OWLIndividual)this, prop);
    }

    @Override
    public OWLIndividualList<?> getProperties(OWLObjectProperty prop) {
        return this.ontology.getKB().getProperties((OWLIndividual)this, prop);
    }

    @Override
    public Map<OWLProperty, List<OWLValue>> getProperties() {
        return this.ontology.getKB().getProperties(this);
    }

    @Override
    public OWLDataValue getProperty(OWLDataProperty prop) {
        return this.ontology.getKB().getProperty((OWLIndividual)this, prop);
    }

    @Override
    public OWLDataValue getProperty(OWLDataProperty prop, String lang) {
        return this.ontology.getKB().getProperty(this, prop, lang);
    }

    @Override
    public List<OWLDataValue> getProperties(OWLDataProperty prop) {
        return this.ontology.getKB().getProperties((OWLIndividual)this, prop);
    }

    @Override
    public OWLIndividual getIncomingProperty(OWLObjectProperty prop) {
        return this.ontology.getKB().getIncomingProperty(prop, this);
    }

    @Override
    public OWLIndividualList<?> getIncomingProperties(OWLObjectProperty prop) {
        return this.ontology.getKB().getIncomingProperties(prop, this);
    }

    @Override
    public OWLIndividualList<?> getIncomingProperties() {
        return this.ontology.getKB().getIncomingProperties(this);
    }

    @Override
    public void setProperty(OWLDataProperty prop, String value) {
        this.ontology.getKB().removeProperty(this, prop, null);
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public void setProperty(OWLDataProperty prop, Object value) {
        this.ontology.getKB().removeProperty(this, prop, null);
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public void setProperty(OWLDataProperty prop, OWLDataValue value) {
        this.ontology.getKB().removeProperty(this, prop, null);
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public void addProperty(OWLDataProperty prop, OWLDataValue value) {
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public void addProperty(OWLDataProperty prop, String value) {
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public void addProperty(OWLDataProperty prop, Object value) {
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public void removeProperty(OWLProperty theProp, OWLValue theValue) {
        this.ontology.getKB().removeProperty(this, theProp, theValue);
    }

    @Override
    public void addProperty(OWLObjectProperty prop, OWLIndividual value) {
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public void setProperty(OWLObjectProperty prop, OWLIndividual value) {
        this.ontology.getKB().removeProperty(this, prop, null);
        this.ontology.addProperty((OWLIndividual)this, prop, value);
    }

    @Override
    public Set<OWLClass> getTypes() {
        return this.ontology.getKB().getTypes(this);
    }

    @Override
    public boolean hasProperty(OWLProperty prop, OWLValue value) {
        return this.ontology.getKB().contains(this, prop, value);
    }

    @Override
    public OWLClass getType() {
        return this.ontology.getKB().getType(this);
    }

    @Override
    public boolean isType(OWLClass c) {
        return this.ontology.getKB().isType(this, c);
    }

    @Override
    public final boolean isDataValue() {
        return false;
    }

    @Override
    public final boolean isIndividual() {
        return true;
    }

    @Override
    public void addType(OWLClass c) {
        this.ontology.addType(this, c);
    }

    @Override
    public void removeTypes() {
        this.ontology.getKB().removeTypes(this);
    }

    @Override
    public String toRDF(boolean printRDFTag, boolean inlineNamespaces) {
        OntModel closureModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        new ModelExtract((StatementBoundary)new BNodeBoundary()).extractInto((Model)closureModel, this.resource, (Model)this.ontology.getKB().ontModel);
        StringWriter sw = new StringWriter();
        RDFWriter w = OWLWriterImpl.createJenaWriter(closureModel, null, false, Collections.<Object>emptyList());
        w.write((Model)closureModel, (Writer)sw, null);
        String rdf = sw.toString();
        if (printRDFTag) {
            return rdf;
        }
        return RDFUtils.removeRDFTag(rdf, inlineNamespaces);
    }

    @Override
    public void addSameAs(OWLIndividual other) {
        this.ontology.ontModel.add(this.resource, OWL.sameAs, (RDFNode)((Resource)other.getImplementation()));
    }

    @Override
    public boolean isSameAs(OWLIndividual other) {
        return this.ontology.getKB().isSameAs(this, other);
    }

    @Override
    public void removeSameAs(OWLIndividual other) {
        this.ontology.getKB().removeAll(this.resource, OWL.sameAs, (RDFNode)(other == null ? null : (Resource)other.getImplementation()));
    }

    @Override
    public OWLIndividualList<?> getSameIndividuals() {
        return this.ontology.getKB().getSameIndividuals(this);
    }

    @Override
    public void addDifferentFrom(OWLIndividual other) {
        this.ontology.ontModel.add(this.resource, OWL.differentFrom, other == null ? null : (Resource)other.getImplementation());
    }

    @Override
    public boolean isDifferentFrom(OWLIndividual other) {
        return this.ontology.getKB().isDifferentFrom(this, other);
    }

    @Override
    public void removeDifferentFrom(OWLIndividual other) {
        this.ontology.getKB().removeAll(this.resource, OWL.differentFrom, (RDFNode)((Resource)other.getImplementation()));
    }

    @Override
    public OWLIndividualList<?> getDifferentIndividuals() {
        return this.ontology.getKB().getDifferentIndividuals(this);
    }

    @Override
    public void delete() {
        this.ontology.getKB().remove(this, false);
    }

    @Override
    protected OWLEntityImpl<Resource> wrap(Resource res) {
        return new OWLIndividualImpl(this.ontology, res);
    }

    static final class BNodeBoundary
    extends StatementBoundaryBase {
        BNodeBoundary() {
        }

        public boolean stopAt(Statement s) {
            RDFNode stmtObject = s.getObject();
            return stmtObject.isURIResource() || stmtObject.isLiteral();
        }
    }
}

