/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import impl.jena.JenaOWLProvider;
import impl.jena.OWLKnowledgeBaseManagerImpl;
import impl.jena.OWLModelImpl;
import impl.jena.OWLOntologyImpl;
import impl.jena.OWLReaderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mindswap.common.Tuple;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.OWLSVersionTranslator;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.utils.QNameProvider;
import org.mindswap.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLKnowledgeBaseImpl
extends OWLModelImpl
implements OWLKnowledgeBase {
    private static final Logger logger = LoggerFactory.getLogger(OWLKnowledgeBaseImpl.class);
    private OWLOntologyImpl baseOntology;
    private final Set<OWLOntologyImpl> ontologies;
    private final Map<URI, Tuple<Integer, OWLOntologyImpl>> uriMap;
    private final QNameProvider qnames;
    private OWLReaderImpl reader;
    private final AtomicBoolean autoConsistency;
    private final AtomicBoolean strictConversion;
    private OWLSVersionTranslator translator;
    protected final OWLKnowledgeBaseManagerImpl manager;

    public OWLKnowledgeBaseImpl(OntModel model) {
        this(model, new OWLKnowledgeBaseManagerImpl(model.getSpecification()));
    }

    public OWLKnowledgeBaseImpl(OWLKnowledgeBaseManagerImpl kbManager) {
        this(ModelFactory.createOntologyModel((OntModelSpec)kbManager.getOntModelSpec()), kbManager);
    }

    private OWLKnowledgeBaseImpl(OntModel model, OWLKnowledgeBaseManagerImpl kbManager) {
        super(model);
        this.setAutoTranslate(false);
        this.autoConsistency = new AtomicBoolean(false);
        this.strictConversion = new AtomicBoolean(true);
        this.manager = kbManager;
        this.ontologies = new HashSet<OWLOntologyImpl>();
        this.uriMap = new HashMap<URI, Tuple<Integer, OWLOntologyImpl>>();
        this.qnames = new QNameProvider();
    }

    @Override
    public final OWLOntologyImpl getBaseModel() {
        if (this.baseOntology == null) {
            this.baseOntology = new OWLOntologyImpl(this, URI.create("urn:owl-s-api:baseOntology:" + System.nanoTime()), this.ontModel);
        }
        return this.baseOntology;
    }

    @Override
    public OWLKnowledgeBaseManagerImpl getManager() {
        return this.manager;
    }

    @Override
    public Set<OWLOntology> getOntologies(boolean all) {
        HashSet<OWLOntology> onts = new HashSet<OWLOntology>(this.ontologies);
        if (all) {
            for (OWLOntologyImpl ontology : this.ontologies) {
                onts.addAll(ontology.getImports(false));
            }
        }
        onts.add(this.getBaseModel());
        return onts;
    }

    @Override
    public OWLOntologyImpl getOntology(URI uri) {
        Tuple<Integer, OWLOntologyImpl> t = this.uriMap.get(uri);
        return t != null ? t.getElement2() : null;
    }

    @Override
    public OWLOntologyImpl createOntology(URI uri) {
        return this.createOntology(uri, null);
    }

    @Override
    public OWLOntologyImpl createOntology(URI uri, Object model) {
        return this.createOntology(uri, (OntModel)model);
    }

    OWLOntologyImpl createOntology(URI uri, OntModel model) {
        boolean checkConsistency;
        if (this.uriMap.containsKey(uri)) {
            return this.getOntology(uri);
        }
        if (model != null) {
            checkConsistency = true;
        } else {
            OntModelSpec spec = JenaOWLProvider.createOntSpec(this.manager.getOntModelSpec());
            model = ModelFactory.createOntologyModel((OntModelSpec)spec);
            checkConsistency = false;
        }
        OWLOntologyImpl ont = this.internalLoad(uri, model, true, false);
        if (checkConsistency) {
            return this.checkConsistency(ont);
        }
        return ont;
    }

    @Override
    public OWLOntologyImpl load(OWLOntology ont, boolean withImports) {
        URI uri = ont.getURI();
        if (this.uriMap.containsKey(uri)) {
            return this.getOntology(uri);
        }
        OWLOntologyImpl loadedOnt = this.internalLoad(uri, (OntModel)ont.getImplementation(), withImports, ont.isReadOnly());
        loadedOnt = this.checkConsistency(loadedOnt);
        return loadedOnt;
    }

    private OWLOntologyImpl checkConsistency(OWLOntologyImpl loadedOnt) {
        if (this.isAutoConsistency() && !this.isConsistent()) {
            logger.warn("Reject loading {} because it causes the KB to be inconsistent!", (Object)loadedOnt);
            this.unload(loadedOnt);
            loadedOnt = null;
        }
        return loadedOnt;
    }

    private OWLOntologyImpl internalLoad(URI uri, OntModel model, boolean withImports, boolean isReadOnly) {
        OWLOntologyImpl loadedOnt = new OWLOntologyImpl(this, uri, model, isReadOnly);
        if (this.isAutoTranslate()) {
            loadedOnt = (OWLOntologyImpl)this.translator.translate(loadedOnt, this.createOntology(uri));
        }
        OntModel loadedOntModel = loadedOnt.getImplementation();
        if (withImports) {
            this.ontModel.addSubModel((Model)loadedOntModel);
            for (OWLOntologyImpl imp : loadedOnt.getImports0(true)) {
                this.addOntology(imp.getURI(), imp);
            }
        } else {
            this.ontModel.addSubModel(loadedOntModel.getBaseModel());
        }
        this.uriMap.put(uri, new Tuple<Integer, OWLOntologyImpl>(1, loadedOnt));
        this.ontologies.add(loadedOnt);
        return loadedOnt;
    }

    @Override
    public void unload(URI uri) {
        OWLOntologyImpl ont = this.getOntology(uri = URIUtils.standardURI(uri));
        if (ont != null) {
            this.unload(ont);
        } else {
            logger.debug("Could not unload ontology {} because it was not found in this KB.", (Object)uri);
        }
    }

    @Override
    public void unload(OWLOntology ontology) {
        URI uri = ontology.getURI();
        if (!this.ontologies.remove(ontology)) {
            String msg = ontology + " was not directly loaded to this KB";
            if (uri != null && this.uriMap.containsKey(uri)) {
                msg = msg + ", but there is a ontology with the same URI that was loaded implicitly as a import";
            }
            msg = msg + "!";
            throw new IllegalArgumentException(msg);
        }
        this.remove(uri, ontology);
        Model m = ((OntModel)ontology.getImplementation()).getBaseModel();
        this.ontModel.removeSubModel(m);
    }

    @Override
    public OWLOntologyImpl read(URI uri) throws IOException {
        return this.getReader().read(uri);
    }

    @Override
    public OWLOntologyImpl read(Reader in, URI baseURI) throws IOException {
        return this.getReader().read(in, baseURI);
    }

    @Override
    public OWLOntologyImpl read(InputStream in, URI baseURI) throws IOException {
        return this.getReader().read(in, baseURI);
    }

    @Override
    public OWLReaderImpl getReader() {
        if (this.reader == null) {
            this.reader = new OWLReaderImpl(this);
        }
        return this.reader;
    }

    @Override
    public QNameProvider getQNames() {
        return this.qnames;
    }

    @Override
    public void refresh() {
        if (this.isBulkUpdate()) {
            return;
        }
        this.ontModel.rebind();
    }

    @Override
    public boolean isAutoConsistency() {
        return this.autoConsistency.get();
    }

    @Override
    public boolean setAutoConsistency(boolean auto) {
        return this.autoConsistency.getAndSet(auto);
    }

    @Override
    public boolean isAutoTranslate() {
        return this.translator != null;
    }

    @Override
    public boolean setAutoTranslate(boolean auto) {
        boolean previous = this.translator != null;
        this.translator = auto ? OWLSFactory.createVersionTranslator() : null;
        return previous;
    }

    @Override
    public boolean isStrictConversion() {
        return this.strictConversion.get();
    }

    @Override
    public boolean setStrictConversion(boolean strict) {
        return this.strictConversion.getAndSet(strict);
    }

    @Override
    public Service readService(URI uri) throws IOException {
        OWLOntologyImpl ont = this.read(uri);
        return this.getCorrectService(ont, uri);
    }

    @Override
    public Service readService(Reader in, URI baseURI) throws IOException {
        OWLOntologyImpl ont = this.read(in, baseURI);
        return this.getCorrectService(ont, baseURI);
    }

    @Override
    public Service readService(InputStream in, URI baseURI) throws IOException {
        OWLOntologyImpl ont = this.read(in, baseURI);
        return this.getCorrectService(ont, baseURI);
    }

    @Override
    public OWLIndividualList<Service> readAllServices(URI uri) throws IOException {
        OWLOntologyImpl ont = this.read(uri);
        return ont == null ? null : ont.getServices(false);
    }

    @Override
    public OWLIndividualList<Service> readAllServices(Reader in, URI baseURI) throws IOException {
        OWLOntologyImpl ont = this.read(in, baseURI);
        return ont == null ? null : ont.getServices(false);
    }

    @Override
    public OWLIndividualList<Service> readAllServices(InputStream in, URI baseURI) throws IOException {
        OWLOntologyImpl ont = this.read(in, baseURI);
        return ont == null ? null : ont.getServices(false);
    }

    private Service getCorrectService(OWLOntology ont, URI uri) {
        OWLIndividualList<?> services = this.getInstances(OWLS_1_2.Service.Service, (Model)ont.getImplementation());
        if (services == null || services.isEmpty()) {
            return null;
        }
        if (uri == null) {
            return ((OWLIndividual)services.get(0)).castTo(Service.class);
        }
        String stdURI = URIUtils.standardURI(uri).toString();
        OWLObject secondChoice = null;
        for (OWLIndividual service : services) {
            URI serviceURI = service.getURI();
            if (uri.equals(serviceURI)) {
                return service.castTo(Service.class);
            }
            if (!serviceURI.toString().startsWith(stdURI)) continue;
            secondChoice = service;
        }
        if (secondChoice == null && services.size() > 0) {
            secondChoice = (OWLIndividual)services.get(0);
        }
        return secondChoice == null ? null : secondChoice.castTo(Service.class);
    }

    @Override
    protected final OWLOntologyImpl getOntology() {
        return this.getBaseModel();
    }

    @Override
    protected void reasonerSet(Reasoner oldReasoner) {
        this.baseOntology = null;
    }

    @Override
    protected void removeAll(Resource s, Property p, RDFNode o) {
        this.startBulkUpdate();
        this.ontModel.removeAll(s, p, o);
        for (Map.Entry<URI, Tuple<Integer, OWLOntologyImpl>> e : this.uriMap.entrySet()) {
            OWLOntologyImpl ont = e.getValue().getElement2();
            if (ont.isReadOnly()) continue;
            ont.ontModel.removeAll(s, p, o);
        }
        this.endBulkUpdate(true);
    }

    void add(URI ontURI, OWLOntologyImpl ont) {
        this.addOntology(ontURI, ont);
        for (OWLOntologyImpl imp : ont.getImports0(true)) {
            this.addOntology(imp.getURI(), imp);
        }
    }

    void remove(URI ontURI, OWLOntology ont) {
        this.removeOntology(ontURI);
        for (OWLOntology imp : ont.getImports(true)) {
            this.removeOntology(imp.getURI());
        }
    }

    private void addOntology(URI ontURI, OWLOntologyImpl ont) {
        Tuple<Integer, OWLOntologyImpl> t = this.uriMap.get(ontURI);
        if (t != null) {
            t.setElements(t.getElement1() + 1, t.getElement2());
        } else {
            String ns;
            if (ont.getKB() != this) {
                ont = new OWLOntologyImpl(this, ontURI, ont.getImplementation(), ont.isReadOnly());
            }
            String string = ns = (ns = ontURI.toString()).endsWith("#") ? ns : ns + "#";
            if (this.isInLanguageNamespace(ns)) {
                ont.setReadOnly(true);
            }
            this.uriMap.put(ontURI, new Tuple<Integer, OWLOntologyImpl>(1, ont));
        }
    }

    private void removeOntology(URI ontURI) {
        Tuple<Integer, OWLOntologyImpl> t = this.uriMap.get(ontURI);
        if (t != null) {
            if (t.getElement1() == 1) {
                this.uriMap.remove(ontURI);
            } else {
                t.setElements(t.getElement1() - 1, t.getElement2());
            }
        }
    }
}

