/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mindswap.owl.OWLKnowledgeBaseManager;
import org.mindswap.utils.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLKnowledgeBaseManagerImpl
implements OWLKnowledgeBaseManager {
    private final OntModelSpec spec;
    private ConcurrentHashMap<String, String> errorMsgMap;

    public OWLKnowledgeBaseManagerImpl(OntModelSpec spec) {
        this.spec = spec;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        OWLKnowledgeBaseManagerImpl other = (OWLKnowledgeBaseManagerImpl)obj;
        return this.spec.getDocumentManager().equals(other.spec.getDocumentManager());
    }

    public int hashCode() {
        return this.spec.getDocumentManager().hashCode();
    }

    @Override
    public void addIgnoredOntology(URI uri) {
        if (uri == null) {
            return;
        }
        this.spec.getDocumentManager().addIgnoreImport(URIUtils.standardURI(uri).toString());
    }

    @Override
    public void clear(URI uri) {
        if (uri == null) {
            if (this.errorMsgMap != null) {
                this.errorMsgMap.clear();
            }
            ExtendedIterator it = this.spec.getImportModelMaker().getGraphMaker().listGraphs();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            this.spec.getDocumentManager().clearCache();
        } else {
            GraphMaker gm;
            String ontURI = uri.toString();
            if (this.errorMsgMap != null) {
                this.errorMsgMap.remove(ontURI);
            }
            if ((gm = this.spec.getImportModelMaker().getGraphMaker()).hasGraph(ontURI)) {
                gm.removeGraph(ontURI);
            }
            this.spec.getDocumentManager().getFileManager().removeCacheModel(ontURI);
        }
    }

    @Override
    public void clearAlternativeLocation(URI uri) {
        if (uri == null) {
            return;
        }
        String ontURI = uri.toString();
        this.spec.getDocumentManager().getFileManager().getLocationMapper().removeAltEntry(ontURI);
    }

    @Override
    public Set<URI> getIgnoredOntologies() {
        HashSet<URI> ignores = new HashSet<URI>();
        Iterator it = this.spec.getDocumentManager().listIgnoredImports();
        while (it.hasNext()) {
            ignores.add(URIUtils.createURI((String)it.next()));
        }
        return ignores;
    }

    @Override
    public boolean removeIgnoredOntology(URI uri) {
        if (uri == null) {
            return false;
        }
        String ontURI = uri.toString();
        if (this.spec.getDocumentManager().ignoringImport(ontURI)) {
            this.spec.getDocumentManager().removeIgnoreImport(ontURI);
            return true;
        }
        return false;
    }

    @Override
    public URI setAlternativeLocation(URI original, URI copy) {
        if (original == null || copy == null) {
            return null;
        }
        String originalAsString = original.toString();
        String prevAltnURI = this.spec.getDocumentManager().doAltURLMapping(originalAsString);
        this.spec.getDocumentManager().addAltEntry(originalAsString, copy.toString());
        return URIUtils.createURI(prevAltnURI);
    }

    @Override
    public void setCaching(boolean useCache) {
        boolean current = this.spec.getDocumentManager().getCacheModels();
        this.spec.getDocumentManager().setCacheModels(useCache);
        if (current && !useCache) {
            this.clear(null);
        }
    }

    @Override
    public boolean usesCache() {
        return this.spec.getDocumentManager().getCacheModels();
    }

    OntModelSpec getOntModelSpec() {
        return this.spec;
    }

    void setErrorMsgMap(ConcurrentHashMap<String, String> errorMsgMap) {
        this.errorMsgMap = errorMsgMap;
    }
}

