/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PropertyNotFoundException;
import com.hp.hpl.jena.vocabulary.RDF;
import impl.jena.OWLDataValueImpl;
import impl.jena.OWLIndividualImpl;
import impl.jena.OWLOntologyImpl;
import impl.owl.OWLObjectImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.mindswap.exceptions.InvalidListException;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.ListVocabulary;
import org.mindswap.owl.list.OWLList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLListImpl<V extends OWLValue>
extends OWLIndividualImpl
implements OWLList<V> {
    protected final ListVocabulary<V> vocabulary;

    public OWLListImpl(OWLOntologyImpl ontology, Resource resource, ListVocabulary<V> vocabulary) {
        super(ontology, resource);
        this.vocabulary = vocabulary;
    }

    @Override
    public OWLList<V> getRest() {
        Resource rest = this.getRestProperty(this.resource);
        return this.makeList(rest);
    }

    @Override
    public void setRest(OWLList<V> rest) {
        this.setRestProperty(this.resource, (Resource)rest.getImplementation());
    }

    @Override
    public V getFirst() {
        this.checkNotNil("Tried to get head of empty (nil) list.");
        RDFNode first = this.getFirstProperty(this.resource);
        return this.makeListItem(first);
    }

    @Override
    public void setFirst(V value) {
        this.checkNotNil("Tried to set the head of empty (nil) list.");
        this.setFirstProperty(this.resource, (RDFNode)value.getImplementation());
    }

    @Override
    public List<V> toList() {
        ArrayList<OWLValue> result = new ArrayList<OWLValue>();
        for (OWLValue item : this) {
            result.add(item);
        }
        return result;
    }

    @Override
    public V get(int index) {
        if (index == 0) {
            return this.getFirst();
        }
        if (index < 0 || this.isEmpty()) {
            throw new IndexOutOfBoundsException("Index less than zero or empty list.");
        }
        try {
            Resource list = this.getListAt(this.resource, index);
            RDFNode value = this.getFirstProperty(list);
            return this.makeListItem(value);
        }
        catch (PropertyNotFoundException e) {
            throw new IndexOutOfBoundsException("Invalid list structure or index larger than list size.");
        }
    }

    @Override
    public OWLList<V> with(V item) {
        if (this.isEmpty()) {
            return this.makeList(this.cons(this.resource, (RDFNode)item.getImplementation()));
        }
        Resource seen = this.resource;
        Resource rest = this.getRestProperty(this.resource);
        while (!this.isEmptyList(rest)) {
            seen = rest;
            rest = this.getRestProperty(rest);
        }
        this.setRestProperty(seen, this.cons(rest, (RDFNode)item.getImplementation()));
        return this;
    }

    @Override
    public OWLList<V> cons(V value) {
        return this.makeList(this.cons(this.resource, (RDFNode)value.getImplementation()));
    }

    @Override
    public int indexOf(V value) {
        int index = -1;
        Resource list = this.resource;
        while (!this.isEmptyList(list)) {
            ++index;
            if (value.getImplementation().equals(this.getFirstProperty(list))) {
                return index;
            }
            list = this.getRestProperty(list);
        }
        return -1;
    }

    @Override
    public OWLList<V> insert(int index, V value) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index less than zero.");
        }
        if (index == 0) {
            return this.cons(value);
        }
        try {
            Resource seen = this.resource;
            Resource rest = this.getRestProperty(this.resource);
            for (int i = 1; i < index; ++i) {
                seen = rest;
                rest = this.getRestProperty(rest);
            }
            this.setRestProperty(seen, this.cons(rest, (RDFNode)value.getImplementation()));
        }
        catch (PropertyNotFoundException e) {
            throw new IndexOutOfBoundsException("Invalid list structure or index larger than list size.");
        }
        return this;
    }

    @Override
    public OWLList<V> remove(V value) {
        block6: {
            if (value == null || this.isEmpty()) {
                return this;
            }
            int index = 0;
            Resource list = this.resource;
            try {
                while (!this.isEmptyList(list)) {
                    Resource rest;
                    RDFNode first = this.getFirstProperty(list);
                    if (first.equals(value.getImplementation())) {
                        rest = this.remove0(list);
                        if (index == 0) {
                            return this.makeList(rest);
                        }
                        list = (Resource)list.getModel().listResourcesWithProperty((Property)this.vocabulary.rest().getImplementation(), (RDFNode)list).next();
                        this.setRestProperty(list, rest);
                        return this;
                    }
                    list = this.getRestProperty(list);
                    rest = this.getRestProperty(list);
                    ++index;
                }
            }
            catch (PropertyNotFoundException e) {
                if (this.isEmptyList(list)) break block6;
                throw new InvalidListException("Invalid list structure: Details: " + (Object)((Object)e));
            }
        }
        return this;
    }

    @Override
    public OWLList<V> remove(int index) {
        if (index < 0 || this.isEmpty()) {
            throw new IndexOutOfBoundsException("Index less than zero or empty list.");
        }
        try {
            Resource list = this.getListAt(this.resource, index);
            Resource rest = this.remove0(list);
            if (index == 0) {
                return this.makeList(rest);
            }
            list = (Resource)list.getModel().listResourcesWithProperty((Property)this.vocabulary.rest().getImplementation(), (RDFNode)list).next();
            this.setRestProperty(list, rest);
            return this;
        }
        catch (PropertyNotFoundException e) {
            throw new IndexOutOfBoundsException("Invalid list structure or index larger than list size.");
        }
    }

    @Override
    public OWLList<V> clear() {
        Resource r = this.resource;
        while (!this.isEmptyList(r)) {
            r = this.remove0(r);
        }
        return this.makeList(r);
    }

    @Override
    public void delete() {
        OWLList<V> empty = this.clear();
        this.ontology.remove(empty, false);
    }

    @Override
    public V set(int index, V value) {
        this.checkNotNil("Cannot set value in empty (nil) list. Use add instead.");
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index less than zero or not less than list size.");
        }
        Resource list = this.getListAt(this.resource, index);
        RDFNode oldValue = this.getFirstProperty(list);
        this.setFirstProperty(list, (RDFNode)value.getImplementation());
        return this.makeListItem(oldValue);
    }

    @Override
    public Iterator<V> iterator() {
        return new RDFListIterator(this.resource);
    }

    @Override
    public final int size() {
        int size = 0;
        Resource list = this.resource;
        while (!this.isEmptyList(list)) {
            list = this.getRestProperty(list);
            ++size;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmptyList(this.resource);
    }

    @Override
    public ListVocabulary<V> getVocabulary() {
        return this.vocabulary;
    }

    @Override
    public <W extends V> OWLList<W> specialize(Class<W> itemAbstr) {
        if (this.vocabulary.itemAbstraction().equals(itemAbstr)) {
            return this;
        }
        ListVocabulary<W> specializedVocabulary = this.vocabulary.specialize(this.vocabulary.list(), itemAbstr);
        return new OWLListImpl<W>(this.ontology, this.resource, specializedVocabulary);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder("[");
        boolean notFirst = false;
        for (OWLValue item : this) {
            if (notFirst) {
                str.append(", ");
            } else {
                notFirst = true;
            }
            str.append(item.toString());
        }
        str.append("]");
        return str.toString();
    }

    RDFNode getFirstProperty(Resource list) {
        return list.getRequiredProperty((Property)this.vocabulary.first().getImplementation()).getObject();
    }

    Resource getRestProperty(Resource list) {
        return list.getRequiredProperty((Property)this.vocabulary.rest().getImplementation()).getResource();
    }

    boolean isEmptyList(Resource list) {
        return list.equals(this.vocabulary.nil().getImplementation());
    }

    V makeListItem(RDFNode item) {
        OWLObjectImpl listItem = item.isLiteral() ? new OWLDataValueImpl((Literal)item.as(Literal.class)) : new OWLIndividualImpl(this.ontology, (Resource)item.as(Resource.class));
        return (V)((OWLValue)listItem.castTo(this.vocabulary.itemAbstraction()));
    }

    OWLListImpl<V> makeList(Resource listResource) {
        return new OWLListImpl<V>(this.ontology, listResource, this.vocabulary);
    }

    private void checkNotNil(String msg) {
        if (this.isEmpty()) {
            throw new InvalidListException(msg);
        }
    }

    private Resource cons(Resource rest, RDFNode value) {
        Resource newList = this.createNewList();
        newList.addProperty((Property)this.vocabulary.first().getImplementation(), value);
        newList.addProperty((Property)this.vocabulary.rest().getImplementation(), (RDFNode)rest);
        return newList;
    }

    private Resource createNewList() {
        return this.ontology.ontModel.createResource((Resource)this.vocabulary.list().getImplementation());
    }

    private Resource getListAt(Resource list, int index) {
        for (int i = 0; i < index; ++i) {
            list = this.getRestProperty(list);
        }
        return list;
    }

    Resource remove0(Resource r) {
        Resource rest = this.getRestProperty(r);
        this.ontology.ontModel.removeAll(r, (Property)this.vocabulary.first().getImplementation(), null);
        this.ontology.ontModel.removeAll(r, (Property)this.vocabulary.rest().getImplementation(), null);
        this.ontology.ontModel.remove(r, RDF.type, (RDFNode)((Resource)this.vocabulary.list().getImplementation()));
        return rest;
    }

    private void setFirstProperty(Resource list, RDFNode value) {
        this.ontology.ontModel.removeAll(list, (Property)this.vocabulary.first().getImplementation(), null);
        list.addProperty((Property)this.vocabulary.first().getImplementation(), value);
    }

    void setRestProperty(Resource list, Resource rest) {
        this.ontology.ontModel.removeAll(list, (Property)this.vocabulary.rest().getImplementation(), null);
        list.addProperty((Property)this.vocabulary.rest().getImplementation(), (RDFNode)rest);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RDFListIterator
    implements Iterator<V> {
        private Resource list;

        RDFListIterator(Resource list) {
            this.list = list;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from list iterator.");
        }

        @Override
        public boolean hasNext() {
            return !OWLListImpl.this.isEmptyList(this.list);
        }

        @Override
        public V next() {
            if (OWLListImpl.this.isEmptyList(this.list)) {
                throw new NoSuchElementException();
            }
            RDFNode tmp = OWLListImpl.this.getFirstProperty(this.list);
            Object next = OWLListImpl.this.makeListItem(tmp);
            this.list = OWLListImpl.this.getRestProperty(this.list);
            return next;
        }
    }
}

