/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import aterm.ATermAppl;
import ch.unibas.on.sem.datatypes.TypeMapper;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.exceptions.DatatypeReasonerException;
import com.clarkparsia.pellet.utils.TermFactory;
import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.enhanced.UnsupportedPolymorphismException;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import impl.jena.JenaOWLProvider;
import impl.jena.OWLAnnotationPropertyImpl;
import impl.jena.OWLClassImpl;
import impl.jena.OWLDataPropertyImpl;
import impl.jena.OWLDataTypeImpl;
import impl.jena.OWLDataValueImpl;
import impl.jena.OWLIndividualImpl;
import impl.jena.OWLListImpl;
import impl.jena.OWLObjectPropertyImpl;
import impl.jena.OWLOntologyImpl;
import impl.jena.OWLWriterImpl;
import impl.jena.SPARQLExpressionImpl;
import impl.jena.SPARQLValueFunction;
import impl.jena.SWRLExpressionImpl;
import impl.jena.StandardPreparedQuery;
import impl.jena.XSDDataTypes;
import impl.owls.process.AtomicProcessImpl;
import impl.owls.process.CompositeProcessImpl;
import impl.owls.process.ResultImpl;
import impl.owls.process.binding.InputBindingImpl;
import impl.owls.process.binding.LinkBindingImpl;
import impl.owls.process.binding.LocBindingImpl;
import impl.owls.process.binding.OutputBindingImpl;
import impl.owls.process.binding.ValueConstantImpl;
import impl.owls.process.binding.ValueOfImpl;
import impl.owls.process.constructs.AnyOrderImpl;
import impl.owls.process.constructs.AsProcessImpl;
import impl.owls.process.constructs.ChoiceImpl;
import impl.owls.process.constructs.ForEachImpl;
import impl.owls.process.constructs.IfThenElseImpl;
import impl.owls.process.constructs.PerformImpl;
import impl.owls.process.constructs.ProduceImpl;
import impl.owls.process.constructs.RepeatUntilImpl;
import impl.owls.process.constructs.RepeatWhileImpl;
import impl.owls.process.constructs.SequenceImpl;
import impl.owls.process.constructs.SetImpl;
import impl.owls.process.constructs.SplitImpl;
import impl.owls.process.constructs.SplitJoinImpl;
import impl.owls.process.variable.ExistentialImpl;
import impl.owls.process.variable.InputImpl;
import impl.owls.process.variable.LinkImpl;
import impl.owls.process.variable.LocImpl;
import impl.owls.process.variable.OutputImpl;
import impl.owls.process.variable.ParticipantImpl;
import impl.owls.process.variable.ResultVarImpl;
import impl.owls.profile.ProfileImpl;
import impl.owls.profile.ServiceCategoryImpl;
import impl.owls.profile.ServiceParameterImpl;
import impl.owls.service.ServiceImpl;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.common.Variable;
import org.mindswap.exceptions.ParseException;
import org.mindswap.exceptions.UnboundVariableException;
import org.mindswap.owl.OWLAnnotationProperty;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataType;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLType;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.ListVocabulary;
import org.mindswap.owl.list.OWLList;
import org.mindswap.owls.expression.Condition;
import org.mindswap.owls.expression.Expression;
import org.mindswap.owls.grounding.JavaAtomicGrounding;
import org.mindswap.owls.grounding.JavaGrounding;
import org.mindswap.owls.grounding.JavaGroundingFactory;
import org.mindswap.owls.grounding.JavaParameter;
import org.mindswap.owls.grounding.JavaVariable;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.grounding.UPnPGrounding;
import org.mindswap.owls.grounding.UPnPGroundingFactory;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.grounding.WSDLGrounding;
import org.mindswap.owls.grounding.WSDLGroundingFactory;
import org.mindswap.owls.grounding.WSDLOperationRef;
import org.mindswap.owls.process.AnyOrder;
import org.mindswap.owls.process.AsProcess;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.ForEach;
import org.mindswap.owls.process.IfThenElse;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Produce;
import org.mindswap.owls.process.RepeatUntil;
import org.mindswap.owls.process.RepeatWhile;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.SimpleProcess;
import org.mindswap.owls.process.Split;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.process.variable.Binding;
import org.mindswap.owls.process.variable.Existential;
import org.mindswap.owls.process.variable.Input;
import org.mindswap.owls.process.variable.InputBinding;
import org.mindswap.owls.process.variable.Link;
import org.mindswap.owls.process.variable.LinkBinding;
import org.mindswap.owls.process.variable.Loc;
import org.mindswap.owls.process.variable.LocBinding;
import org.mindswap.owls.process.variable.Output;
import org.mindswap.owls.process.variable.OutputBinding;
import org.mindswap.owls.process.variable.Participant;
import org.mindswap.owls.process.variable.ResultVar;
import org.mindswap.owls.process.variable.ValueConstant;
import org.mindswap.owls.process.variable.ValueFunction;
import org.mindswap.owls.process.variable.ValueOf;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.profile.ServiceCategory;
import org.mindswap.owls.profile.ServiceParameter;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.BuiltinNamespaces;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.query.ABoxQuery;
import org.mindswap.query.Query;
import org.mindswap.query.QueryLanguage;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.SWRLObject;
import org.mindswap.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLModelImpl
implements OWLModel {
    private static final Logger logger = LoggerFactory.getLogger(OWLModelImpl.class);
    private static final BuiltinNamespaces owlsNamespaces = new BuiltinNamespaces();
    private static final Set<String> SKIP_NAMESPACES = new HashSet<String>(Arrays.asList("http://www.w3.org/2002/07/owl#", RDF.getURI(), RDFS.getURI(), ReasonerVocabulary.directSubClassOf.getNameSpace()));
    protected int bulkUpdate = 0;
    protected OntModel ontModel;
    protected OWLWriterImpl writer;

    public OWLModelImpl(OntModel model) {
        this.ontModel = model;
    }

    public OntModel getImplementation() {
        return this.ontModel;
    }

    @Override
    public void prepare() {
        if (this.isBulkUpdate()) {
            return;
        }
        this.ontModel.prepare();
    }

    @Override
    public void classify() {
        if (this.isBulkUpdate()) {
            return;
        }
        if (this.isPelletReasonerAttached()) {
            ((PelletInfGraph)this.ontModel.getGraph()).classify();
        }
    }

    @Override
    public boolean isClassified() {
        if (this.isPelletReasonerAttached()) {
            return ((PelletInfGraph)this.ontModel.getGraph()).isClassified();
        }
        return true;
    }

    @Override
    public boolean isConsistent() {
        if (this.isPelletReasonerAttached()) {
            return ((PelletInfGraph)this.ontModel.getGraph()).isConsistent();
        }
        return true;
    }

    protected void setReasoner(Reasoner newReasoner) {
        Reasoner oldReasoner = this.ontModel.getReasoner();
        if (oldReasoner != newReasoner) {
            OntModelSpec spec = this.ontModel.getSpecification();
            spec.setReasoner(newReasoner);
            if (newReasoner == null) {
                spec.setReasonerFactory(null);
            }
            List subGraphs = this.ontModel.getSubGraphs();
            this.ontModel = ModelFactory.createOntologyModel((OntModelSpec)spec, (Model)this.ontModel.getBaseModel());
            for (Graph graph : subGraphs) {
                Model wrap = ModelFactory.createModelForGraph((Graph)graph);
                this.ontModel.addSubModel(wrap, false);
            }
            this.ontModel.rebind();
            this.reasonerSet(oldReasoner);
        }
    }

    public void setReasoner(String reasonerName) {
        Reasoner r = JenaOWLProvider.createReasoner(reasonerName);
        if (reasonerName != null && r == null) {
            throw new IllegalArgumentException("Reasoner named " + reasonerName + " not found!");
        }
        this.setReasoner(r);
    }

    public void setReasoner(Object reasoner) {
        if (!(reasoner instanceof Reasoner) && reasoner != null) {
            throw new IllegalArgumentException("Jena implementation only supports reasoners that implement " + Reasoner.class);
        }
        this.setReasoner((Reasoner)reasoner);
    }

    public Reasoner getReasoner() {
        return this.ontModel.getReasoner();
    }

    @Override
    public <V extends OWLValue> OWLList<V> createList(ListVocabulary<V> vocabulary) {
        OntResource nil = this.ontModel.createOntResource(vocabulary.nil().getURI().toString());
        return this.wrapList(nil, vocabulary);
    }

    @Override
    public <V extends OWLValue> OWLList<V> createList(ListVocabulary<V> vocabulary, V item) {
        OWLList<V> list = this.createList(vocabulary);
        return item != null ? list.cons(item) : list;
    }

    @Override
    public <V extends OWLValue> OWLList<V> createList(ListVocabulary<V> vocabulary, List<V> items) {
        OWLList<OWLValue> list = this.createList(vocabulary);
        ListIterator<V> it = items.listIterator(items.size() - 1);
        while (it.hasPrevious()) {
            list = list.cons((OWLValue)it.previous());
        }
        return list;
    }

    @Override
    public OWLType getType(URI uri) {
        OWLDataType type = this.getDataType(uri);
        return type == null ? this.getClass(uri) : type;
    }

    @Override
    public OWLDataType getDataType(Class<?> clazz) {
        RDFDatatype dt = TypeMapper.getInstance().getTypeByClass(clazz);
        return dt != null ? this.createDataType(URI.create(dt.getURI())) : null;
    }

    @Override
    public OWLDataType getDataType(URI uri) {
        return XSDDataTypes.getDataType(uri);
    }

    @Override
    public OWLEntity getEntity(URI uri) {
        OWLEntity entity = this.getClass(uri);
        if (entity == null) {
            entity = this.getIndividual(uri);
        }
        if (entity == null) {
            entity = this.getObjectProperty(uri);
        }
        if (entity == null) {
            entity = this.getDataProperty(uri);
        }
        if (entity == null) {
            entity = this.getAnnotationProperty(uri);
        }
        return entity;
    }

    @Override
    public OWLClass getClass(URI uri) {
        OntClass c = this.ontModel.getOntClass(uri.toString());
        return c != null ? this.wrapClass(c) : null;
    }

    @Override
    public Set<OWLClass> getClasses(boolean named) {
        return this.getAllClasses((ExtendedIterator<? extends RDFNode>)(named ? this.ontModel.listNamedClasses() : this.ontModel.listClasses()));
    }

    @Override
    public OWLIndividual getIndividual(URI uri) {
        OntResource r = this.ontModel.getOntResource(uri.toString());
        return r != null ? this.wrapIndividual((Resource)r) : null;
    }

    @Override
    public OWLIndividualList<?> getIndividuals(boolean baseModelOnly) {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)(baseModelOnly ? ModelFactory.createOntologyModel((OntModelSpec)this.ontModel.getSpecification(), (Model)this.ontModel.getBaseModel()).listSubjects().mapWith((Map1)new InModelMapper()) : this.ontModel.listSubjects()));
    }

    @Override
    public OWLProperty getProperty(URI uri) {
        OWLProperty prop = this.getObjectProperty(uri);
        if (prop == null) {
            prop = this.getDataProperty(uri);
        }
        if (prop == null) {
            prop = this.getAnnotationProperty(uri);
        }
        return prop;
    }

    @Override
    public OWLAnnotationProperty getAnnotationProperty(URI uri) {
        AnnotationProperty prop = this.ontModel.getAnnotationProperty(uri.toString());
        return prop != null ? this.wrapAnnotationProperty(prop) : null;
    }

    @Override
    public OWLObjectProperty getObjectProperty(URI uri) {
        ObjectProperty prop = this.ontModel.getObjectProperty(uri.toString());
        return prop != null ? this.wrapObjectProperty(prop) : null;
    }

    @Override
    public OWLDataProperty getDataProperty(URI uri) {
        DatatypeProperty prop = this.ontModel.getDatatypeProperty(uri.toString());
        return prop != null ? this.wrapDataProperty(prop) : null;
    }

    @Override
    public boolean isSameAs(OWLIndividual ind1, OWLIndividual ind2) {
        return this.ontModel.contains((Resource)ind1.getImplementation(), OWL.sameAs, (RDFNode)((Resource)ind2.getImplementation()));
    }

    @Override
    public OWLIndividualList<?> getSameIndividuals(OWLIndividual ind) {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)this.ontModel.listResourcesWithProperty(OWL.sameAs, (RDFNode)((Resource)ind.getImplementation())));
    }

    @Override
    public boolean isDifferentFrom(OWLIndividual ind1, OWLIndividual ind2) {
        return this.ontModel.contains((Resource)ind1.getImplementation(), OWL.differentFrom, (RDFNode)((Resource)ind2.getImplementation()));
    }

    @Override
    public OWLIndividualList<?> getDifferentIndividuals(OWLIndividual ind) {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)this.ontModel.listResourcesWithProperty(OWL.differentFrom, (RDFNode)((Resource)ind.getImplementation())));
    }

    @Override
    public boolean isComplement(OWLClass c1, OWLClass c2) {
        return this.ontModel.contains((Resource)c1.getImplementation(), OWL.complementOf, (RDFNode)((Resource)c2.getImplementation()));
    }

    @Override
    public boolean isEquivalent(OWLType t1, OWLType t2) {
        if (t1.equals(t2)) {
            return true;
        }
        if (t1.isClass() && t2.isClass()) {
            return this.ontModel.contains((Resource)t1.getImplementation(), OWL.equivalentClass, (RDFNode)((Resource)t2.getImplementation()));
        }
        if (t1.isDataType() && t2.isDataType()) {
            if (this.isPelletReasonerAttached()) {
                PelletInfGraph g = (PelletInfGraph)this.ontModel.getGraph();
                DatatypeReasoner dr = g.getKB().getDatatypeReasoner();
                ATermAppl d1 = TermFactory.term((String)t1.getURI().toString());
                ATermAppl d2 = TermFactory.term((String)t2.getURI().toString());
                try {
                    return !dr.isSatisfiable(Arrays.asList(d1, TermFactory.not((ATermAppl)d2))) && !dr.isSatisfiable(Arrays.asList(d2, TermFactory.not((ATermAppl)d1)));
                }
                catch (DatatypeReasonerException e) {
                    logger.debug("Failed to check whether datatype {} is equivalent to {}. Details: {}", new Object[]{t1, t2, e});
                }
            } else {
                logger.debug("Cannot determine if {} is equivalent to {} because no reasoner with datatype reasoning support attached.", (Object)t1, (Object)t2);
            }
            logger.warn("Quasi check whether datatype {} is equivalent to {} based on syntactical URI equivalence.", (Object)t1, (Object)t2);
            return t1.equals(t2);
        }
        return false;
    }

    @Override
    public boolean isDisjoint(OWLType t1, OWLType t2) {
        if (t1.isClass() && t2.isClass()) {
            return this.ontModel.contains((Resource)t1.getImplementation(), OWL.disjointWith, (RDFNode)((Resource)t2.getImplementation()));
        }
        if (t1.isDataType() && t2.isDataType()) {
            if (this.isPelletReasonerAttached()) {
                PelletInfGraph g = (PelletInfGraph)this.ontModel.getGraph();
                DatatypeReasoner dr = g.getKB().getDatatypeReasoner();
                ATermAppl d1 = TermFactory.term((String)t1.getURI().toString());
                ATermAppl d2 = TermFactory.term((String)t2.getURI().toString());
                try {
                    return !dr.isSatisfiable(Arrays.asList(d1, d2));
                }
                catch (DatatypeReasonerException e) {
                    logger.debug("Failed to check whether datatype {} is disjoint with {}. Details: {}", new Object[]{t1, t2, e});
                }
            } else {
                logger.debug("Cannot determine if {} is disjoint with {} because no reasoner with datatype reasoning support attached.", (Object)t1, (Object)t2);
            }
            logger.warn("Quasi check whether datatype {} is disjointness with {} based on syntactical URI difference.", (Object)t1, (Object)t2);
            return !t1.equals(t2);
        }
        return true;
    }

    @Override
    public Set<OWLClass> getSubClasses(OWLClass c, boolean direct) {
        Property subClassOf = direct ? ReasonerVocabulary.directSubClassOf : RDFS.subClassOf;
        return this.getAllClasses((ExtendedIterator<? extends RDFNode>)this.ontModel.listResourcesWithProperty(subClassOf, (RDFNode)((Resource)c.getImplementation())));
    }

    @Override
    public Set<OWLProperty> getSubProperties(OWLProperty p) {
        if (p.isObjectProperty()) {
            return this.getAllObjectProperties((ExtendedIterator<? extends RDFNode>)this.ontModel.listResourcesWithProperty(RDFS.subPropertyOf, (RDFNode)((Resource)p.getImplementation())));
        }
        return this.getAllDataProperties((ExtendedIterator<? extends RDFNode>)this.ontModel.listResourcesWithProperty(RDFS.subPropertyOf, (RDFNode)((Resource)p.getImplementation())));
    }

    @Override
    public Set<OWLProperty> getEquivalentProperties(OWLProperty p) {
        if (p.isObjectProperty()) {
            return this.getAllObjectProperties((ExtendedIterator<? extends RDFNode>)this.ontModel.listResourcesWithProperty(OWL.equivalentProperty, (RDFNode)((Resource)p.getImplementation())));
        }
        return this.getAllDataProperties((ExtendedIterator<? extends RDFNode>)this.ontModel.listResourcesWithProperty(OWL.equivalentProperty, (RDFNode)((Resource)p.getImplementation())));
    }

    @Override
    public Set<OWLProperty> getSuperProperties(OWLProperty p) {
        if (p.isObjectProperty()) {
            return this.getAllObjectProperties((ExtendedIterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)p.getImplementation(), RDFS.subPropertyOf));
        }
        return this.getAllDataProperties((ExtendedIterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)p.getImplementation(), RDFS.subPropertyOf));
    }

    @Override
    public Set<OWLClass> getSuperClasses(OWLClass c, boolean direct) {
        Property subClassOf = direct ? ReasonerVocabulary.directSubClassOf : RDFS.subClassOf;
        return this.getAllClasses((ExtendedIterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)c.getImplementation(), subClassOf));
    }

    @Override
    public Set<OWLClass> getEquivalentClasses(OWLClass c) {
        return this.getAllClasses((ExtendedIterator<? extends RDFNode>)this.ontModel.listResourcesWithProperty(OWL.equivalentClass, (RDFNode)((Resource)c.getImplementation())));
    }

    @Override
    public OWLIndividualList<?> getInstances(OWLClass c, boolean baseModelOnly) {
        return this.getInstances(c, baseModelOnly ? this.ontModel.getBaseModel() : null);
    }

    @Override
    public Set<OWLClass> getTypes(OWLIndividual ind) {
        return this.getAllClasses((ExtendedIterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), RDF.type));
    }

    @Override
    public OWLIndividual getProperty(OWLIndividual ind, OWLObjectProperty prop) {
        Statement s = this.ontModel.getProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation());
        RDFNode n = s != null ? s.getObject() : null;
        return n != null && n.isResource() ? this.wrapIndividual((Resource)n) : null;
    }

    @Override
    public OWLIndividualList<?> getProperties(OWLIndividual ind, OWLObjectProperty prop) {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation()));
    }

    private Map<OWLProperty, List<OWLValue>> getProperties(Resource resource) {
        HashMap<OWLProperty, List<OWLValue>> result = new HashMap<OWLProperty, List<OWLValue>>();
        StmtIterator it = this.ontModel.listStatements(resource, null, (RDFNode)null);
        while (it.hasNext()) {
            ArrayList<OWLValue> list;
            OWLProperty prop;
            Statement stmt = (Statement)it.next();
            Property stmtPred = stmt.getPredicate();
            if (SKIP_NAMESPACES.contains(stmtPred.getNameSpace())) continue;
            RDFNode stmtObject = stmt.getObject();
            if (stmtObject.isResource()) {
                try {
                    prop = this.wrapObjectProperty((ObjectProperty)stmtPred.as(ObjectProperty.class));
                }
                catch (UnsupportedPolymorphismException e) {
                    continue;
                }
                list = (ArrayList<OWLValue>)result.get(prop);
                if (list == null) {
                    list = new ArrayList<OWLValue>();
                    result.put(prop, list);
                }
                list.add(this.wrapIndividual((Resource)stmtObject.as(Resource.class)));
                continue;
            }
            try {
                prop = this.wrapDataProperty((DatatypeProperty)stmtPred.as(DatatypeProperty.class));
            }
            catch (UnsupportedPolymorphismException e) {
                continue;
            }
            list = (List)result.get(prop);
            if (list == null) {
                list = new ArrayList();
                result.put(prop, list);
            }
            list.add(this.wrapDataValue((Literal)stmtObject.as(Literal.class)));
        }
        return result;
    }

    @Override
    public List<OWLProperty> getDeclaredProperties(OWLClass clazz, boolean direct) {
        ArrayList<OWLProperty> result = new ArrayList<OWLProperty>();
        OntClass ontClaz = this.ontModel.getOntClass(clazz.getURI().toString());
        if (ontClaz == null) {
            return result;
        }
        ExtendedIterator it = ontClaz.listDeclaredProperties(direct);
        while (it.hasNext()) {
            OntProperty ontProp = (OntProperty)it.next();
            if (ontProp.isDatatypeProperty()) {
                result.add(this.wrapDataProperty(ontProp.asDatatypeProperty()));
                continue;
            }
            if (!ontProp.isObjectProperty()) continue;
            result.add(this.wrapObjectProperty(ontProp.asObjectProperty()));
        }
        return result;
    }

    @Override
    public Map<OWLProperty, List<OWLValue>> getProperties(OWLClass clazz) {
        return this.getProperties((Resource)clazz.getImplementation());
    }

    @Override
    public Map<OWLProperty, List<OWLValue>> getProperties(OWLIndividual ind) {
        return this.getProperties((Resource)ind.getImplementation());
    }

    @Override
    public OWLDataValue getProperty(OWLIndividual ind, OWLDataProperty prop) {
        OWLDataValue result = null;
        int maxPriority = -1;
        List<OWLDataValue> list = this.getAllDataValues((ExtendedIterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation()));
        for (OWLDataValue value : list) {
            int priority = OWLConfig.getDefaultLanguages().indexOf(value.getLanguage());
            if (priority == 0) {
                return value;
            }
            if (priority <= maxPriority) continue;
            result = value;
            maxPriority = priority;
        }
        return result;
    }

    @Override
    public OWLType getPropertyAsOWLType(OWLIndividual ind, OWLDataProperty prop) {
        NodeIterator it = this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation());
        while (it.hasNext()) {
            RDFNode node = it.next();
            if (!node.isLiteral()) continue;
            String uri = ((Literal)node).getLexicalForm().trim();
            OWLType result = this.getType(URIUtils.createURI(uri));
            return result;
        }
        return null;
    }

    @Override
    public OWLDataValue getProperty(OWLIndividual ind, OWLDataProperty prop, String lang) {
        List<OWLDataValue> list = this.getAllDataValues((ExtendedIterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation()));
        for (OWLDataValue value : list) {
            if (lang != null && !value.getLanguage().equals(lang)) continue;
            return value;
        }
        return null;
    }

    @Override
    public List<OWLDataValue> getProperties(OWLIndividual ind, OWLDataProperty prop) {
        return this.getAllDataValues((ExtendedIterator<? extends RDFNode>)this.ontModel.listObjectsOfProperty((Resource)ind.getImplementation(), (Property)prop.getImplementation()));
    }

    @Override
    public OWLIndividual getIncomingProperty(OWLObjectProperty prop, OWLIndividual ind) {
        return this.getFirstIndividual((ExtendedIterator<? extends RDFNode>)this.ontModel.listResourcesWithProperty((Property)prop.getImplementation(), (RDFNode)((Resource)ind.getImplementation())));
    }

    @Override
    public OWLIndividualList<?> getIncomingProperties(OWLObjectProperty prop, OWLIndividual ind) {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)this.ontModel.listResourcesWithProperty((Property)prop.getImplementation(), (RDFNode)((Resource)ind.getImplementation())));
    }

    @Override
    public OWLIndividualList<?> getIncomingProperties(OWLIndividual ind) {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)this.ontModel.listStatements(null, null, (RDFNode)((Resource)ind.getImplementation())).mapWith((Map1)new Map1<Statement, Resource>(){

            public Resource map1(Statement o) {
                return o.getSubject();
            }
        }));
    }

    @Override
    public OWLIndividual getIncomingProperty(OWLDataProperty prop, OWLDataValue value) {
        return this.getFirstIndividual((ExtendedIterator<? extends RDFNode>)this.ontModel.listResourcesWithProperty((Property)prop.getImplementation(), (RDFNode)((Literal)value.getImplementation())));
    }

    @Override
    public OWLIndividualList<?> getIncomingProperties(OWLDataProperty prop, OWLDataValue value) {
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)this.ontModel.listResourcesWithProperty((Property)prop.getImplementation(), (RDFNode)((Literal)value.getImplementation())));
    }

    @Override
    public boolean contains(OWLEntity s, OWLProperty p, OWLValue o) {
        return this.ontModel.contains(s == null ? null : (Resource)s.getImplementation(), p == null ? null : (Property)p.getImplementation(), o == null ? null : (RDFNode)o.getImplementation());
    }

    @Override
    public OWLClass getType(OWLIndividual ind) {
        RDFNode classNode;
        Statement stmt = this.ontModel.getProperty((Resource)ind.getImplementation(), RDF.type);
        RDFNode rDFNode = classNode = stmt == null ? null : stmt.getObject();
        if (classNode == null) {
            return null;
        }
        try {
            OntClass c = (OntClass)classNode.as(OntClass.class);
            return this.wrapClass(c);
        }
        catch (ConversionException e) {
            return null;
        }
    }

    @Override
    public boolean isType(OWLIndividual ind, OWLClass c) {
        return this.ontModel.contains((Resource)ind.getImplementation(), RDF.type, (RDFNode)((Resource)c.getImplementation()));
    }

    @Override
    public boolean isEnumerated(OWLClass c) {
        return this.ontModel.contains((Resource)c.getImplementation(), OWL.oneOf, (RDFNode)((Resource)null));
    }

    @Override
    public OWLIndividualList<?> getEnumerations(OWLClass c) {
        Statement stmt = this.ontModel.getProperty((Resource)c.getImplementation(), OWL.oneOf);
        if (stmt == null) {
            return null;
        }
        RDFList oneOf = (RDFList)stmt.getObject().as(RDFList.class);
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)oneOf.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<OWLProperty> getAllObjectProperties(ExtendedIterator<? extends RDFNode> it) {
        HashSet<OWLProperty> set = new HashSet<OWLProperty>();
        try {
            while (it.hasNext()) {
                set.add(this.wrapObjectProperty((ObjectProperty)((RDFNode)it.next()).as(ObjectProperty.class)));
            }
            HashSet<OWLProperty> hashSet = set;
            return hashSet;
        }
        finally {
            it.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<OWLProperty> getAllDataProperties(ExtendedIterator<? extends RDFNode> it) {
        HashSet<OWLProperty> set = new HashSet<OWLProperty>();
        try {
            while (it.hasNext()) {
                set.add(this.wrapDataProperty((DatatypeProperty)((RDFNode)it.next()).as(DatatypeProperty.class)));
            }
            HashSet<OWLProperty> hashSet = set;
            return hashSet;
        }
        finally {
            it.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<OWLClass> getAllClasses(ExtendedIterator<? extends RDFNode> it) {
        HashSet<OWLClass> set = new HashSet<OWLClass>();
        try {
            while (it.hasNext()) {
                set.add(this.wrapClass((OntClass)((RDFNode)it.next()).as(OntClass.class)));
            }
            HashSet<OWLClass> hashSet = set;
            return hashSet;
        }
        finally {
            it.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OWLIndividualList<?> getAllIndividuals(ExtendedIterator<? extends RDFNode> it) {
        OWLIndividualList list = OWLFactory.createIndividualList();
        try {
            while (it.hasNext()) {
                list.add(this.wrapIndividual((Resource)((RDFNode)it.next()).as(Resource.class)));
            }
            OWLIndividualList oWLIndividualList = list;
            return oWLIndividualList;
        }
        finally {
            it.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OWLIndividual getFirstIndividual(ExtendedIterator<? extends RDFNode> it) {
        try {
            if (it.hasNext()) {
                OWLIndividual oWLIndividual = this.wrapIndividual((Resource)((RDFNode)it.next()).as(Resource.class));
                return oWLIndividual;
            }
            OWLIndividual oWLIndividual = null;
            return oWLIndividual;
        }
        finally {
            it.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<OWLDataValue> getAllDataValues(ExtendedIterator<? extends RDFNode> it) {
        ArrayList<OWLDataValue> list = new ArrayList<OWLDataValue>();
        try {
            while (it.hasNext()) {
                list.add(this.wrapDataValue((Literal)((RDFNode)it.next()).as(Literal.class)));
            }
            ArrayList<OWLDataValue> arrayList = list;
            return arrayList;
        }
        finally {
            it.close();
        }
    }

    protected final OWLDataValue wrapDataValue(Literal l) {
        return new OWLDataValueImpl(l);
    }

    protected final OWLIndividual wrapIndividual(Resource r) {
        return new OWLIndividualImpl(this.getOntology(), r);
    }

    protected final OWLClass wrapClass(OntClass c) {
        return new OWLClassImpl(this.getOntology(), c);
    }

    protected final OWLAnnotationProperty wrapAnnotationProperty(AnnotationProperty p) {
        return new OWLAnnotationPropertyImpl(this.getOntology(), p);
    }

    protected final OWLObjectProperty wrapObjectProperty(ObjectProperty p) {
        return new OWLObjectPropertyImpl(this.getOntology(), p);
    }

    protected final OWLDataProperty wrapDataProperty(DatatypeProperty p) {
        return new OWLDataPropertyImpl(this.getOntology(), p);
    }

    protected final <V extends OWLValue> OWLList<V> wrapList(OntResource r, ListVocabulary<V> vocabulary) {
        return new OWLListImpl<V>(this.getOntology(), (Resource)r, vocabulary);
    }

    @Override
    public void evaluateGround(OWLList<Atom> atoms) {
        this.evaluate(atoms, true);
    }

    @Override
    public void evaluate(OWLList<Atom> atoms) throws UnboundVariableException {
        this.evaluate(atoms, false);
    }

    private void evaluate(OWLList<Atom> atoms, boolean skipUnground) {
        block0: for (Atom atom : atoms) {
            for (int i = 0; i < atom.getArgumentCount(); ++i) {
                SWRLObject arg = atom.getArgument(i);
                if (!arg.isVariable()) continue;
                if (skipUnground) continue block0;
                throw new UnboundVariableException((Variable)((Object)arg));
            }
            atom.evaluate(null);
        }
    }

    @Override
    public Query<Variable> makeQuery(String queryStr, QueryLanguage lang) throws ParseException {
        return StandardPreparedQuery.createQuery(queryStr, lang, this);
    }

    @Override
    public <V extends Variable> Query<V> makeQuery(ABoxQuery<V> query) {
        return this.makeQuery(query.getBody(), query.getResultVariables());
    }

    @Override
    public <V extends Variable> Query<V> makeQuery(OWLList<Atom> atoms, List<V> resultVars) {
        return new StandardPreparedQuery<V>(atoms, resultVars, this);
    }

    @Override
    public boolean isSubTypeOf(OWLType t1, OWLType t2) {
        if (t1.equals(t2)) {
            return true;
        }
        if (t1.isClass() && t2.isClass()) {
            return this.ontModel.contains((Resource)t1.getImplementation(), RDFS.subClassOf, (RDFNode)((Resource)t2.getImplementation()));
        }
        if (t1.isDataType() && t2.isDataType()) {
            if (this.isPelletReasonerAttached()) {
                PelletInfGraph g = (PelletInfGraph)this.ontModel.getGraph();
                DatatypeReasoner dr = g.getKB().getDatatypeReasoner();
                ATermAppl d1 = TermFactory.term((String)t1.getURI().toString());
                ATermAppl d2 = TermFactory.term((String)t2.getURI().toString());
                try {
                    return !dr.isSatisfiable(Arrays.asList(d1, TermFactory.not((ATermAppl)d2)));
                }
                catch (DatatypeReasonerException e) {
                    logger.debug("Failed to check whether datatype {} is subsumed by {}. Details: {}", new Object[]{t1, t2, e});
                }
            } else {
                logger.debug("Cannot determine if {} is subsumed by {} because no reasoner with datatype reasoning support attached.", (Object)t1, (Object)t2);
            }
            logger.warn("Quasi check whether datatype {} is subsumed by {} based on syntactical URI equivalence.", (Object)t1, (Object)t2);
        }
        return false;
    }

    @Override
    public OWLClass createClass(URI classURI) {
        OntClass c = this.ontModel.createClass(classURI != null ? classURI.toString() : null);
        return this.wrapClass(c);
    }

    @Override
    public OWLDataType createDataType(URI dataTypeURI) {
        OWLDataType t = this.getDataType(dataTypeURI);
        return t != null ? t : new OWLDataTypeImpl(this.getOntology().getKB(), (RDFDatatype)new BaseDatatype(dataTypeURI.toString()));
    }

    @Override
    public OWLAnnotationProperty createAnnotationProperty(URI annotationPropertyURI) {
        AnnotationProperty p = this.ontModel.createAnnotationProperty(annotationPropertyURI.toString());
        return this.wrapAnnotationProperty(p);
    }

    @Override
    public OWLObjectProperty createObjectProperty(URI objectPropertyURI) {
        ObjectProperty p = this.ontModel.createObjectProperty(objectPropertyURI.toString());
        return this.wrapObjectProperty(p);
    }

    @Override
    public OWLDataProperty createDataProperty(URI datatypePropertyURI) {
        DatatypeProperty p = this.ontModel.createDatatypeProperty(datatypePropertyURI.toString());
        return this.wrapDataProperty(p);
    }

    @Override
    public OWLIndividual createIndividual(URI type, URI indURI) {
        OntResource r = this.ontModel.createOntResource(indURI == null ? null : indURI.toString());
        if (type != null) {
            r.addRDFType(this.getOntology().getKB().ontModel.createResource(type.toString()));
        }
        return this.wrapIndividual((Resource)r);
    }

    @Override
    public OWLIndividual createInstance(OWLClass clazz, URI indURI) {
        Resource c = clazz == null ? OWL.Thing : ((OWLClassImpl)clazz).getImplementation();
        Individual ind = this.ontModel.createIndividual(indURI == null ? null : indURI.toString(), c);
        return this.wrapIndividual((Resource)ind);
    }

    @Override
    public OWLDataValue createDataValue(String value) {
        return new OWLDataValueImpl(this.ontModel.createLiteral(value));
    }

    @Override
    public OWLDataValue createDataValue(String value, String language) {
        return new OWLDataValueImpl(this.ontModel.createLiteral(value, language));
    }

    @Override
    public OWLDataValue createDataValue(Object value, URI datatypeURI) {
        if (value instanceof OWLDataValue) {
            return (OWLDataValue)value;
        }
        return new OWLDataValueImpl(this.ontModel.createTypedLiteral(value, datatypeURI.toString()));
    }

    @Override
    public OWLDataValue createDataValue(Object value) {
        if (value instanceof OWLDataValue) {
            return (OWLDataValue)value;
        }
        return new OWLDataValueImpl(this.ontModel.createTypedLiteral(value));
    }

    @Override
    public AnyOrder createAnyOrder(URI uri) {
        return new AnyOrderImpl(this.createInstance(OWLS_1_2.Process.AnyOrder, uri));
    }

    @Override
    public AsProcess createAsProcess(URI uri) {
        return new AsProcessImpl(this.createInstance(OWLS_1_2.Process.AsProcess, uri));
    }

    @Override
    public AtomicProcess createAtomicProcess(URI uri) {
        return new AtomicProcessImpl(this.createInstance(OWLS_1_2.Process.AtomicProcess, uri));
    }

    @Override
    public Choice createChoice(URI uri) {
        return new ChoiceImpl(this.createInstance(OWLS_1_2.Process.Choice, uri));
    }

    @Override
    public CompositeProcess createCompositeProcess(URI uri) {
        return new CompositeProcessImpl(this.createInstance(OWLS_1_2.Process.CompositeProcess, uri));
    }

    @Override
    public Condition.SWRL createSWRLCondition(URI uri) {
        return new SWRLExpressionImpl(this.createInstance(OWLS_1_2.Expression.SWRL_Condition, uri));
    }

    @Override
    public Expression.SWRL createSWRLExpression(URI uri) {
        return new SWRLExpressionImpl(this.createInstance(OWLS_1_2.Expression.SWRL_Expression, uri));
    }

    @Override
    public Condition.SPARQL createSPARQLCondition(URI uri) {
        return new SPARQLExpressionImpl(this.createInstance(OWLS_1_2.Expression.SPARQL_Condition, uri));
    }

    @Override
    public Expression.SPARQL createSPARQLExpression(URI uri) {
        return new SPARQLExpressionImpl(this.createInstance(OWLS_1_2.Expression.SPARQL_Expression, uri));
    }

    @Override
    public ForEach createForEach(URI uri) {
        return new ForEachImpl(this.createInstance(OWLS_1_2.Process.ForEach, uri));
    }

    @Override
    public WSDLGrounding createWSDLGrounding(URI uri) {
        return WSDLGroundingFactory.createWSDLGrounding(uri, this);
    }

    @Override
    public IfThenElse createIfThenElse(URI uri) {
        return new IfThenElseImpl(this.createInstance(OWLS_1_2.Process.IfThenElse, uri));
    }

    @Override
    public Input createInput(URI uri) {
        return new InputImpl(this.createInstance(OWLS_1_2.Process.Input, uri));
    }

    @Override
    public InputBinding createInputBinding(URI uri) {
        return new InputBindingImpl(this.createInstance(OWLS_1_2.Process.InputBinding, uri));
    }

    @Override
    public Existential createExistential(URI uri) {
        return new ExistentialImpl(this.createInstance(OWLS_1_2.Process.Existential, uri));
    }

    @Override
    public ResultVar createResultVar(URI uri) {
        return new ResultVarImpl(this.createInstance(OWLS_1_2.Process.ResultVar, uri));
    }

    @Override
    public Loc createLoc(URI uri) {
        return new LocImpl(this.createInstance(OWLS_1_2.Process.Loc, uri));
    }

    @Override
    public LocBinding createLocBinding(URI uri) {
        return new LocBindingImpl(this.createInstance(OWLS_1_2.Process.LocBinding, uri));
    }

    @Override
    public Link createLink(URI uri) {
        return new LinkImpl(this.createInstance(OWLS_1_2.Process.Link, uri));
    }

    @Override
    public LinkBinding createLinkBinding(URI uri) {
        return new LinkBindingImpl(this.createInstance(OWLS_1_2.Process.LinkBinding, uri));
    }

    @Override
    public Participant createParticipant(URI uri) {
        return new ParticipantImpl(this.createInstance(OWLS_1_2.Process.Participant, uri));
    }

    @Override
    public MessageMap<String> createWSDLInputMessageMap(URI uri) {
        return WSDLGroundingFactory.createWSDLInputMessageMap(uri, this);
    }

    @Override
    public MessageMap<String> createWSDLOutputMessageMap(URI uri) {
        return WSDLGroundingFactory.createWSDLOutputMessageMap(uri, this);
    }

    @Override
    public MessageMap<String> createUPnPMessageMap(URI uri) {
        return UPnPGroundingFactory.createUPnPMessageMap(uri, this);
    }

    @Override
    public Output createOutput(URI uri) {
        return new OutputImpl(this.createInstance(OWLS_1_2.Process.Output, uri));
    }

    @Override
    public OutputBinding createOutputBinding(URI uri) {
        return new OutputBindingImpl(this.createInstance(OWLS_1_2.Process.OutputBinding, uri));
    }

    @Override
    public Perform createPerform(URI uri) {
        return new PerformImpl(this.createInstance(OWLS_1_2.Process.Perform, uri));
    }

    @Override
    public Produce createProduce(URI uri) {
        return new ProduceImpl(this.createInstance(OWLS_1_2.Process.Produce, uri));
    }

    @Override
    public Profile createProfile(URI uri) {
        return new ProfileImpl(this.createInstance(OWLS_1_2.Profile.Profile, uri));
    }

    @Override
    public RepeatUntil createRepeatUntil(URI uri) {
        return new RepeatUntilImpl(this.createInstance(OWLS_1_2.Process.RepeatUntil, uri));
    }

    @Override
    public RepeatWhile createRepeatWhile(URI uri) {
        return new RepeatWhileImpl(this.createInstance(OWLS_1_2.Process.RepeatWhile, uri));
    }

    @Override
    public Result createResult(URI uri) {
        return new ResultImpl(this.createInstance(OWLS_1_2.Process.Result, uri));
    }

    @Override
    public Sequence createSequence(URI uri) {
        return new SequenceImpl(this.createInstance(OWLS_1_2.Process.Sequence, uri));
    }

    @Override
    public org.mindswap.owls.process.Set createSet(URI uri) {
        return new SetImpl(this.createInstance(OWLS_1_2.Process.Set, uri));
    }

    @Override
    public Service createService(URI uri) {
        return new ServiceImpl(this.createInstance(OWLS_1_2.Service.Service, uri));
    }

    @Override
    public ServiceCategory createServiceCategory(URI uri) {
        return new ServiceCategoryImpl(this.createInstance(OWLS_1_2.ServiceCategory.ServiceCategory, uri));
    }

    @Override
    public ServiceParameter createServiceParameter(URI uri) {
        return new ServiceParameterImpl(this.createInstance(OWLS_1_2.ServiceParameter.ServiceParameter, uri));
    }

    @Override
    public Split createSplit(URI uri) {
        return new SplitImpl(this.createInstance(OWLS_1_2.Process.Split, uri));
    }

    @Override
    public SplitJoin createSplitJoin(URI uri) {
        return new SplitJoinImpl(this.createInstance(OWLS_1_2.Process.SplitJoin, uri));
    }

    @Override
    public UPnPGrounding createUPnPGrounding(URI uri) {
        return UPnPGroundingFactory.createUPnPGrounding(uri, this);
    }

    @Override
    public UPnPAtomicGrounding createUPnPAtomicGrounding(URI uri) {
        return UPnPGroundingFactory.createUPnPAtomicGrounding(uri, this);
    }

    @Override
    public JavaAtomicGrounding createJavaAtomicGrounding(URI uri) {
        return JavaGroundingFactory.createJavaAtomicGrounding(uri, this);
    }

    @Override
    public JavaGrounding createJavaGrounding(URI uri) {
        return JavaGroundingFactory.createJavaGrounding(uri, this);
    }

    @Override
    public JavaParameter createJavaParameter(URI uri) {
        return JavaGroundingFactory.createJavaParameter(uri, this);
    }

    @Override
    public JavaVariable createJavaVariable(URI uri) {
        return JavaGroundingFactory.createJavaVariable(uri, this);
    }

    @Override
    public ValueOf createValueOf(URI uri) {
        return new ValueOfImpl(this.createInstance(OWLS_1_2.Process.ValueOf, uri));
    }

    @Override
    public ValueConstant createValueConstant(OWLValue dataValue, Binding<?> enclosingBinding) {
        return new ValueConstantImpl(dataValue, enclosingBinding);
    }

    @Override
    public ValueFunction<Expression.SPARQL> createSPARQLValueFunction(Expression.SPARQL expression, Binding<?> enclosingBinding) {
        return new SPARQLValueFunction(expression, enclosingBinding);
    }

    @Override
    public WSDLAtomicGrounding createWSDLAtomicGrounding(URI uri) {
        return WSDLGroundingFactory.createWSDLAtomicGrounding(uri, this);
    }

    @Override
    public WSDLOperationRef createWSDLOperationRef(URI uri) {
        return WSDLGroundingFactory.createWSDLOperationRef(uri, this);
    }

    @Override
    public OWLList<ControlConstruct> createControlConstructList(ControlConstruct cc) {
        OWLList<ControlConstruct> list = this.createList(OWLS_1_2.Process.CCList);
        return cc != null ? list.cons(cc) : list;
    }

    @Override
    public OWLList<ControlConstruct> createControlConstructBag(ControlConstruct cc) {
        OWLList<ControlConstruct> bag = this.createList(OWLS_1_2.Process.CCBag);
        return cc != null ? bag.cons(cc) : bag;
    }

    @Override
    public OWLIndividualList<Service> getServices(boolean baseModelOnly) {
        return OWLFactory.wrapList(this.getInstances(OWLS_1_2.Service.Service, baseModelOnly), Service.class);
    }

    @Override
    public Service getService(URI serviceURI) {
        if (serviceURI == null) {
            OWLIndividualList<Service> list = this.getServices(false);
            return list.isEmpty() ? null : (Service)list.get(0);
        }
        OWLIndividual ind = this.getIndividual(serviceURI);
        return ind == null ? null : ind.castTo(Service.class);
    }

    @Override
    public OWLIndividualList<Profile> getProfiles(boolean baseModelOnly) {
        return OWLFactory.wrapList(this.getInstances(OWLS_1_2.Profile.Profile, baseModelOnly), Profile.class);
    }

    @Override
    public Profile getProfile(URI profileURI) {
        OWLIndividual ind = this.getIndividual(profileURI);
        return ind == null ? null : ind.castTo(Profile.class);
    }

    @Override
    public OWLIndividualList<? extends Process> getProcesses(int type, boolean baseModelOnly) {
        OWLIndividualList result = OWLFactory.createIndividualList();
        if ((type & 1) == 1) {
            result.addAll(OWLFactory.wrapList(this.getInstances(OWLS_1_2.Process.AtomicProcess, baseModelOnly), AtomicProcess.class));
        }
        if ((type & 2) == 2) {
            result.addAll(OWLFactory.wrapList(this.getInstances(OWLS_1_2.Process.CompositeProcess, baseModelOnly), CompositeProcess.class));
        }
        if ((type & 4) == 4) {
            result.addAll(OWLFactory.wrapList(this.getInstances(OWLS_1_2.Process.SimpleProcess, baseModelOnly), SimpleProcess.class));
        }
        return result;
    }

    @Override
    public Process getProcess(URI processURI) {
        OWLIndividual ind = this.getIndividual(processURI);
        return ind == null ? null : ind.castTo(Process.class);
    }

    @Override
    public boolean isLockSupported() {
        return true;
    }

    @Override
    public void lockForRead() {
        this.ontModel.enterCriticalSection(true);
    }

    @Override
    public void lockForWrite() {
        this.ontModel.enterCriticalSection(false);
    }

    @Override
    public void releaseLock() {
        this.ontModel.leaveCriticalSection();
    }

    @Override
    public OWLWriterImpl getWriter() {
        if (this.writer == null) {
            this.writer = new OWLWriterImpl(this);
            this.writer.setNsPrefix("service", "http://www.daml.org/services/owl-s/1.2/Service.owl#");
            this.writer.setNsPrefix("profile", "http://www.daml.org/services/owl-s/1.2/Profile.owl#");
            this.writer.setNsPrefix("process", "http://www.daml.org/services/owl-s/1.2/Process.owl#");
            this.writer.setNsPrefix("grounding", "http://www.daml.org/services/owl-s/1.2/Grounding.owl#");
            this.writer.setNsPrefix("expr", "http://www.daml.org/services/owl-s/1.2/generic/Expression.owl#");
            this.writer.setNsPrefix("list", "http://www.daml.org/services/owl-s/1.2/generic/ObjectList.owl#");
            this.writer.setNsPrefix("swrl", "http://www.w3.org/2003/11/swrl#");
            this.writer.addPrettyType(OWLS_1_2.Service.Service);
            this.writer.addPrettyType(OWLS_1_2.Service.ServiceGrounding);
            this.writer.addPrettyType(OWLS_1_2.Profile.Profile);
            this.writer.addPrettyType(OWLS_1_2.Process.Process);
            this.writer.addPrettyType(OWLS_1_2.Process.AtomicProcess);
            this.writer.addPrettyType(OWLS_1_2.Process.CompositeProcess);
            this.writer.addPrettyType(OWLS_1_2.Process.SimpleProcess);
            this.writer.addPrettyType(OWLS_1_2.Process.Perform);
            this.writer.addPrettyType(OWLS_1_2.Grounding.WsdlGrounding);
            this.writer.addPrettyType(OWLS_1_2.Grounding.WsdlAtomicProcessGrounding);
        }
        return this.writer;
    }

    @Override
    public long size() {
        return this.ontModel.size();
    }

    @Override
    public void write(Writer out, URI baseURI) {
        this.getWriter().write(out, baseURI);
    }

    @Override
    public void write(OutputStream out, URI baseURI) {
        this.getWriter().write(out, baseURI);
    }

    @Override
    public List<OWLIndividual> getNonLanguageIndividuals() {
        List<OWLClass> classes = this.getNonLanguageClasses();
        ArrayList<OWLIndividual> inds = new ArrayList<OWLIndividual>();
        for (OWLClass c : classes) {
            inds.addAll(this.getInstances(c, false));
        }
        return inds;
    }

    @Override
    public List<OWLClass> getNonLanguageClasses() {
        ExtendedIterator iter = this.ontModel.listNamedClasses();
        ArrayList<OWLClass> list = new ArrayList<OWLClass>();
        while (iter.hasNext()) {
            OntClass resource = (OntClass)iter.next();
            if (this.isInLanguageNamespace((Resource)resource)) continue;
            list.add(this.wrapClass(resource));
        }
        return list;
    }

    @Override
    public List<OWLDataProperty> getNonLanguageDataProperties() {
        ExtendedIterator iter = this.ontModel.listDatatypeProperties();
        ArrayList<OWLDataProperty> list = new ArrayList<OWLDataProperty>();
        while (iter.hasNext()) {
            DatatypeProperty property = (DatatypeProperty)iter.next();
            if (this.isInLanguageNamespace((Resource)property)) continue;
            list.add(this.wrapDataProperty(property));
        }
        return list;
    }

    @Override
    public List<OWLObjectProperty> getNonLanguageObjectProperties() {
        ExtendedIterator iter = this.ontModel.listObjectProperties();
        ArrayList<OWLObjectProperty> list = new ArrayList<OWLObjectProperty>();
        while (iter.hasNext()) {
            ObjectProperty property = (ObjectProperty)iter.next();
            if (this.isInLanguageNamespace((Resource)property)) continue;
            list.add(this.wrapObjectProperty(property));
        }
        return list;
    }

    @Override
    public void setProperty(OWLIndividual s, OWLDataProperty p, String o) {
        Resource subject = (Resource)s.getImplementation();
        Property predicate = (Property)p.getImplementation();
        this.removeProperty(s, p, null);
        this.ontModel.add(subject, predicate, o);
    }

    @Override
    public void setProperty(OWLIndividual s, OWLDataProperty p, Object o) {
        this.setProperty(s, p, this.createDataValue(o));
    }

    @Override
    public void setProperty(OWLIndividual s, OWLDataProperty p, OWLDataValue o) {
        Resource subject = (Resource)s.getImplementation();
        Property predicate = (Property)p.getImplementation();
        Literal object = (Literal)o.getImplementation();
        this.removeProperty(s, p, null);
        this.ontModel.add(subject, predicate, (RDFNode)object);
    }

    @Override
    public void addProperty(OWLIndividual s, OWLDataProperty p, OWLDataValue o) {
        this.ontModel.add((Resource)s.getImplementation(), (Property)p.getImplementation(), (RDFNode)((Literal)o.getImplementation()));
    }

    @Override
    public void addProperty(OWLIndividual s, OWLDataProperty p, String o) {
        this.ontModel.add((Resource)s.getImplementation(), (Property)p.getImplementation(), o);
    }

    @Override
    public void addProperty(OWLIndividual s, OWLDataProperty p, Object o) {
        this.addProperty(s, p, this.createDataValue(o));
    }

    @Override
    public void addProperty(OWLIndividual s, OWLObjectProperty p, OWLIndividual o) {
        this.ontModel.add((Resource)s.getImplementation(), (Property)p.getImplementation(), (RDFNode)((Resource)o.getImplementation()));
    }

    @Override
    public void setProperty(OWLIndividual s, OWLObjectProperty p, OWLIndividual o) {
        Resource subject = (Resource)s.getImplementation();
        Property predicate = (Property)p.getImplementation();
        Resource object = (Resource)o.getImplementation();
        this.removeProperty(s, p, null);
        this.ontModel.add(subject, predicate, (RDFNode)object);
    }

    @Override
    public void addType(OWLIndividual ind, OWLClass c) {
        this.ontModel.add((Resource)ind.getImplementation(), RDF.type, (RDFNode)((Resource)c.getImplementation()));
    }

    @Override
    public void remove(OWLIndividual ind, boolean recursive) {
        this.removeAll((Resource)ind.getImplementation(), recursive);
    }

    @Override
    public void removeProperty(OWLIndividual s, OWLProperty p, OWLValue o) {
        Resource subject = (Resource)s.getImplementation();
        Property predicate = (Property)p.getImplementation();
        RDFNode object = o == null ? null : (RDFNode)o.getImplementation();
        this.removeAll(subject, predicate, object);
    }

    @Override
    public void removeTypes(OWLIndividual ind) {
        Resource subject = (Resource)ind.getImplementation();
        this.removeAll(subject, RDF.type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OWLIndividual parseLiteral(String literal) {
        OntModel literalModel;
        StringReader in = new StringReader(literal);
        try {
            OntModelSpec spec = new OntModelSpec(this.ontModel.getSpecification());
            spec.setReasoner(null);
            spec.setReasonerFactory(null);
            literalModel = ModelFactory.createOntologyModel((OntModelSpec)spec);
            literalModel.read((Reader)in, this.getOntology().getURI().toString());
        }
        finally {
            in.close();
        }
        if (literalModel.isEmpty()) {
            logger.debug("Parsing XML/RDF literal resulted in empty model. This may indicate a syntax error.");
            return null;
        }
        this.ontModel.add((Model)literalModel, true);
        int outCount = 0;
        Resource result = null;
        ResIterator subjects = literalModel.listSubjects();
        while (subjects.hasNext()) {
            Resource tmp = (Resource)subjects.next();
            StmtIterator stmts = literalModel.listStatements(null, null, (RDFNode)tmp);
            if (stmts.hasNext()) {
                int newCount = tmp.listProperties().toList().size();
                if (result != null && newCount <= outCount) continue;
                result = tmp;
                outCount = newCount;
                continue;
            }
            result = tmp;
            break;
        }
        return result == null ? null : this.wrapIndividual((Resource)result.inModel((Model)this.ontModel).as(Resource.class));
    }

    @Override
    public void startBulkUpdate() {
        ++this.bulkUpdate;
    }

    @Override
    public void endBulkUpdate(boolean refresh) {
        if (this.bulkUpdate > 0) {
            --this.bulkUpdate;
        }
        if (refresh && this.bulkUpdate == 0) {
            this.refresh();
        }
    }

    @Override
    public boolean isBulkUpdate() {
        return this.bulkUpdate > 0;
    }

    protected abstract OWLOntologyImpl getOntology();

    protected abstract void reasonerSet(Reasoner var1);

    protected abstract void removeAll(Resource var1, Property var2, RDFNode var3);

    protected OWLIndividualList<?> getInstances(OWLClass c, Model model) {
        ResIterator it = this.ontModel.listResourcesWithProperty(RDF.type, (RDFNode)((Resource)c.getImplementation()));
        it = model != null ? it.filterKeep((Filter)new IsInModelFilter(model)) : it;
        return this.getAllIndividuals((ExtendedIterator<? extends RDFNode>)it);
    }

    protected boolean isInLanguageNamespace(String namespace) {
        return owlsNamespaces.isBuiltinNamespace(namespace);
    }

    protected boolean isInLanguageNamespace(Resource resource) {
        return owlsNamespaces.isBuiltinNamespace(resource.getNameSpace());
    }

    private boolean isPelletReasonerAttached() {
        return this.ontModel.getGraph() instanceof PelletInfGraph;
    }

    private void removeAll(Resource resource, boolean recursive) {
        if (recursive) {
            StmtIterator propIter = this.ontModel.listStatements(resource, null, (RDFNode)null);
            while (propIter.hasNext()) {
                RDFNode node = propIter.nextStatement().getObject();
                if (!node.isResource()) continue;
                this.removeAll((Resource)node, recursive);
            }
        }
        logger.debug("Removing all statements ({}, *, *)", (Object)resource);
        this.removeAll(resource, null, null);
        logger.debug("Removing all statements (*, *, {})", (Object)resource);
        this.removeAll(null, null, (RDFNode)resource);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IsInModelFilter
    extends Filter<Resource> {
        private final Model model;

        IsInModelFilter(Model model) {
            this.model = model;
        }

        public boolean accept(Resource item) {
            return this.model.containsResource((RDFNode)item);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class InModelMapper
    implements Map1<Resource, RDFNode> {
        InModelMapper() {
        }

        public RDFNode map1(Resource o) {
            return o.inModel((Model)OWLModelImpl.this.ontModel);
        }
    }
}

