/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import impl.jena.OWLKnowledgeBaseImpl;
import impl.jena.OWLModelImpl;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.utils.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLOntologyImpl
extends OWLModelImpl
implements OWLOntology {
    private boolean readOnly;
    private final OWLKnowledgeBaseImpl kb;
    private final URI uri;

    public OWLOntologyImpl(OWLKnowledgeBaseImpl kb, URI uri, OntModel jenaModel) {
        this(kb, uri, jenaModel, false);
    }

    public OWLOntologyImpl(OWLKnowledgeBaseImpl kb, URI uri, OntModel jenaModel, boolean readOnly) {
        super(jenaModel);
        assert (uri != null && kb != null) : "Ontology URI and/or KB parameter null";
        this.uri = uri;
        this.kb = kb;
        this.readOnly = readOnly;
    }

    @Override
    public OWLOntologyImpl getBaseModel() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)this.ontModel.getSpecification(), (Model)this.ontModel.getBaseModel());
        return new OWLOntologyImpl(this.kb, this.uri, model, this.readOnly);
    }

    @Override
    public OWLKnowledgeBaseImpl getKB() {
        return this.kb;
    }

    @Override
    public Set<OWLOntology> getImports(boolean closure) {
        return new HashSet<OWLOntology>(this.getImports0(closure));
    }

    @Override
    public void addImport(OWLOntology ontology) {
        this.checkNotReadOnly();
        this.addImport0((OWLOntologyImpl)ontology);
        this.refresh();
    }

    @Override
    public void addImports(Collection<OWLOntology> theImports) {
        this.checkNotReadOnly();
        this.startBulkUpdate();
        boolean refresh = theImports.size() > 0;
        for (OWLOntology aOnt : theImports) {
            this.addImport0((OWLOntologyImpl)aOnt);
        }
        this.endBulkUpdate(refresh);
    }

    @Override
    public boolean containsOntology(URI ontURI) {
        return ontURI != null && this.ontModel.hasLoadedImport(ontURI.toString());
    }

    @Override
    public void removeImport(OWLOntology ontology) {
        this.checkNotReadOnly();
        this.removeImport0(ontology);
        this.refresh();
    }

    @Override
    public void removeImports(Set<OWLOntology> theImports) {
        this.checkNotReadOnly();
        this.startBulkUpdate();
        boolean refresh = theImports.size() > 0;
        for (OWLOntology ont : theImports) {
            this.removeImport0(ont);
        }
        this.endBulkUpdate(refresh);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public String toString() {
        return "Ontology(" + this.uri + ")";
    }

    @Override
    public void refresh() {
        if (this.isBulkUpdate()) {
            return;
        }
        this.kb.refresh();
    }

    @Override
    public OWLOntology difference(OWLOntology ont) {
        OntModel diff = ModelFactory.createOntologyModel((OntModelSpec)this.ontModel.getSpecification(), (Model)this.ontModel.difference((Model)((OWLOntologyImpl)ont).ontModel));
        OWLKnowledgeBase newKB = OWLFactory.createKB();
        return newKB.createOntology(URI.create("urn:owl-s-api:difference:Ontology" + System.nanoTime()), diff);
    }

    @Override
    public OWLOntology intersection(OWLOntology ont) {
        OntModel intersection = ModelFactory.createOntologyModel((OntModelSpec)this.ontModel.getSpecification(), (Model)this.ontModel.intersection((Model)((OWLOntologyImpl)ont).ontModel));
        OWLKnowledgeBase newKB = OWLFactory.createKB();
        return newKB.createOntology(URI.create("urn:owl-s-api:intersection:Ontology" + System.nanoTime()), intersection);
    }

    @Override
    public OWLOntology union(OWLOntology ont) {
        OntModel union = ModelFactory.createOntologyModel((OntModelSpec)this.ontModel.getSpecification(), (Model)this.ontModel.union((Model)((OWLOntologyImpl)ont).ontModel));
        OWLKnowledgeBase newKB = OWLFactory.createKB();
        return newKB.createOntology(URI.create("urn:owl-s-api:union:Ontology" + System.nanoTime()), union);
    }

    @Override
    public void add(OWLOntology ont) {
        this.checkNotReadOnly();
        Model m = ((OWLOntologyImpl)ont).ontModel.getBaseModel();
        this.ontModel.getBaseModel().add(m);
        this.refresh();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public void removeAll(boolean includingImports) {
        this.checkNotReadOnly();
        if (includingImports) {
            this.removeImports(this.getImports(false));
        }
        this.ontModel.getBaseModel().removeAll();
        this.refresh();
    }

    protected final void checkNotReadOnly() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Read-only ontology cannot be modified.");
        }
    }

    @Override
    protected final OWLOntologyImpl getOntology() {
        return this;
    }

    @Override
    protected void reasonerSet(Reasoner oldReasoner) {
    }

    @Override
    protected void removeAll(Resource s, Property p, RDFNode o) {
        this.checkNotReadOnly();
        this.ontModel.removeAll(s, p, o);
    }

    private void addImport0(OWLOntologyImpl importOnt) {
        URI impURI = importOnt.getURI();
        String impURIasString = impURI.toString();
        if (this.ontModel.hasLoadedImport(impURIasString)) {
            return;
        }
        this.ontModel.getDocumentManager().loadImport(this.ontModel, impURIasString);
        Ontology o = this.ontModel.getOntology(this.uri.toString());
        if (o == null) {
            OntModel baseModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, (Model)this.ontModel.getBaseModel());
            ExtendedIterator it = baseModel.listOntologies();
            if (it.hasNext()) {
                o = (Ontology)it.next();
            }
            it.close();
            o = o == null ? this.ontModel.createOntology(this.uri.toString()) : (Ontology)o.inModel((Model)this.ontModel).as(Ontology.class);
        }
        o.addImport(this.ontModel.createResource(impURIasString));
        this.kb.add(impURI, importOnt);
    }

    Set<OWLOntologyImpl> getImports0(boolean closure) {
        HashSet<OWLOntologyImpl> imports = new HashSet<OWLOntologyImpl>((int)((double)this.ontModel.countSubModels() * 1.25));
        Set importURIs = this.ontModel.listImportedOntologyURIs(closure);
        for (String importURI : importURIs) {
            OntModel importModel = this.ontModel.getImportedModel(importURI);
            imports.add(new OWLOntologyImpl(this.kb, URIUtils.createURI(importURI), importModel, this.readOnly));
        }
        return imports;
    }

    private void removeImport0(OWLOntology ontology) {
        URI ontURI = ontology.getURI();
        String impURIasString = ontURI.toString();
        if (!this.ontModel.hasLoadedImport(impURIasString)) {
            return;
        }
        this.ontModel.getDocumentManager().unloadImport(this.ontModel, impURIasString);
        Ontology o = this.ontModel.getOntology(this.uri.toString());
        if (o != null) {
            o.removeImport(this.ontModel.createResource(impURIasString));
        }
        this.kb.remove(ontURI, ontology);
    }
}

