/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.shared.JenaException;
import impl.jena.JenaOWLProvider;
import impl.jena.OWLKnowledgeBaseImpl;
import impl.jena.OWLOntologyImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mindswap.owl.OWLErrorHandler;
import org.mindswap.owl.OWLReader;
import org.mindswap.owl.OWLSyntax;
import org.mindswap.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLReaderImpl
implements OWLReader {
    static final Logger logger = LoggerFactory.getLogger(OWLReaderImpl.class);
    OWLErrorHandler errHandler;
    private final ConcurrentHashMap<String, String> errorMsgMap;
    private final OWLKnowledgeBaseImpl kb;
    private boolean ignoreFailedImport;
    private OWLSyntax syntax;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLReaderImpl(OWLKnowledgeBaseImpl kb) {
        OntDocumentManager odm;
        this.kb = kb;
        this.ignoreFailedImport = false;
        this.syntax = OWLSyntax.RDFXML;
        OntDocumentManager ontDocumentManager = odm = kb.manager.getOntModelSpec().getDocumentManager();
        synchronized (ontDocumentManager) {
            FailureHandler fh;
            OntDocumentManager.ReadFailureHandler rfh = odm.getReadFailureHandler();
            if (rfh == null) {
                fh = new FailureHandler();
                odm.setReadFailureHandler((OntDocumentManager.ReadFailureHandler)fh);
            } else if (rfh instanceof FailureHandler) {
                fh = (FailureHandler)rfh;
            } else {
                logger.warn("{} has another {} already set. Failed attempts to read an ontology will not be reported!", (Object)OntDocumentManager.class.getSimpleName(), (Object)OntDocumentManager.ReadFailureHandler.class.getSimpleName());
                fh = null;
            }
            this.errorMsgMap = fh != null ? fh.errorMessageMap : null;
            kb.manager.setErrorMsgMap(this.errorMsgMap);
        }
    }

    @Override
    public OWLErrorHandler setErrorHandler(OWLErrorHandler newErrHandler) {
        OWLErrorHandler old = this.errHandler;
        this.errHandler = newErrHandler;
        return old;
    }

    @Override
    public OWLOntologyImpl read(URI url) throws IOException {
        return this.readInternal(null, null, url);
    }

    @Override
    public OWLOntologyImpl read(Reader in, URI baseURI) throws IOException {
        return this.readInternal(null, in, baseURI);
    }

    @Override
    public OWLOntologyImpl read(InputStream in, URI baseURI) throws IOException {
        return this.readInternal(in, null, baseURI);
    }

    @Override
    public void setIgnoreFailedImport(boolean ignore) {
        this.ignoreFailedImport = ignore;
    }

    @Override
    public boolean isIgnoreFailedImport() {
        return this.ignoreFailedImport;
    }

    @Override
    public void setSyntax(OWLSyntax syntax) {
        if (!OWLSyntax.RDFXML.equals((Object)syntax) && !OWLSyntax.TURTLE.equals((Object)syntax)) {
            throw new IllegalArgumentException("This read does not support " + (Object)((Object)syntax) + " syntax.");
        }
        this.syntax = syntax;
    }

    @Override
    public boolean supports(OWLSyntax stx) {
        switch (stx) {
            case RDFXML: 
            case TURTLE: {
                return true;
            }
        }
        return false;
    }

    private OWLOntologyImpl readInternal(InputStream stream, Reader reader, URI uri) throws IOException {
        URI ontURI = uri != null ? URIUtils.standardURI(uri) : URI.create("urn:owl-s-api:reader:Ontology" + System.nanoTime());
        OWLOntologyImpl ont = this.kb.getOntology(ontURI);
        if (ont != null) {
            logger.debug("Use already loaded ontology {} from given knowledge base.", (Object)ontURI);
        } else {
            String failures;
            OntModel jenaModel;
            String base;
            OntModelSpec spec = JenaOWLProvider.createOntSpec(this.kb.manager.getOntModelSpec());
            if (stream == null && reader == null) {
                if (uri == null) {
                    throw new IOException("URL of ontology to read required (URL null).");
                }
                base = ontURI.toString();
                logger.debug("Reading ontology {} via Jena's OntDocumentManager ...", (Object)base);
                jenaModel = spec.getDocumentManager().getOntology(base, spec);
            } else {
                RDFReader jenaReader;
                jenaModel = ModelFactory.createOntologyModel((OntModelSpec)spec);
                base = uri != null ? ontURI.toString() : null;
                RDFReader rDFReader = jenaReader = OWLSyntax.TURTLE.equals((Object)this.syntax) ? jenaModel.getReader("TURTLE") : jenaModel.getReader();
                if (this.errHandler != null) {
                    jenaReader.setErrorHandler((RDFErrorHandler)new DefaultErrorHandler());
                }
                try {
                    if (stream != null) {
                        logger.debug("Reading ontology from InputStream, using base URI {}  ...", (Object)base);
                        jenaReader.read((Model)jenaModel, stream, base);
                    } else if (reader != null) {
                        logger.debug("Reading ontology from Reader, using base URI {}  ...", (Object)base);
                        jenaReader.read((Model)jenaModel, reader, base);
                    }
                    spec.getDocumentManager().loadImports(jenaModel);
                }
                catch (JenaException e) {
                    throw new IOException("Failed to read resource. Details: " + (Object)((Object)e));
                }
                finally {
                    try {
                        if (stream != null) {
                            stream.close();
                        } else if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
            HashSet<String> ontsToCheck = new HashSet<String>();
            if (base != null) {
                ontsToCheck.add(base);
            }
            if (!this.ignoreFailedImport) {
                ontsToCheck.addAll(jenaModel.listImportedOntologyURIs(true));
            }
            if ((failures = this.hasReportedFailure(ontsToCheck)) != null) {
                throw new IOException("Failed to read ontology. Details: " + failures);
            }
            ont = this.kb.createOntology(ontURI, jenaModel);
        }
        return ont;
    }

    private String hasReportedFailure(Set<String> ontologyURIs) {
        StringBuilder failures = new StringBuilder();
        for (String ontURI : ontologyURIs) {
            String excMsg = this.errorMsgMap.get(ontURI);
            if (excMsg == null) continue;
            failures.append(excMsg).append(" ");
        }
        return failures.length() > 0 ? failures.toString() : null;
    }

    private static final class FailureHandler
    implements OntDocumentManager.ReadFailureHandler {
        final ConcurrentHashMap<String, String> errorMessageMap = new ConcurrentHashMap(8);

        FailureHandler() {
        }

        public void handleFailedRead(String url, Model model, Exception e) {
            String previous = this.errorMessageMap.put(url, e.toString() + " " + url);
            if (previous != null) {
                logger.debug("Bug indication: map already contained value for key. Jena cache seems to have changed.");
            }
        }
    }

    private final class DefaultErrorHandler
    implements RDFErrorHandler {
        DefaultErrorHandler() {
        }

        public void warning(Exception e) {
            OWLReaderImpl.this.errHandler.warning(e);
        }

        public void error(Exception e) {
            OWLReaderImpl.this.errHandler.error(e);
        }

        public void fatalError(Exception e) {
            OWLReaderImpl.this.errHandler.fatal(e);
        }
    }
}

