/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDFSyntax;
import impl.jena.OWLKnowledgeBaseImpl;
import impl.jena.OWLModelImpl;
import impl.jena.OWLOntologyImpl;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLSyntax;
import org.mindswap.owl.OWLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLWriterImpl
implements OWLWriter {
    private static final Charset defaultCharset = Charset.forName("UTF8");
    private final OWLModelImpl model;
    private final List<Object> prettyTypes;
    private final Map<String, String> prefixMap;
    private boolean showXmlDeclaration;
    private OWLSyntax syntax;

    public OWLWriterImpl(OWLModelImpl model) {
        this.model = model;
        this.prettyTypes = new ArrayList<Object>();
        this.prefixMap = new HashMap<String, String>();
        this.showXmlDeclaration = true;
        this.syntax = OWLSyntax.RDFXML;
    }

    @Override
    public boolean isShowXmlDeclaration() {
        return this.showXmlDeclaration;
    }

    @Override
    public void setShowXmlDeclaration(boolean showXmlDeclaration) {
        this.showXmlDeclaration = showXmlDeclaration;
    }

    @Override
    public void setTargetFormat(OWLSyntax syntax) {
        switch (syntax) {
            case RDFXML: 
            case TURTLE: {
                this.syntax = syntax;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported target format " + (Object)((Object)syntax) + ". Supported formats are " + (Object)((Object)OWLSyntax.RDFXML) + " and " + (Object)((Object)OWLSyntax.TURTLE));
            }
        }
    }

    private void writeInternal(Writer out, URI baseURI) {
        String baseURIasString;
        OntModel ontModel = null;
        String string = baseURIasString = baseURI != null ? baseURI.toString() : null;
        if (this.model instanceof OWLKnowledgeBaseImpl) {
            OWLKnowledgeBaseImpl kb = (OWLKnowledgeBaseImpl)this.model;
            ontModel = ModelFactory.createOntologyModel((OntModelSpec)kb.ontModel.getSpecification());
            Ontology aOntNode = ontModel.createOntology(baseURIasString);
            for (OWLOntology ontology : kb.getOntologies(false)) {
                Model baseModel = ((OWLOntologyImpl)ontology).getImplementation().getBaseModel();
                this.handle(ontModel, aOntNode, baseModel);
            }
        } else {
            ontModel = ((OWLOntologyImpl)this.model).getImplementation();
        }
        for (Map.Entry<String, String> entry : this.prefixMap.entrySet()) {
            ontModel.setNsPrefix(entry.getKey(), entry.getValue());
        }
        RDFWriter writer = this.getWriter(ontModel, baseURIasString);
        writer.write(ontModel.getBaseModel(), out, baseURIasString);
    }

    private RDFWriter getWriter(OntModel ontModel, String baseURI) {
        switch (this.syntax) {
            case TURTLE: {
                return ontModel.getWriter("TURTLE");
            }
        }
        return OWLWriterImpl.createJenaWriter(ontModel, baseURI, this.showXmlDeclaration, this.prettyTypes);
    }

    private void handle(OntModel outputModel, Ontology outputOnt, Model ontModel) {
        outputModel.add(ontModel);
        StmtIterator it = ontModel.listStatements(null, OWL.imports, (RDFNode)null);
        while (it.hasNext()) {
            Statement stmt = it.nextStatement();
            RDFNode node = stmt.getObject();
            if (node.isResource()) {
                outputOnt.addImport((Resource)node.as(Resource.class));
            }
            outputModel.removeAll(stmt.getSubject(), null, null);
        }
    }

    @Override
    public void setNsPrefix(String prefix, String uri) {
        this.prefixMap.put(prefix, uri);
    }

    @Override
    public void addPrettyType(OWLClass c) {
        this.prettyTypes.add(c.getImplementation());
    }

    @Override
    public void write(Writer writer, URI baseURI) {
        this.writeInternal(writer, baseURI);
    }

    @Override
    public void write(OutputStream out, URI baseURI) {
        this.writeInternal(new OutputStreamWriter(out, defaultCharset), baseURI);
    }

    static final RDFWriter createJenaWriter(OntModel ontModel, String baseURI, boolean showXmlDeclaration, List<Object> prettyTypes) {
        RDFWriter writer = ontModel.getWriter("RDF/XML-ABBREV");
        writer.setProperty("blockRules", (Object)new Resource[]{RDFSyntax.propertyAttr, RDFSyntax.sectionListExpand});
        writer.setProperty("showXmlDeclaration", (Object)showXmlDeclaration);
        writer.setProperty("allowBadURIs", (Object)Boolean.TRUE);
        writer.setProperty("prettyTypes", (Object)prettyTypes.toArray(new Resource[prettyTypes.size()]));
        if (baseURI != null) {
            writer.setProperty("xmlbase", (Object)baseURI);
            ontModel.setNsPrefix("", baseURI);
        }
        return writer;
    }
}

