/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import impl.jena.OWLKnowledgeBaseImpl;
import impl.jena.OWLModelImpl;
import impl.jena.StandardClosableIterator;
import impl.owls.expression.QuotedExpressionImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mindswap.common.ClosableIterator;
import org.mindswap.common.SingleClosableIterator;
import org.mindswap.common.Variable;
import org.mindswap.exceptions.InvalidOWLSException;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.expression.Condition;
import org.mindswap.owls.expression.Expression;
import org.mindswap.owls.expression.LogicLanguage;
import org.mindswap.owls.expression.VariableBinding;
import org.mindswap.owls.io.ExpressionWriter;
import org.mindswap.owls.io.ProcessWriter;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.query.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPARQLExpressionImpl
extends QuotedExpressionImpl<String>
implements Condition.SPARQL {
    private static final Logger logger = LoggerFactory.getLogger(SPARQLExpressionImpl.class);
    private Query query;

    public SPARQLExpressionImpl(OWLIndividual ind) {
        super(ind, OWLS_1_2.Expression.SPARQL, true);
    }

    public SPARQLExpressionImpl(OWLIndividual ind, boolean setLanguage) {
        super(ind, OWLS_1_2.Expression.SPARQL, setLanguage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate(ValueMap<?, ?> bindings) {
        block8: {
            if (this.query == null) {
                String queryString = this.getBody();
                if (queryString == null || queryString.length() == 0) {
                    return;
                }
                try {
                    this.query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxSPARQL);
                }
                catch (QueryException e) {
                    logger.error("Parse SPARQL expression {} failed. Details: {}", (Object)this, (Object)e.toString());
                    return;
                }
            }
            QueryExecution qexec = SPARQLExpressionImpl.createQueryExecution(this, this.getKB(), bindings, this.query);
            try {
                Model m = ((OWLKnowledgeBaseImpl)this.getKB()).getImplementation().getBaseModel();
                if (this.query.isConstructType()) {
                    qexec.execConstruct(m);
                    break block8;
                }
                throw new UnsupportedOperationException("Unsupported SPARQL query type in expression " + this + ". Only CONSTRUCT queries can be evaluated.");
            }
            finally {
                qexec.close();
            }
        }
    }

    @Override
    public final LogicLanguage getLanguage() {
        return OWLS_1_2.Expression.SPARQL;
    }

    @Override
    public String getBody() {
        OWLDataValue body = this.getQuotedBody();
        return body == null ? null : body.getValue().toString().trim();
    }

    @Override
    public void setBody(String body) {
        this.query = null;
        this.setQuotedBody(body);
    }

    @Override
    public boolean isTrue(ValueMap<?, ?> binding) {
        return this.isTrue(this.getKB(), binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTrue(OWLModel model, ValueMap<?, ?> binding) {
        boolean isTrue;
        ClosableIterator solutions = null;
        try {
            solutions = this.queryForSolutions(model, binding, Collections.emptyList());
            isTrue = solutions.hasNext();
        }
        finally {
            if (solutions != null) {
                solutions.close();
            }
        }
        return isTrue;
    }

    @Override
    public <V extends Variable> ClosableIterator<ValueMap<V, OWLValue>> solutions(ValueMap<?, ?> binding, List<V> resultVars) {
        return this.queryForSolutions(this.getKB(), binding, resultVars);
    }

    @Override
    public <V extends Variable> ClosableIterator<ValueMap<V, OWLValue>> solutions(OWLModel model, ValueMap<?, ?> binding, List<V> resultVars) {
        return this.queryForSolutions(model, binding, resultVars);
    }

    @Override
    public String toString() {
        String body = this.getBody();
        return body != null ? body : super.toString();
    }

    @Override
    public void writeTo(ProcessWriter procWriter, String indent) {
        ExpressionWriter<String> exprWriter = procWriter.getSparqlExpressionWriter();
        exprWriter.setIndent(indent);
        exprWriter.write(this);
    }

    static final QueryExecution createQueryExecution(Expression.SPARQL expression, OWLModel model, ValueMap<?, ?> initialBinding, Query query) {
        QueryExecution qexec;
        if (initialBinding == null || initialBinding.isEmpty()) {
            qexec = QueryExecutionFactory.create((Query)query, (Model)((OntModel)model.getImplementation()));
        } else {
            QuerySolutionMap queryInitBinding = new QuerySolutionMap();
            for (Map.Entry<?, ?> entry : initialBinding) {
                Variable var = (Variable)entry.getKey();
                OWLValue val = (OWLValue)entry.getValue();
                VariableBinding varBinding = expression.getVariableBinding(var.getName());
                if (varBinding == null) continue;
                String sparqlVar = SPARQLExpressionImpl.getSPARQLVariable(varBinding);
                queryInitBinding.add(sparqlVar, (RDFNode)val.getImplementation());
            }
            qexec = QueryExecutionFactory.create((Query)query, (Model)((OntModel)model.getImplementation()), (QuerySolution)queryInitBinding);
        }
        return qexec;
    }

    static final String getSPARQLVariable(VariableBinding varBinding) {
        String sparqlVar = varBinding.getExpressionVariable();
        if (sparqlVar == null || (sparqlVar = sparqlVar.trim()).length() == 0) {
            throw new InvalidOWLSException("Required property 'theVariable' is either missing or invalid for VariableBinding " + varBinding);
        }
        return sparqlVar.startsWith("?") || sparqlVar.startsWith("$") ? sparqlVar : "?" + sparqlVar;
    }

    private <V extends Variable> ClosableIterator<ValueMap<V, OWLValue>> queryForSolutions(OWLModel model, ValueMap<?, ?> initialBinding, List<V> resultVars) {
        if (this.query == null) {
            String queryString = this.getBody();
            if (queryString == null || queryString.length() == 0) {
                return SingleClosableIterator.oneElement();
            }
            try {
                this.query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxSPARQL);
            }
            catch (QueryException e) {
                logger.error("Parse SPARQL expression {} failed. Details: {}", (Object)this, (Object)e.toString());
                return SingleClosableIterator.noElement();
            }
        }
        QueryExecution qexec = SPARQLExpressionImpl.createQueryExecution(this, model, initialBinding, this.query);
        if (this.query.isAskType()) {
            return qexec.execAsk() ? SingleClosableIterator.oneElement() : SingleClosableIterator.noElement();
        }
        if (this.query.isSelectType()) {
            ResultSet solutions = qexec.execSelect();
            return new StandardClosableIterator<V>((OWLModelImpl)model, solutions, resultVars, qexec);
        }
        throw new UnsupportedOperationException("Unsupported SPARQL query type in condition " + this + ". Either SELECT or ASK query must be used to express conditions.");
    }
}

