/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import impl.jena.OWLDataValueImpl;
import impl.jena.OWLKnowledgeBaseImpl;
import impl.jena.SPARQLExpressionImpl;
import java.util.Map;
import org.mindswap.exceptions.DataFlowException;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.expression.Expression;
import org.mindswap.owls.expression.VariableBinding;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.variable.Binding;
import org.mindswap.owls.process.variable.ParameterValueVisitor;
import org.mindswap.owls.process.variable.ProcessVar;
import org.mindswap.owls.process.variable.ValueFunction;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.RDFUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPARQLValueFunction
implements ValueFunction<Expression.SPARQL> {
    private static final Logger logger = LoggerFactory.getLogger(SPARQLValueFunction.class);
    private Expression.SPARQL expression;
    private final Binding<?> enclosingBinding;

    public SPARQLValueFunction(Expression.SPARQL expression, Binding<?> enclosingBinding) {
        this.expression = expression;
        this.enclosingBinding = enclosingBinding;
    }

    @Override
    public void accept(ParameterValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression.SPARQL getFunction() {
        return this.expression;
    }

    @Override
    public void removeFunction() {
        this.enclosingBinding.removeProperty(OWLS_1_2.Process.valueFunction, null);
    }

    @Override
    public void setFunction(Expression.SPARQL expression) {
        this.expression = expression;
        this.setTo(this.enclosingBinding);
    }

    @Override
    public Binding<?> getEnclosingBinding() {
        return this.enclosingBinding;
    }

    @Override
    public OWLValue getValueFromPerformResults(Map<Perform, ValueMap<ProcessVar, OWLValue>> performsResults) throws DataFlowException {
        Query query;
        String queryString = (String)this.expression.getBody();
        if (queryString == null || queryString.length() == 0) {
            throw new DataFlowException("Invalid value function in binding " + this.enclosingBinding + ". SPARQL expression without or empty body.");
        }
        try {
            query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxSPARQL);
        }
        catch (QueryException e) {
            throw new DataFlowException(e);
        }
        QueryExecution qexec = SPARQLExpressionImpl.createQueryExecution(this.expression, this.enclosingBinding.getKB(), performsResults.get(OWLS_1_2.Process.ThisPerform), query);
        try {
            if (query.isSelectType()) {
                OWLValue value = null;
                ResultSet solutions = qexec.execSelect();
                if (solutions.hasNext()) {
                    value = this.retrieveOWLValue(solutions.next());
                    if (solutions.hasNext()) {
                        logger.debug("Value function in binding {} has more than one solution. First solution found used to bind the process variable!", this.enclosingBinding);
                    }
                } else {
                    logger.debug("Value function in binding {} has no solution. Process variable was not bound to value!", this.enclosingBinding);
                }
                OWLValue oWLValue = value;
                return oWLValue;
            }
            throw new DataFlowException("Unsupported SPAQRL query type used in value function of binding " + this.enclosingBinding + ". Only SELECT queries can be used.");
        }
        finally {
            qexec.close();
        }
    }

    @Override
    public void setToBinding(Binding<?> binding) {
        this.setTo(binding);
    }

    private void setTo(Binding<?> binding) {
        binding.setProperty(OWLS_1_2.Process.valueFunction, RDFUtils.toXMLLiteral(this.expression));
    }

    public String toString() {
        return "SPARQL value function, Query: " + (String)this.expression.getBody();
    }

    private OWLValue retrieveOWLValue(QuerySolution solution) {
        OWLIndividualList<VariableBinding> varBindings = this.expression.getVariableBindings();
        OWLValue value = null;
        for (VariableBinding varBinding : varBindings) {
            String varName = SPARQLExpressionImpl.getSPARQLVariable(varBinding);
            RDFNode resultValue = solution.get(varName);
            if (resultValue == null) continue;
            if (resultValue.isLiteral()) {
                value = new OWLDataValueImpl((Literal)resultValue.as(Literal.class));
                break;
            }
            value = ((OWLKnowledgeBaseImpl)this.enclosingBinding.getKB()).wrapIndividual((Resource)resultValue.as(Resource.class));
            break;
        }
        if (value == null) {
            logger.debug("Process variable could not be bound from binding {}. Query solution exists but value for variable was not found in the solution according to VariableBinding(s). This is likely caused by incomplete or false VariableBinding specifications.", this.enclosingBinding);
        }
        return value;
    }
}

