/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingFactory;
import com.hp.hpl.jena.sparql.expr.E_Add;
import com.hp.hpl.jena.sparql.expr.E_Divide;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_GreaterThan;
import com.hp.hpl.jena.sparql.expr.E_GreaterThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_LessThan;
import com.hp.hpl.jena.sparql.expr.E_LessThanOrEqual;
import com.hp.hpl.jena.sparql.expr.E_Multiply;
import com.hp.hpl.jena.sparql.expr.E_NotEquals;
import com.hp.hpl.jena.sparql.expr.E_Subtract;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnvBase;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mindswap.common.Variable;
import org.mindswap.exceptions.UnsupportedSWRLAtomException;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.OWLList;
import org.mindswap.owl.vocabulary.SWRL;
import org.mindswap.owl.vocabulary.SWRLB;
import org.mindswap.query.ABoxQuery;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomVisitor;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.ClassAtom;
import org.mindswap.swrl.DataPropertyAtom;
import org.mindswap.swrl.DifferentIndividualsAtom;
import org.mindswap.swrl.IndividualPropertyAtom;
import org.mindswap.swrl.SWRLDataObject;
import org.mindswap.swrl.SameIndividualAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SWRLAtomToSparqlQuery
implements AtomVisitor {
    private static final Binding NULL_BINDING = BindingFactory.binding();
    private final OntModel ontModel;
    private final QuerySolutionMap queryInitialBinding;
    private final ElementGroup constraints;

    SWRLAtomToSparqlQuery(OntModel ontModel, QuerySolutionMap queryInitialBinding, ElementGroup constraintsGroup) {
        this.ontModel = ontModel;
        this.queryInitialBinding = queryInitialBinding;
        this.constraints = constraintsGroup;
    }

    static final Query makeQuery(OntModel model, OWLList<Atom> atoms, List<? extends Variable> resultVars, QuerySolutionMap initialBindings) {
        ElementGroup constraints = new ElementGroup();
        SWRLAtomToSparqlQuery visitor = new SWRLAtomToSparqlQuery(model, initialBindings, constraints);
        for (Atom atom : atoms) {
            atom.accept(visitor);
        }
        Query query = QueryFactory.make();
        query.setQuerySelectType();
        query.setQueryPattern((Element)constraints);
        if (resultVars == null || resultVars.isEmpty()) {
            query.setQueryResultStar(true);
        } else {
            for (Variable variable : resultVars) {
                query.addResultVar(variable.getName());
            }
        }
        return query;
    }

    static final QueryExecution makeQueryExecution(OntModel model, ABoxQuery<?> aboxQuery) {
        return SWRLAtomToSparqlQuery.makeQueryExecution(model, aboxQuery.getBody(), aboxQuery.getResultVariables(), null);
    }

    static final QueryExecution makeQueryExecution(OntModel model, OWLList<Atom> atoms, List<? extends Variable> resultVars, ValueMap<?, ?> binding) {
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        if (binding != null) {
            for (Map.Entry<?, ?> entry : binding) {
                initialBinding.add(((Variable)entry.getKey()).getName(), (RDFNode)((OWLValue)entry.getValue()).getImplementation());
            }
        }
        return QueryExecutionFactory.create((Query)SWRLAtomToSparqlQuery.makeQuery(model, atoms, resultVars, initialBinding), (Model)model, (QuerySolution)initialBinding);
    }

    @Override
    public void visit(BuiltinAtom atom) {
        OWLIndividual builtin = atom.getBuiltin();
        ArrayList<ExprVar> args = new ArrayList<ExprVar>(3);
        for (SWRLDataObject o : atom.getArguments()) {
            Node n = this.makeNode(o);
            args.add((ExprVar)(n.isVariable() ? new ExprVar(n.getName()) : NodeValue.makeNode((Node)n)));
        }
        Expr a2 = null;
        if (args.size() < 2 || args.size() > 3) {
            throw new UnsupportedSWRLAtomException("Number of arguments in SWRL built-in atom " + atom + " invalid (<2), or unsupported (>3).");
        }
        Expr a0 = (Expr)args.get(0);
        Expr a1 = (Expr)args.get(1);
        if (args.size() == 3) {
            a2 = (Expr)args.get(2);
        }
        E_Equals c = null;
        if (SWRLB.equal.equals(builtin)) {
            c = new E_Equals(a0, a1);
        } else if (SWRLB.notEqual.equals(builtin)) {
            c = new E_NotEquals(a0, a1);
        } else if (SWRLB.greaterThan.equals(builtin)) {
            c = new E_GreaterThan(a0, a1);
        } else if (SWRLB.greaterThanOrEqual.equals(builtin)) {
            c = new E_GreaterThanOrEqual(a0, a1);
        } else if (SWRLB.lessThan.equals(builtin)) {
            c = new E_LessThan(a0, a1);
        } else if (SWRLB.lessThanOrEqual.equals(builtin)) {
            c = new E_LessThanOrEqual(a0, a1);
        } else if (SWRLB.add.equals(builtin) && a2 != null) {
            if (!a0.isConstant() && a1.isConstant() && a2.isConstant()) {
                this.eval((Expr)new E_Add(a1, a2), a0);
            } else if (a0.isConstant() && !a1.isConstant() && a2.isConstant()) {
                this.eval((Expr)new E_Subtract(a0, a2), a1);
            } else if (a0.isConstant() && a1.isConstant() && !a2.isConstant()) {
                this.eval((Expr)new E_Subtract(a0, a1), a2);
            } else {
                c = new E_Equals(a0, (Expr)new E_Add(a1, a2));
            }
        } else if (SWRLB.subtract.equals(builtin) && a2 != null) {
            if (!a0.isConstant() && a1.isConstant() && a2.isConstant()) {
                this.eval((Expr)new E_Subtract(a1, a2), a0);
            } else if (a0.isConstant() && !a1.isConstant() && a2.isConstant()) {
                this.eval((Expr)new E_Add(a0, a2), a1);
            } else if (a0.isConstant() && a1.isConstant() && !a2.isConstant()) {
                this.eval((Expr)new E_Subtract(a1, a0), a2);
            } else {
                c = new E_Equals(a0, (Expr)new E_Subtract(a1, a2));
            }
        } else if (SWRLB.multiply.equals(builtin) && a2 != null) {
            if (!a0.isConstant() && a1.isConstant() && a2.isConstant()) {
                this.eval((Expr)new E_Multiply(a1, a2), a0);
            } else if (a0.isConstant() && !a1.isConstant() && a2.isConstant()) {
                this.eval((Expr)new E_Divide(a0, a2), a1);
            } else if (a0.isConstant() && a1.isConstant() && !a2.isConstant()) {
                this.eval((Expr)new E_Divide(a0, a1), a2);
            } else {
                c = new E_Equals(a0, (Expr)new E_Multiply(a1, a2));
            }
        } else if (SWRLB.divide.equals(builtin) && a2 != null) {
            if (!a0.isConstant() && a1.isConstant() && a2.isConstant()) {
                this.eval((Expr)new E_Divide(a1, a2), a0);
            } else if (a0.isConstant() && !a1.isConstant() && a2.isConstant()) {
                this.eval((Expr)new E_Multiply(a0, a2), a1);
            } else if (a0.isConstant() && a1.isConstant() && !a2.isConstant()) {
                this.eval((Expr)new E_Divide(a1, a0), a2);
            } else {
                c = new E_Equals(a0, (Expr)new E_Divide(a1, a2));
            }
        } else {
            throw new UnsupportedSWRLAtomException("Transformation to SPARQL constraint is not supported/implemented for SWRL built-in atom " + atom);
        }
        if (c != null) {
            this.constraints.addElement((Element)new ElementFilter((Expr)c));
        }
    }

    @Override
    public void visit(ClassAtom a) {
        this.addTriplePattern(a.getArgument1(), RDF.type.asNode(), a.getProperty(SWRL.classPredicate));
    }

    @Override
    public void visit(DataPropertyAtom a) {
        this.addTriplePattern(a.getArgument1(), this.makeNode(a.getProperty(SWRL.propertyPredicate)), a.getArgument2());
    }

    @Override
    public void visit(DifferentIndividualsAtom a) {
        this.addTriplePattern(a.getArgument1(), OWL.differentFrom.asNode(), a.getArgument2());
    }

    @Override
    public void visit(IndividualPropertyAtom a) {
        this.addTriplePattern(a.getArgument1(), this.makeNode(a.getProperty(SWRL.propertyPredicate)), a.getArgument2());
    }

    @Override
    public void visit(SameIndividualAtom a) {
        this.addTriplePattern(a.getArgument1(), OWL.sameAs.asNode(), a.getArgument2());
    }

    private final void addTriplePattern(OWLObject s, Node p, OWLObject o) {
        this.constraints.addTriplePattern(Triple.create((Node)this.makeNode(s), (Node)p, (Node)this.makeNode(o)));
    }

    private final void eval(Expr expr, Expr resultVar) {
        NodeValue result = expr.eval(NULL_BINDING, FunctionEnvBase.createTest());
        this.queryInitialBinding.add(resultVar.getVarName(), this.ontModel.asRDFNode(result.getConstant().asNode()));
    }

    private final Node makeNode(OWLObject term) {
        if (term instanceof Variable) {
            String varName = ((Variable)((Object)term)).getName();
            if (varName == null || varName.trim().equals("")) {
                throw new IllegalArgumentException("Variable " + term + " has no or empty name! " + "This is usually caused by anon resources. Make sure that variable has a URI.");
            }
            return Var.alloc((Node)Node.createVariable((String)varName));
        }
        return ((RDFNode)term.getImplementation()).asNode();
    }
}

