/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import impl.jena.OWLModelImpl;
import impl.jena.StandardPreparedQuery;
import impl.owls.expression.ExpressionImpl;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.mindswap.common.ClosableIterator;
import org.mindswap.common.SingleClosableIterator;
import org.mindswap.common.Variable;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.OWLList;
import org.mindswap.owl.vocabulary.SWRL;
import org.mindswap.owls.expression.Condition;
import org.mindswap.owls.expression.LogicLanguage;
import org.mindswap.owls.io.ExpressionWriter;
import org.mindswap.owls.io.ProcessWriter;
import org.mindswap.owls.vocabulary.OWLS_1_2;
import org.mindswap.query.Query;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLExpressionImpl
extends ExpressionImpl<OWLList<Atom>>
implements Condition.SWRL {
    private Query<?> query;

    public SWRLExpressionImpl(OWLIndividual ind, boolean setLanguage) {
        super(ind, OWLS_1_2.Expression.SWRL, setLanguage);
    }

    public SWRLExpressionImpl(OWLIndividual ind) {
        super(ind, OWLS_1_2.Expression.SWRL, true);
    }

    @Override
    public void evaluate(ValueMap<?, ?> bindings) {
        Iterator i$ = this.getBody().iterator();
        while (i$.hasNext()) {
            Atom atom = (Atom)i$.next();
            atom.evaluate(bindings);
        }
    }

    @Override
    public final LogicLanguage getLanguage() {
        return OWLS_1_2.Expression.SWRL;
    }

    @Override
    public OWLList<Atom> getBody() {
        OWLIndividual ind = this.getOntology().getProperty((OWLIndividual)this, OWLS_1_2.Expression.expressionObject);
        return ind == null ? null : ind.castToList(SWRL.AtomListVocabulary);
    }

    @Override
    public void setBody(OWLList<Atom> body) {
        this.query = null;
        this.setUnquotedBody(body);
    }

    @Override
    public boolean isTrue(ValueMap<?, ?> binding) {
        return this.isTrue(this.getKB(), binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTrue(OWLModel model, ValueMap<?, ?> binding) {
        boolean isTrue;
        ClosableIterator solutions = this.solutions(model, binding, Collections.emptyList());
        try {
            isTrue = solutions.hasNext();
        }
        finally {
            solutions.close();
        }
        return isTrue;
    }

    @Override
    public <V extends Variable> ClosableIterator<ValueMap<V, OWLValue>> solutions(ValueMap<?, ?> binding, List<V> resultVars) {
        return this.solutions(this.getKB(), binding, resultVars);
    }

    @Override
    public <V extends Variable> ClosableIterator<ValueMap<V, OWLValue>> solutions(OWLModel model, ValueMap<?, ?> binding, List<V> resultVars) {
        if (this.query == null) {
            Object atoms = this.getBody();
            if (atoms == null || atoms.isEmpty()) {
                return SingleClosableIterator.oneElement();
            }
            this.query = new StandardPreparedQuery((OWLList<Atom>)atoms, resultVars, (OWLModelImpl)model);
        }
        return this.query.execute(binding);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator i$ = this.getBody().iterator();
        while (i$.hasNext()) {
            Atom atom = (Atom)i$.next();
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(atom.toString());
        }
        return sb.length() > 0 ? sb.toString() : super.toString();
    }

    @Override
    public void writeTo(ProcessWriter procWriter, String indent) {
        ExpressionWriter<OWLList<Atom>> exprWriter = procWriter.getSwrlExpressionWriter();
        exprWriter.setIndent(indent);
        exprWriter.write(this);
    }
}

