/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import impl.jena.OWLModelImpl;
import java.util.ArrayList;
import java.util.List;
import org.mindswap.common.ClosableIterator;
import org.mindswap.common.OrdinaryVariable;
import org.mindswap.common.Variable;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLValue;
import org.mindswap.query.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StandardClosableIterator<V extends Variable>
implements ClosableIterator<ValueMap<V, OWLValue>> {
    private final OWLModelImpl model;
    private final ResultSet results;
    private final List<V> resultVars;
    private final QueryExecution qexec;

    StandardClosableIterator(OWLModelImpl model, ResultSet results, List<V> resultVars, QueryExecution qexec) {
        this.model = model;
        this.results = results;
        this.resultVars = resultVars;
        this.qexec = qexec;
    }

    @Override
    public void close() {
        this.qexec.close();
    }

    @Override
    public boolean hasNext() {
        return this.results.hasNext();
    }

    @Override
    public void remove() {
        this.results.remove();
    }

    @Override
    public ValueMap<V, OWLValue> next() {
        QuerySolution querySolution = this.results.next();
        ValueMap<Variable, OWLDataValue> solution = new ValueMap<Variable, OWLDataValue>();
        for (Variable var : this.resultVars) {
            RDFNode value = querySolution.get(var.getName());
            if (value == null) continue;
            OWLValue owlValue = value.isLiteral() ? this.model.wrapDataValue((Literal)value.as(Literal.class)) : this.model.wrapIndividual((Resource)value.as(OntResource.class));
            solution.setValue(var, (OWLDataValue)owlValue);
        }
        return solution;
    }

    public static final StandardClosableIterator<Variable> create(OWLModelImpl model, ResultSet results, List<String> resultVarNames, QueryExecution qexec) {
        ArrayList<OrdinaryVariable> resultVars = new ArrayList<OrdinaryVariable>();
        if (resultVarNames != null) {
            for (String varName : resultVarNames) {
                resultVars.add(new OrdinaryVariable(varName));
            }
        }
        return new StandardClosableIterator<Variable>(model, results, resultVars, qexec);
    }
}

