/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import impl.jena.OWLModelImpl;
import impl.jena.SWRLAtomToSparqlQuery;
import impl.jena.StandardClosableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mindswap.common.ClosableIterator;
import org.mindswap.common.OrdinaryVariable;
import org.mindswap.common.SingleClosableIterator;
import org.mindswap.common.Variable;
import org.mindswap.exceptions.ParseException;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.OWLList;
import org.mindswap.query.ABoxQuery;
import org.mindswap.query.Query;
import org.mindswap.query.QueryLanguage;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StandardPreparedQuery<V extends Variable>
implements Query<V> {
    private OWLModelImpl model;
    private final List<V> resultVars;
    private final com.hp.hpl.jena.query.Query query;
    private final QuerySolutionMap fixedInitialBinding;

    StandardPreparedQuery(ABoxQuery<V> query, OWLModelImpl model) {
        this(query.getBody(), query.getResultVariables(), model);
    }

    StandardPreparedQuery(OWLList<Atom> atoms, List<V> resultVars, OWLModelImpl model) {
        this.model = model;
        this.resultVars = resultVars;
        this.fixedInitialBinding = new QuerySolutionMap();
        this.query = SWRLAtomToSparqlQuery.makeQuery(model.getImplementation(), atoms, resultVars, this.fixedInitialBinding);
    }

    StandardPreparedQuery(com.hp.hpl.jena.query.Query query, List<V> resultVars, OWLModelImpl model) {
        this.query = query;
        this.model = model;
        this.resultVars = resultVars;
        this.fixedInitialBinding = new QuerySolutionMap();
    }

    @Override
    public StandardPreparedQuery<V> attach(OWLModel m) {
        if (m == null || !(m instanceof OWLModelImpl)) {
            throw new IllegalArgumentException("Model null or not an instance of OWLModelImpl.");
        }
        this.model = (OWLModelImpl)m;
        return this;
    }

    @Override
    public ClosableIterator<ValueMap<V, OWLValue>> execute(ValueMap<?, ?> binding) {
        QueryExecution qexec = QueryExecutionFactory.create((com.hp.hpl.jena.query.Query)this.query, (Model)this.model.getImplementation(), (QuerySolution)this.getInitialBinding(binding));
        if (this.query.isAskType()) {
            return qexec.execAsk() ? SingleClosableIterator.oneElement() : SingleClosableIterator.noElement();
        }
        if (this.query.isSelectType()) {
            return new StandardClosableIterator<V>(this.model, qexec.execSelect(), this.resultVars, qexec);
        }
        throw new IllegalArgumentException("Unsupported query type for " + this.query + ". Only SELECT or ASK query can be used.");
    }

    private QuerySolution getInitialBinding(ValueMap<?, ?> binding) {
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.addAll(this.fixedInitialBinding);
        if (binding != null) {
            for (Map.Entry<?, ?> entry : binding) {
                initialBinding.add(((Variable)entry.getKey()).getName(), (RDFNode)((OWLValue)entry.getValue()).getImplementation());
            }
        }
        return initialBinding;
    }

    @Override
    public List<V> getResultVariables() {
        return Collections.unmodifiableList(this.resultVars);
    }

    @Override
    public QueryLanguage getQueryLanguage() {
        if (Syntax.syntaxSPARQL.equals((Object)this.query.getSyntax())) {
            return QueryLanguage.SPARQL;
        }
        return QueryLanguage.RDQL;
    }

    static final StandardPreparedQuery<Variable> createQuery(String queryString, QueryLanguage lang, OWLModelImpl model) throws ParseException {
        com.hp.hpl.jena.query.Query query;
        try {
            switch (lang) {
                case RDQL: {
                    query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxRDQL);
                    break;
                }
                default: {
                    query = QueryFactory.create((String)queryString, (Syntax)Syntax.syntaxSPARQL);
                    break;
                }
            }
        }
        catch (QueryException e) {
            throw new ParseException((Object)queryString, (Throwable)e);
        }
        List varNames = query.getResultVars();
        ArrayList<OrdinaryVariable> resultVars = new ArrayList<OrdinaryVariable>(varNames.size());
        for (String varName : varNames) {
            resultVars.add(new OrdinaryVariable(varName));
        }
        return new StandardPreparedQuery<Variable>(query, resultVars, model);
    }
}

