/*
 * Decompiled with CFR 0.152.
 */
package impl.owl;

import java.util.List;
import org.mindswap.exceptions.CastingException;
import org.mindswap.owl.OWLObject;
import org.mindswap.owl.OWLObjectConverter;
import org.mindswap.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedOWLConverter<T extends OWLObject>
implements OWLObjectConverter<T> {
    private final List<OWLObjectConverter<? extends T>> converters;
    private final Class<T> target;

    public CombinedOWLConverter(Class<T> target, List<OWLObjectConverter<? extends T>> converters) {
        assert (target != null && converters != null) : "Illegal: Either Java class and/or converter list was null.";
        this.converters = converters;
        this.target = target;
    }

    @Override
    public boolean canCast(OWLObject object, boolean strictConversion) {
        for (OWLObjectConverter<T> converter : this.converters) {
            if (!converter.canCast(object, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T cast(OWLObject object, boolean strictConversion) {
        for (OWLObjectConverter<T> converter : this.converters) {
            if (!converter.canCast(object, true)) continue;
            return converter.cast(object, true);
        }
        throw CastingException.create(object, this.target);
    }

    public boolean addConverter(OWLObjectConverter<? extends T> converter) {
        if (this.converters.contains(converter)) {
            return false;
        }
        return this.converters.add(converter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Combined converter -> ").append(this.target);
        sb.append(", consisting of:").append(Utils.LINE_SEPARATOR);
        for (OWLObjectConverter<T> converter : this.converters) {
            sb.append(converter.toString()).append(Utils.LINE_SEPARATOR);
        }
        return sb.toString();
    }
}

